/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public class NonSerializableFactory
/*     */   implements ObjectFactory
/*     */ {
/*  52 */   private static Map wrapperMap = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   public static void unbind(Context ctx, String strName) throws NamingException
/*     */   {
/*  56 */     Name name = ctx.getNameParser("").parse(strName);
/*  57 */     int size = name.size();
/*  58 */     String atom = name.get(size - 1);
/*  59 */     Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
/*  60 */     String key = parentCtx.getNameInNamespace() + "/" + atom;
/*  61 */     wrapperMap.remove(key);
/*  62 */     Util.unbind(ctx, strName);
/*     */   }
/*     */ 
/*     */   public static void rebind(Context ctx, String strName, Object value)
/*     */     throws NamingException
/*     */   {
/*  68 */     Name name = ctx.getNameParser("").parse(strName);
/*  69 */     int size = name.size();
/*  70 */     String atom = name.get(size - 1);
/*  71 */     Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
/*  72 */     String key = parentCtx.getNameInNamespace() + "/" + atom;
/*  73 */     wrapperMap.put(key, value);
/*  74 */     String className = value.getClass().getName();
/*  75 */     String factory = NonSerializableFactory.class.getName();
/*  76 */     StringRefAddr addr = new StringRefAddr("nns", key);
/*  77 */     Reference memoryRef = new Reference(className, addr, factory, null);
/*  78 */     parentCtx.rebind(atom, memoryRef);
/*     */   }
/*     */ 
/*     */   public static void bind(Context ctx, String strName, Object value) throws NamingException
/*     */   {
/*  83 */     Name name = ctx.getNameParser("").parse(strName);
/*  84 */     int size = name.size();
/*  85 */     String atom = name.get(size - 1);
/*  86 */     Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
/*  87 */     String key = parentCtx.getNameInNamespace() + "/" + atom;
/*  88 */     wrapperMap.put(key, value);
/*  89 */     String className = value.getClass().getName();
/*  90 */     String factory = NonSerializableFactory.class.getName();
/*  91 */     StringRefAddr addr = new StringRefAddr("nns", key);
/*  92 */     Reference memoryRef = new Reference(className, addr, factory, null);
/*     */ 
/*  94 */     parentCtx.bind(atom, memoryRef);
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env)
/*     */     throws Exception
/*     */   {
/* 100 */     Reference ref = (Reference)obj;
/* 101 */     RefAddr addr = ref.get("nns");
/* 102 */     String key = (String)addr.getContent();
/* 103 */     return wrapperMap.get(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.NonSerializableFactory
 * JD-Core Version:    0.6.0
 */