/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.SupplyMetaData;
/*     */ import org.jboss.ejb3.embedded.resource.RARDeployment;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MCKernelAbstraction extends MCClientKernelAbstraction
/*     */   implements KernelAbstraction
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(MCKernelAbstraction.class);
/*     */   private MBeanServer server;
/*     */ 
/*     */   public MCKernelAbstraction(Kernel kernel, MBeanServer server)
/*     */   {
/*  86 */     super(kernel);
/*  87 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer server)
/*     */   {
/*  92 */     this.server = server;
/*     */   }
/*     */ 
/*     */   private boolean hasOperation(MBeanInfo info, String operationName)
/*     */   {
/*  97 */     for (MBeanOperationInfo operationInfo : info.getOperations())
/*     */     {
/*  99 */       if (!operationInfo.getName().equals(operationName))
/*     */       {
/*     */         continue;
/*     */       }
/* 103 */       if (!operationInfo.getReturnType().equals("void"))
/*     */       {
/*     */         continue;
/*     */       }
/* 107 */       if (operationInfo.getSignature().length == 0)
/*     */       {
/* 110 */         return true;
/*     */       }
/*     */     }
/* 113 */     return false;
/*     */   }
/*     */ 
/*     */   public void install(String name, DependencyPolicy dependencies, Object service)
/*     */   {
/* 118 */     AbstractBeanMetaData bean = new AbstractBeanMetaData(name, service.getClass().getName());
/* 119 */     bean.setConstructor(new AlreadyInstantiated(service));
/* 120 */     MCDependencyPolicy policy = (MCDependencyPolicy)dependencies;
/* 121 */     bean.setDepends(policy.getDependencies());
/* 122 */     bean.setDemands(policy.getDemands());
/* 123 */     bean.setSupplies(policy.getSupplies());
/* 124 */     log.info("installing bean: " + name + " with dependencies:");
/* 125 */     for (Object obj : policy.getDependencies())
/*     */     {
/*     */       String msg;
/*     */       String msg;
/* 128 */       if ((obj instanceof AbstractDemandMetaData))
/*     */       {
/* 130 */         msg = ((AbstractDemandMetaData)obj).getDemand().toString();
/*     */       }
/*     */       else
/*     */       {
/* 134 */         msg = obj.toString();
/*     */       }
/* 136 */       log.info("\t" + msg);
/*     */     }
/* 138 */     log.info("  and supplies:");
/* 139 */     for (SupplyMetaData smd : policy.getSupplies())
/*     */     {
/* 141 */       log.info("\t" + smd.getSupply().toString());
/*     */     }
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 147 */         this.kernel.getController().uninstall(name);
/*     */       }
/*     */       catch (IllegalStateException e) {
/*     */       }
/* 151 */       this.kernel.getController().install(bean);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 155 */       throw new RuntimeException(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void installMBean(ObjectName on, DependencyPolicy dependencies, Object service)
/*     */   {
/*     */     try
/*     */     {
/* 163 */       this.server.registerMBean(service, on);
/* 164 */       install(on.getCanonicalName(), dependencies, service);
/*     */ 
/* 167 */       MBeanInfo info = this.server.getMBeanInfo(on);
/* 168 */       invokeOptionalMethod(on, info, "create");
/* 169 */       invokeOptionalMethod(on, info, "start");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 173 */       e.printStackTrace();
/* 174 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void invokeOptionalMethod(ObjectName on, MBeanInfo info, String operationName) throws InstanceNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 180 */     Object[] params = new Object[0];
/* 181 */     String[] signature = new String[0];
/* 182 */     if (hasOperation(info, operationName))
/* 183 */       this.server.invoke(on, operationName, params, signature);
/*     */   }
/*     */ 
/*     */   public void uninstallMBean(ObjectName on)
/*     */   {
/*     */     try
/*     */     {
/* 191 */       MBeanInfo info = this.server.getMBeanInfo(on);
/*     */       try
/*     */       {
/* 194 */         invokeOptionalMethod(on, info, "stop");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 199 */         log.warn("stop on " + on + " failed", e);
/*     */       }
/*     */       try
/*     */       {
/* 203 */         invokeOptionalMethod(on, info, "destroy");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 208 */         log.warn("destroy on " + on + " failed", e);
/*     */       }
/*     */ 
/* 211 */       this.server.unregisterMBean(on);
/* 212 */       this.kernel.getController().uninstall(on.getCanonicalName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 216 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstall(String name)
/*     */   {
/*     */     try
/*     */     {
/* 224 */       log.info("uninstalling bean: " + name);
/* 225 */       this.kernel.getController().uninstall(name);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 229 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws Exception
/*     */   {
/* 235 */     String name = objectName.getCanonicalName();
/* 236 */     KernelRegistryEntry entry = this.kernel.getRegistry().getEntry(name);
/* 237 */     if (entry != null)
/*     */     {
/* 239 */       Object target = entry.getTarget();
/* 240 */       if ((target instanceof RARDeployment))
/*     */       {
/* 242 */         RARDeployment deployment = (RARDeployment)target;
/* 243 */         return deployment.invoke(operationName, params, signature);
/*     */       }
/*     */ 
/* 247 */       Class[] types = new Class[signature.length];
/* 248 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 250 */         types[i] = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
/*     */       }
/* 252 */       Method method = target.getClass().getMethod(operationName, types);
/* 253 */       return method.invoke(target, params);
/*     */     }
/*     */ 
/* 256 */     return null;
/*     */   }
/*     */ 
/*     */   public static class AlreadyInstantiated extends AbstractConstructorMetaData
/*     */   {
/*     */     private static final long serialVersionUID = 8120833830553872619L;
/*     */     private Object bean;
/*     */ 
/*     */     public AlreadyInstantiated(Object bean)
/*     */     {
/*  75 */       this.bean = bean;
/*  76 */       setFactory(new AbstractValueMetaData(new Factory()));
/*  77 */       setFactoryClass(Factory.class.getName());
/*  78 */       setFactoryMethod("create");
/*     */     }
/*     */ 
/*     */     public class Factory
/*     */     {
/*     */       public Factory()
/*     */       {
/*     */       }
/*     */ 
/*     */       public Object create()
/*     */       {
/*  69 */         return MCKernelAbstraction.AlreadyInstantiated.this.bean;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.MCKernelAbstraction
 * JD-Core Version:    0.6.0
 */