/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.ejb3.embedded.resource.RARDeployment;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class MCClientKernelAbstraction
/*    */   implements ClientKernelAbstraction
/*    */ {
/* 38 */   private static final Logger log = Logger.getLogger(MCClientKernelAbstraction.class);
/*    */   protected Kernel kernel;
/*    */ 
/*    */   public MCClientKernelAbstraction(Kernel kernel)
/*    */   {
/* 44 */     this.kernel = kernel;
/*    */   }
/*    */ 
/*    */   public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws Exception
/*    */   {
/* 49 */     String name = objectName.getCanonicalName();
/* 50 */     KernelRegistryEntry entry = this.kernel.getRegistry().getEntry(name);
/* 51 */     if (entry != null)
/*    */     {
/* 53 */       Object target = entry.getTarget();
/* 54 */       if ((target instanceof RARDeployment))
/*    */       {
/* 56 */         RARDeployment deployment = (RARDeployment)target;
/* 57 */         return deployment.invoke(operationName, params, signature);
/*    */       }
/*    */ 
/* 61 */       Class[] types = new Class[signature.length];
/* 62 */       for (int i = 0; i < signature.length; i++)
/*    */       {
/* 64 */         types[i] = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
/*    */       }
/* 66 */       Method method = target.getClass().getMethod(operationName, types);
/* 67 */       return method.invoke(target, params);
/*    */     }
/*    */ 
/* 70 */     return null;
/*    */   }
/*    */ 
/*    */   public Object getAttribute(ObjectName objectName, String attribute) throws Exception
/*    */   {
/* 75 */     String name = objectName.getCanonicalName();
/* 76 */     KernelRegistryEntry entry = this.kernel.getRegistry().getEntry(name);
/* 77 */     if (entry != null)
/*    */     {
/* 79 */       Object target = entry.getTarget();
/* 80 */       Field field = target.getClass().getField(attribute);
/* 81 */       return field.get(target);
/*    */     }
/* 83 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.MCClientKernelAbstraction
 * JD-Core Version:    0.6.0
 */