/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.ejb.EJBException;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.RefAddr;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jnp.interfaces.MarshalledValuePair;
/*    */ 
/*    */ public class JndiProxyFactory
/*    */   implements ObjectFactory
/*    */ {
/* 42 */   private static final Logger log = Logger.getLogger(JndiProxyFactory.class);
/*    */   public static final String FACTORY = "FACTORY";
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*    */     throws Exception
/*    */   {
/* 48 */     Reference ref = (Reference)obj;
/* 49 */     String factoryName = (String)ref.get("FACTORY").getContent();
/*    */     try
/*    */     {
/* 53 */       ProxyFactory factory = (ProxyFactory)nameCtx.lookup(factoryName);
/*    */ 
/* 55 */       Object proxy = factory.createProxy();
/* 56 */       MarshalledValuePair marshalledProxy = new MarshalledValuePair(proxy);
/* 57 */       return marshalledProxy.get();
/*    */     }
/*    */     catch (EJBException e)
/*    */     {
/* 61 */       throw e;
/*    */     }
/*    */     catch (ClassCastException e) {
/*    */     }
/* 65 */     throw new EJBException("Invalid invocation of local interface", e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.JndiProxyFactory
 * JD-Core Version:    0.6.0
 */