/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
/*     */ 
/*     */ @Deprecated
/*     */ public class JmxDeploymentUnit
/*     */   implements DeploymentUnit
/*     */ {
/*  53 */   protected static final Logger log = Logger.getLogger(JmxDeploymentUnit.class);
/*     */   private DeploymentInfo deploymentInfo;
/*  56 */   InterceptorInfoRepository interceptorInfoRepository = new InterceptorInfoRepository(null);
/*     */   private VirtualFile vfsRoot;
/*     */ 
/*     */   public JmxDeploymentUnit(DeploymentInfo deploymentInfo)
/*     */   {
/*  61 */     this.deploymentInfo = deploymentInfo;
/*     */     try
/*     */     {
/*  64 */       VFS vfs = VFS.getVFS(deploymentInfo.url);
/*  65 */       this.vfsRoot = vfs.getRoot();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  69 */       throw new RuntimeException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public VirtualFile getRootFile()
/*     */   {
/*  75 */     return this.vfsRoot;
/*     */   }
/*     */ 
/*     */   public URL getRelativeURL(String jar)
/*     */   {
/*  80 */     URL url = null;
/*     */     try
/*     */     {
/*  83 */       url = new URL(jar);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*     */       try
/*     */       {
/*  89 */         if (jar.startsWith(".."))
/*     */         {
/*  91 */           if (getUrl() == null)
/*  92 */             throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
/*  93 */           String base = getUrl().toString();
/*  94 */           jar = jar.replaceAll("\\.\\./", "+");
/*  95 */           int idx = jar.lastIndexOf('+');
/*  96 */           jar = jar.substring(idx + 1);
/*  97 */           for (int i = 0; i < idx + 1; i++)
/*     */           {
/*  99 */             int slash = base.lastIndexOf('/');
/* 100 */             base = base.substring(0, slash + 1);
/*     */           }
/* 102 */           url = new URL(base + jar.substring(idx));
/*     */         }
/*     */         else
/*     */         {
/* 106 */           File fp = new File(jar);
/* 107 */           url = fp.toURL();
/*     */         }
/*     */       }
/*     */       catch (MalformedURLException e1)
/*     */       {
/* 112 */         throw new RuntimeException("Unable to find relative url: " + jar, e1);
/*     */       }
/*     */     }
/* 115 */     return url;
/*     */   }
/*     */ 
/*     */   URL extractDescriptorUrl(String resource)
/*     */   {
/* 120 */     String urlStr = this.deploymentInfo.url.getFile();
/*     */     try
/*     */     {
/* 124 */       URL dd = this.deploymentInfo.localCl.findResource(resource);
/* 125 */       if (dd == null)
/*     */       {
/* 127 */         return null;
/*     */       }
/*     */ 
/* 133 */       if (this.deploymentInfo.localUrl != null)
/*     */       {
/* 135 */         urlStr = this.deploymentInfo.localUrl.toString();
/*     */       }
/*     */ 
/* 138 */       String ddStr = dd.toString();
/* 139 */       if (ddStr.indexOf(urlStr) >= 0)
/*     */       {
/* 141 */         return dd;
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 147 */     return null;
/*     */   }
/*     */ 
/*     */   public URL getPersistenceXml()
/*     */   {
/* 152 */     return extractDescriptorUrl("META-INF/persistence.xml");
/*     */   }
/*     */ 
/*     */   public URL getEjbJarXml()
/*     */   {
/* 157 */     return extractDescriptorUrl("META-INF/ejb-jar.xml");
/*     */   }
/*     */ 
/*     */   public URL getJbossXml()
/*     */   {
/* 162 */     return extractDescriptorUrl("META-INF/jboss.xml");
/*     */   }
/*     */ 
/*     */   public List<Class> getClasses()
/*     */   {
/* 167 */     return null;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 172 */     return this.deploymentInfo.ucl;
/*     */   }
/*     */ 
/*     */   public ClassLoader getResourceLoader()
/*     */   {
/* 177 */     return this.deploymentInfo.localCl;
/*     */   }
/*     */ 
/*     */   public String getShortName()
/*     */   {
/* 182 */     return this.deploymentInfo.shortName;
/*     */   }
/*     */ 
/*     */   public URL getUrl()
/*     */   {
/* 187 */     return this.deploymentInfo.url;
/*     */   }
/*     */ 
/*     */   public String getDefaultEntityManagerName()
/*     */   {
/* 192 */     String url = getUrl().toString();
/* 193 */     String name = url.substring(url.lastIndexOf('/') + 1, url.lastIndexOf('.'));
/* 194 */     return name;
/*     */   }
/*     */ 
/*     */   public Map getDefaultPersistenceProperties()
/*     */   {
/*     */     try
/*     */     {
/* 201 */       EJB3DeployerMBean deployer = (EJB3DeployerMBean)MBeanProxyExt.create(EJB3DeployerMBean.class, EJB3DeployerMBean.OBJECT_NAME, this.deploymentInfo.getServer());
/*     */ 
/* 204 */       return deployer.getDefaultProperties();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 208 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Hashtable getJndiProperties()
/*     */   {
/* 215 */     return null;
/*     */   }
/*     */ 
/*     */   public InterceptorInfoRepository getInterceptorInfoRepository()
/*     */   {
/* 220 */     return this.interceptorInfoRepository;
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getResources(VirtualFileFilter filter)
/*     */   {
/* 226 */     VisitorAttributes va = new VisitorAttributes();
/* 227 */     va.setLeavesOnly(true);
/* 228 */     SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
/* 229 */     va.setRecurseFilter(noJars);
/* 230 */     FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
/*     */     try
/*     */     {
/* 233 */       this.vfsRoot.visit(visitor);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 237 */       throw new RuntimeException(e);
/*     */     }
/* 239 */     return visitor.getMatched();
/*     */   }
/*     */ 
/*     */   public VirtualFile getMetaDataFile(String path)
/*     */   {
/*     */     try
/*     */     {
/* 247 */       return this.vfsRoot.findChild(path);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 251 */       log.debug("Cannot get meta data file: " + path);
/* 252 */     }return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.JmxDeploymentUnit
 * JD-Core Version:    0.6.0
 */