/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ 
/*    */ public class JmxDeploymentScopeImpl
/*    */   implements DeploymentScope
/*    */ {
/* 35 */   private ConcurrentHashMap<String, Ejb3Deployment> deployments = new ConcurrentHashMap();
/*    */   private String shortName;
/*    */   private String baseName;
/*    */ 
/*    */   public JmxDeploymentScopeImpl(String shortName)
/*    */   {
/* 41 */     this.shortName = shortName;
/* 42 */     int idx = shortName.lastIndexOf('.');
/* 43 */     this.baseName = shortName.substring(0, idx);
/*    */   }
/*    */ 
/*    */   public Collection<Ejb3Deployment> getEjbDeployments()
/*    */   {
/* 48 */     return this.deployments.values();
/*    */   }
/*    */ 
/*    */   public void register(Ejb3Deployment deployment)
/*    */   {
/* 53 */     this.deployments.put(deployment.getDeploymentUnit().getShortName(), deployment);
/*    */   }
/*    */ 
/*    */   public void unregister(Ejb3Deployment deployment)
/*    */   {
/* 58 */     this.deployments.remove(deployment.getDeploymentUnit().getShortName());
/*    */   }
/*    */ 
/*    */   public Ejb3Deployment findRelativeDeployment(String relativeName)
/*    */   {
/* 63 */     String relativeShortName = relativeName.substring(3);
/* 64 */     return (Ejb3Deployment)this.deployments.get(relativeShortName);
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 69 */     return this.shortName;
/*    */   }
/*    */ 
/*    */   public String getShortName()
/*    */   {
/* 74 */     return this.shortName;
/*    */   }
/*    */ 
/*    */   public String getBaseName()
/*    */   {
/* 79 */     return this.baseName;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.JmxDeploymentScopeImpl
 * JD-Core Version:    0.6.0
 */