/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.util.LinkedList;
/*    */ import java.util.List;
/*    */ import org.jboss.ejb3.pool.AbstractPool;
/*    */ 
/*    */ public class InfinitePool extends AbstractPool
/*    */ {
/* 37 */   private List<BeanContext> active = new LinkedList();
/*    */ 
/*    */   public void destroy()
/*    */   {
/* 41 */     for (BeanContext ctx : this.active)
/*    */     {
/* 44 */       super.remove(ctx);
/*    */     }
/* 46 */     this.active = null;
/*    */   }
/*    */ 
/*    */   public BeanContext<?> get()
/*    */   {
/* 51 */     return get(null, null);
/*    */   }
/*    */ 
/*    */   public BeanContext<?> get(Class[] initTypes, Object[] initValues)
/*    */   {
/* 56 */     BeanContext ctx = create(initTypes, initValues);
/* 57 */     synchronized (this.active)
/*    */     {
/* 59 */       this.active.add(ctx);
/*    */     }
/* 61 */     return ctx;
/*    */   }
/*    */ 
/*    */   public int getAvailableCount()
/*    */   {
/* 66 */     return -1;
/*    */   }
/*    */ 
/*    */   public int getCurrentSize()
/*    */   {
/* 71 */     return this.active.size();
/*    */   }
/*    */ 
/*    */   public int getMaxSize()
/*    */   {
/* 76 */     return -1;
/*    */   }
/*    */ 
/*    */   public void release(BeanContext ctx)
/*    */   {
/* 81 */     remove(ctx);
/*    */   }
/*    */ 
/*    */   public void remove(BeanContext ctx)
/*    */   {
/* 86 */     synchronized (this.active)
/*    */     {
/* 88 */       this.active.remove(ctx);
/*    */     }
/*    */ 
/* 91 */     super.remove(ctx);
/*    */   }
/*    */ 
/*    */   public void setMaxSize(int maxSize)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.InfinitePool
 * JD-Core Version:    0.6.0
 */