/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ import javassist.bytecode.annotation.StringMemberValue;
/*     */ import javax.ejb.MessageDriven;
/*     */ import javax.ejb.Stateful;
/*     */ import javax.ejb.Stateless;
/*     */ import javax.ejb.TransactionAttribute;
/*     */ import javax.ejb.TransactionAttributeType;
/*     */ import javax.persistence.Entity;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.DomainDefinition;
/*     */ import org.jboss.ejb3.annotation.Consumer;
/*     */ import org.jboss.ejb3.annotation.Service;
/*     */ import org.jboss.ejb3.mdb.ConsumerContainer;
/*     */ import org.jboss.ejb3.mdb.MDB;
/*     */ import org.jboss.ejb3.metamodel.EnterpriseBean;
/*     */ import org.jboss.ejb3.service.ServiceContainer;
/*     */ import org.jboss.ejb3.stateful.StatefulContainer;
/*     */ import org.jboss.ejb3.stateless.StatelessContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Ejb3AnnotationHandler
/*     */   implements Ejb3Handler
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(Ejb3AnnotationHandler.class);
/*     */   protected DeploymentUnit di;
/*     */   protected ClassFile cf;
/*  63 */   protected List<String> ejbNames = new ArrayList();
/*     */   protected Class<?> ejbClass;
/*     */   protected String className;
/*     */   protected EJB_TYPE ejbType;
/*     */   protected Annotation annotation;
/*     */   protected AnnotationsAttribute visible;
/*     */   protected Hashtable ctxProperties;
/*     */   protected String defaultSLSBDomain;
/*     */   protected String defaultSFSBDomain;
/*     */   protected String defaultMDBDomain;
/*     */   protected String defaultServiceDomain;
/*     */   protected String defaultConsumerDomain;
/*     */   protected Ejb3Deployment deployment;
/*     */ 
/*     */   public Ejb3AnnotationHandler(Ejb3Deployment deployment)
/*     */   {
/*  79 */     this.deployment = deployment;
/*  80 */     this.di = deployment.getDeploymentUnit();
/*  81 */     this.defaultSLSBDomain = deployment.getDefaultSLSBDomain();
/*  82 */     this.defaultSFSBDomain = deployment.getDefaultSFSBDomain();
/*  83 */     this.defaultMDBDomain = deployment.getDefaultMDBDomain();
/*  84 */     this.defaultServiceDomain = deployment.getDefaultServiceDomain();
/*  85 */     this.defaultConsumerDomain = deployment.getDefaultConsumerDomain();
/*     */   }
/*     */ 
/*     */   public Ejb3AnnotationHandler(Ejb3Deployment deployment, ClassFile cf)
/*     */   {
/*  90 */     this.deployment = deployment;
/*  91 */     this.di = deployment.getDeploymentUnit();
/*  92 */     this.defaultSLSBDomain = deployment.getDefaultSLSBDomain();
/*  93 */     this.defaultSFSBDomain = deployment.getDefaultSFSBDomain();
/*  94 */     this.defaultMDBDomain = deployment.getDefaultMDBDomain();
/*  95 */     this.defaultServiceDomain = deployment.getDefaultServiceDomain();
/*  96 */     this.defaultConsumerDomain = deployment.getDefaultConsumerDomain();
/*     */ 
/*  98 */     this.cf = cf;
/*  99 */     this.className = cf.getName();
/* 100 */     this.visible = ((AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations"));
/*     */   }
/*     */ 
/*     */   public void setCtxProperties(Hashtable ctxProperties)
/*     */   {
/* 105 */     this.ctxProperties = ctxProperties;
/*     */   }
/*     */ 
/*     */   protected String getJaccContextId()
/*     */   {
/* 110 */     return this.di.getShortName();
/*     */   }
/*     */ 
/*     */   public boolean isEjb()
/*     */   {
/* 115 */     if (this.visible == null) return false;
/*     */ 
/* 117 */     if (EJB3Util.isStateless(this.visible)) return true;
/* 118 */     if (EJB3Util.isMessageDriven(this.visible)) return true;
/* 119 */     return EJB3Util.isStatefulSession(this.visible);
/*     */   }
/*     */ 
/*     */   public boolean isJBossBeanType()
/*     */   {
/* 125 */     if (this.visible == null) return false;
/*     */ 
/* 127 */     if (EJB3Util.isService(this.visible)) return true;
/* 128 */     return EJB3Util.isConsumer(this.visible);
/*     */   }
/*     */ 
/*     */   public List getContainers(ClassFile cf, Ejb3Deployment deployment)
/*     */     throws Exception
/*     */   {
/* 134 */     List containers = new ArrayList();
/*     */ 
/* 136 */     populateBaseInfo();
/*     */ 
/* 138 */     for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ejbIndex++)
/*     */     {
/* 140 */       String ejbName = (String)this.ejbNames.get(ejbIndex);
/* 141 */       if (this.ejbType == EJB_TYPE.STATELESS)
/*     */       {
/* 143 */         EJBContainer container = getStatelessContainer(ejbIndex);
/* 144 */         container.setJaccContextId(getJaccContextId());
/* 145 */         containers.add(container);
/*     */       }
/* 147 */       else if (this.ejbType == EJB_TYPE.STATEFUL)
/*     */       {
/* 149 */         StatefulContainer container = getStatefulContainer(ejbIndex);
/* 150 */         container.setJaccContextId(getJaccContextId());
/* 151 */         containers.add(container);
/*     */       }
/* 153 */       else if (this.ejbType == EJB_TYPE.MESSAGE_DRIVEN)
/*     */       {
/* 155 */         MDB container = getMDB(ejbIndex);
/* 156 */         validateMDBTransactionAttribute(container);
/* 157 */         container.setJaccContextId(getJaccContextId());
/* 158 */         containers.add(container);
/*     */       }
/* 160 */       else if (this.ejbType == EJB_TYPE.SERVICE)
/*     */       {
/* 162 */         ServiceContainer container = getServiceContainer(ejbIndex);
/* 163 */         container.setJaccContextId(getJaccContextId());
/* 164 */         containers.add(container);
/*     */       }
/* 166 */       else if (this.ejbType == EJB_TYPE.CONSUMER)
/*     */       {
/* 168 */         ConsumerContainer container = getConsumerContainer(ejbIndex);
/* 169 */         container.setJaccContextId(getJaccContextId());
/* 170 */         containers.add(container);
/*     */       }
/* 172 */       log.debug("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + this.ejbType);
/*     */     }
/*     */ 
/* 175 */     return containers;
/*     */   }
/*     */ 
/*     */   protected void validateMDBTransactionAttribute(MDB mdb)
/*     */   {
/* 180 */     TransactionAttribute tx = (TransactionAttribute)mdb.resolveAnnotation(TransactionAttribute.class);
/* 181 */     if (tx != null)
/*     */     {
/* 183 */       TransactionAttributeType type = tx.value();
/* 184 */       if ((type != TransactionAttributeType.REQUIRED) && (type != TransactionAttributeType.NOT_SUPPORTED))
/* 185 */         throw new RuntimeException("MDB " + mdb.getEjbName() + " has an invalid TransactionAttribute: " + type + ". Only REQUIRED and NOT_SUPPORTED are valid");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getAspectDomain(int ejbIndex, String defaultDomain)
/*     */   {
/* 192 */     return EJB3Util.getAspectDomain(this.visible, defaultDomain);
/*     */   }
/*     */ 
/*     */   protected ServiceContainer getServiceContainer(int ejbIndex) throws Exception
/*     */   {
/* 197 */     String containerName = getAspectDomain(ejbIndex, this.defaultServiceDomain);
/* 198 */     DomainDefinition domain = AspectManager.instance().getContainer(containerName);
/*     */ 
/* 200 */     if (domain == null) {
/* 201 */       throw new RuntimeException("No container configured with name '" + containerName + "''");
/*     */     }
/*     */ 
/* 204 */     return new ServiceContainer(this.deployment.getMbeanServer(), this.di.getClassLoader(), this.className, (String)this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
/*     */   }
/*     */ 
/*     */   protected ConsumerContainer getConsumerContainer(int ejbIndex)
/*     */     throws Exception
/*     */   {
/* 212 */     String containerName = getAspectDomain(ejbIndex, this.defaultConsumerDomain);
/* 213 */     DomainDefinition domain = AspectManager.instance().getContainer(containerName);
/*     */ 
/* 215 */     if (domain == null) {
/* 216 */       throw new RuntimeException("No container configured with name '" + containerName + "''");
/*     */     }
/*     */ 
/* 219 */     return new ConsumerContainer((String)this.ejbNames.get(ejbIndex), domain.getManager(), this.di.getClassLoader(), this.className, this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
/*     */   }
/*     */ 
/*     */   protected StatefulContainer getStatefulContainer(int ejbIndex)
/*     */     throws Exception
/*     */   {
/* 227 */     String containerName = getAspectDomain(ejbIndex, this.defaultSFSBDomain);
/* 228 */     DomainDefinition domain = AspectManager.instance().getContainer(containerName);
/*     */ 
/* 230 */     if (domain == null) {
/* 231 */       throw new RuntimeException("No container configured with name '" + containerName + "''");
/*     */     }
/*     */ 
/* 234 */     return new StatefulContainer(this.di.getClassLoader(), this.className, (String)this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
/*     */   }
/*     */ 
/*     */   protected EJBContainer getStatelessContainer(int ejbIndex)
/*     */     throws Exception
/*     */   {
/* 242 */     String containerName = getAspectDomain(ejbIndex, this.defaultSLSBDomain);
/*     */ 
/* 244 */     DomainDefinition domain = AspectManager.instance().getContainer(containerName);
/*     */ 
/* 246 */     if (domain == null) {
/* 247 */       throw new RuntimeException("No container configured with name '" + containerName + "''");
/*     */     }
/*     */ 
/* 250 */     return new StatelessContainer(this.di.getClassLoader(), this.className, (String)this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
/*     */   }
/*     */ 
/*     */   protected String getMDBDomainName(int ejbIndex)
/*     */   {
/* 258 */     return this.defaultMDBDomain;
/*     */   }
/*     */ 
/*     */   protected void createProxyFactories()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected MDB getMDB(int ejbIndex)
/*     */     throws Exception
/*     */   {
/* 268 */     return getMDB(ejbIndex, null);
/*     */   }
/*     */ 
/*     */   protected MDB getMDB(int ejbIndex, EnterpriseBean xml) throws Exception
/*     */   {
/* 273 */     String domainName = getMDBDomainName(ejbIndex);
/*     */ 
/* 275 */     String containerName = getAspectDomain(ejbIndex, domainName);
/* 276 */     DomainDefinition domain = AspectManager.instance().getContainer(containerName);
/*     */ 
/* 278 */     if (domain == null) {
/* 279 */       throw new RuntimeException("No container configured with name '" + containerName + "''");
/*     */     }
/*     */ 
/* 282 */     MDB container = new MDB((String)this.ejbNames.get(ejbIndex), domain.getManager(), this.di.getClassLoader(), this.className, this.ctxProperties, this.di.getInterceptorInfoRepository(), this.deployment);
/*     */ 
/* 285 */     return container;
/*     */   }
/*     */ 
/*     */   protected void populateBaseInfo() throws Exception
/*     */   {
/* 290 */     String ejbName = null;
/* 291 */     this.ejbClass = this.di.getClassLoader().loadClass(this.className);
/*     */ 
/* 293 */     this.visible = ((AnnotationsAttribute)this.cf.getAttribute("RuntimeVisibleAnnotations"));
/*     */ 
/* 295 */     if (this.visible != null)
/*     */     {
/* 297 */       this.annotation = this.visible.getAnnotation(Stateless.class.getName());
/* 298 */       if (this.annotation != null)
/*     */       {
/* 300 */         this.ejbType = EJB_TYPE.STATELESS;
/*     */       }
/*     */       else
/*     */       {
/* 304 */         this.annotation = this.visible.getAnnotation(Stateful.class.getName());
/* 305 */         if (this.annotation != null)
/*     */         {
/* 307 */           this.ejbType = EJB_TYPE.STATEFUL;
/*     */         }
/*     */         else
/*     */         {
/* 311 */           this.annotation = this.visible.getAnnotation(Entity.class.getName());
/* 312 */           if (this.annotation != null)
/*     */           {
/* 314 */             this.ejbType = EJB_TYPE.ENTITY;
/*     */           }
/*     */           else
/*     */           {
/* 318 */             this.annotation = this.visible.getAnnotation(MessageDriven.class.getName());
/* 319 */             if (this.annotation != null)
/*     */             {
/* 321 */               this.ejbType = EJB_TYPE.MESSAGE_DRIVEN;
/*     */             }
/*     */             else
/*     */             {
/* 325 */               this.annotation = this.visible.getAnnotation(Service.class.getName());
/* 326 */               if (this.annotation != null)
/*     */               {
/* 328 */                 this.ejbType = EJB_TYPE.SERVICE;
/*     */               }
/*     */               else
/*     */               {
/* 332 */                 this.annotation = this.visible.getAnnotation(Consumer.class.getName());
/* 333 */                 if (this.annotation != null)
/*     */                 {
/* 335 */                   this.ejbType = EJB_TYPE.CONSUMER;
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 343 */       if (this.annotation != null)
/*     */       {
/* 345 */         StringMemberValue mv = (StringMemberValue)this.annotation.getMemberValue("name");
/* 346 */         if (mv != null)
/* 347 */           ejbName = mv.getValue();
/*     */         else {
/* 349 */           ejbName = this.ejbClass.getSimpleName();
/*     */         }
/*     */       }
/*     */     }
/* 353 */     if (ejbName != null)
/*     */     {
/* 355 */       this.ejbNames.add(ejbName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static enum EJB_TYPE
/*     */   {
/*  57 */     STATELESS, STATEFUL, MESSAGE_DRIVEN, ENTITY, SERVICE, CONSUMER;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.Ejb3AnnotationHandler
 * JD-Core Version:    0.6.0
 */