/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.ejb3.annotation.impl.SecurityDomainImpl;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.plugins.loader.BasicMetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ 
/*     */ public class EJBMetaDataLoader extends BasicMetaDataLoader
/*     */ {
/*     */   private EJBContainer container;
/*  55 */   private Map<Signature, MetaDataRetrieval> cache = new ConcurrentHashMap();
/*     */ 
/*     */   public EJBMetaDataLoader(ScopeKey key, EJBContainer container)
/*     */   {
/*  65 */     super(key);
/*  66 */     if (container == null)
/*  67 */       throw new IllegalArgumentException("Null container");
/*  68 */     this.container = container;
/*     */   }
/*     */ 
/*     */   protected JBossEnterpriseBeanMetaData getBeanMetaData()
/*     */   {
/*  78 */     return this.container.getXml();
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*     */   {
/*  83 */     JBossEnterpriseBeanMetaData beanMetaData = getBeanMetaData();
/*  84 */     if (beanMetaData == null) {
/*  85 */       return null;
/*     */     }
/*  87 */     if (!(signature instanceof MethodSignature)) {
/*  88 */       return null;
/*     */     }
/*  90 */     MetaDataRetrieval retrieval = (MetaDataRetrieval)this.cache.get(signature);
/*  91 */     if (retrieval != null) {
/*  92 */       return retrieval;
/*     */     }
/*  94 */     retrieval = new MethodMetaDataRetrieval((MethodSignature)signature);
/*  95 */     this.cache.put(signature, retrieval);
/*  96 */     return retrieval;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 101 */     return getBeanMetaData() != null;
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */   {
/* 106 */     JBossEnterpriseBeanMetaData beanMetaData = getBeanMetaData();
/* 107 */     if (beanMetaData == null) {
/* 108 */       return null;
/*     */     }
/* 110 */     if (annotationType == SecurityDomain.class)
/*     */     {
/* 112 */       String securityDomain = beanMetaData.getSecurityDomain();
/* 113 */       if (securityDomain != null)
/* 114 */         return new SimpleAnnotationItem(new SecurityDomainImpl(securityDomain));
/*     */     }
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveAnnotations()
/*     */   {
/* 121 */     List annotations = new ArrayList();
/* 122 */     AnnotationItem annotation = retrieveAnnotation(SecurityDomain.class);
/* 123 */     if (annotation != null)
/* 124 */       annotations.add(annotation);
/* 125 */     if (annotations.isEmpty()) {
/* 126 */       return SimpleAnnotationsItem.NO_ANNOTATIONS;
/*     */     }
/* 128 */     return new SimpleAnnotationsItem((AnnotationItem[])annotations.toArray(new AnnotationItem[annotations.size()]));
/*     */   }
/*     */ 
/*     */   private class MethodMetaDataRetrieval extends BasicMetaDataLoader
/*     */   {
/*     */     private MethodSignature signature;
/*     */ 
/*     */     public MethodMetaDataRetrieval(MethodSignature methodSignature)
/*     */     {
/* 146 */       this.signature = methodSignature;
/*     */     }
/*     */ 
/*     */     public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*     */     {
/* 151 */       return null;
/*     */     }
/*     */ 
/*     */     public boolean isEmpty()
/*     */     {
/* 156 */       return false;
/*     */     }
/*     */ 
/*     */     public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */     {
/* 173 */       return null;
/*     */     }
/*     */ 
/*     */     public AnnotationsItem retrieveAnnotations()
/*     */     {
/* 179 */       return SimpleAnnotationsItem.NO_ANNOTATIONS;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJBMetaDataLoader
 * JD-Core Version:    0.6.0
 */