/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.metadata.ThreadMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class EJBInvocation
/*     */   implements Invocation
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(EJBInvocation.class);
/*     */   protected transient Interceptor[] interceptors;
/*     */   protected long methodHash;
/*  46 */   protected transient int currentInterceptor = 0;
/*     */   protected transient Method method;
/*     */   protected Object[] arguments;
/*  49 */   protected SimpleMetaData metadata = null;
/*  50 */   protected transient Map responseContextInfo = null;
/*     */ 
/*     */   protected EJBInvocation(Method method, long methodHash, Object[] arguments, Interceptor[] interceptors)
/*     */   {
/*  54 */     this.method = method;
/*  55 */     this.methodHash = methodHash;
/*  56 */     this.arguments = arguments;
/*  57 */     this.interceptors = interceptors;
/*     */   }
/*     */ 
/*     */   protected EJBInvocation()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object invokeNext() throws Throwable
/*     */   {
/*  66 */     if (this.currentInterceptor < this.interceptors.length)
/*     */     {
/*     */       try
/*     */       {
/*  70 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  80 */       return this.method.invoke(getTargetObject(), getArguments());
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/*  84 */     throw e.getTargetException();
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  90 */     return this.method;
/*     */   }
/*     */ 
/*     */   public long getMethodHash()
/*     */   {
/*  95 */     return this.methodHash;
/*     */   }
/*     */ 
/*     */   public Interceptor[] getInterceptors()
/*     */   {
/* 100 */     return this.interceptors;
/*     */   }
/*     */ 
/*     */   public void setInterceptors(Interceptor[] interceptors)
/*     */   {
/* 105 */     this.interceptors = interceptors;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 110 */     return this.arguments;
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] args)
/*     */   {
/* 115 */     this.arguments = args;
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object key, Object attr)
/*     */   {
/* 121 */     Object value = null;
/* 122 */     if (this.metadata != null) value = this.metadata.getMetaData(key, attr);
/* 123 */     if (value != null) return value;
/* 124 */     value = ThreadMetaData.instance().getMetaData(key, attr);
/* 125 */     return value;
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 130 */     return this.responseContextInfo;
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 135 */     this.responseContextInfo = responseContextInfo;
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 140 */     if (this.responseContextInfo == null) this.responseContextInfo = new HashMap();
/* 141 */     this.responseContextInfo.put(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 146 */     if (this.responseContextInfo == null) return null;
/* 147 */     return this.responseContextInfo.get(key);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 152 */     if (this.metadata == null) this.metadata = new SimpleMetaData();
/* 153 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 158 */     this.metadata = data;
/*     */   }
/*     */ 
/*     */   public Object invokeNext(Interceptor[] newInterceptors) throws Throwable
/*     */   {
/* 163 */     throw new RuntimeException("NOT IMPLEMENTED");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJBInvocation
 * JD-Core Version:    0.6.0
 */