/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.security.Identity;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ import org.jboss.ejb3.tx.UserTransactionImpl;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityRoleRef;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ public abstract class EJBContextImpl<T extends Container, B extends BeanContext<T>>
/*     */   implements EJBContext
/*     */ {
/*     */   private static final Logger log;
/*     */   protected transient T container;
/*     */   protected transient RealmMapping rm;
/*     */   protected B beanContext;
/*     */   private Principal beanPrincipal;
/*     */ 
/*     */   protected EJBContextImpl(B beanContext)
/*     */   {
/*  77 */     assert (beanContext != null) : "beanContext is null";
/*     */ 
/*  79 */     this.beanContext = beanContext;
/*  80 */     this.container = beanContext.getContainer();
/*  81 */     this.rm = ((RealmMapping)this.container.getSecurityManager(RealmMapping.class));
/*     */   }
/*     */ 
/*     */   protected T getContainer()
/*     */   {
/*  86 */     return this.container;
/*     */   }
/*     */ 
/*     */   protected RealmMapping getRm()
/*     */   {
/*  91 */     return this.rm;
/*     */   }
/*     */ 
/*     */   public Object lookup(String name)
/*     */   {
/*     */     String newName;
/*     */     String newName;
/*  97 */     if (name.startsWith("/"))
/*     */     {
/*  99 */       newName = "env" + name;
/*     */     }
/*     */     else
/*     */     {
/* 103 */       newName = "env/" + name;
/*     */     }
/*     */     try
/*     */     {
/* 107 */       return getContainer().getEnc().lookup(newName);
/*     */     }
/*     */     catch (NamingException ignored)
/*     */     {
/*     */       try
/*     */       {
/* 113 */         return getContainer().getInitialContext().lookup(name);
/*     */       }
/*     */       catch (NamingException ignored2)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 120 */     return null;
/*     */   }
/*     */ 
/*     */   public Identity getCallerIdentity()
/*     */   {
/* 126 */     throw new IllegalStateException("deprecated");
/*     */   }
/*     */ 
/*     */   public Principal getCallerPrincipal()
/*     */   {
/* 152 */     if (this.beanPrincipal == null)
/*     */     {
/* 154 */       EJBContainer ec = (EJBContainer)this.container;
/*     */ 
/* 156 */       Principal callerPrincipal = null;
/*     */ 
/* 158 */       RealmMapping rm = (RealmMapping)this.container.getSecurityManager(RealmMapping.class);
/*     */ 
/* 160 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 161 */       if (sc == null)
/*     */       {
/* 163 */         SecurityDomain domain = (SecurityDomain)ec.resolveAnnotation(SecurityDomain.class);
/* 164 */         String unauth = domain.unauthenticatedPrincipal();
/* 165 */         if ((unauth != null) && (unauth.length() > 0) && 
/* 166 */           (domain.unauthenticatedPrincipal() != null))
/* 167 */           callerPrincipal = new SimplePrincipal(unauth);
/*     */       }
/*     */       else
/*     */       {
/* 171 */         EJBAuthorizationHelper helper = new EJBAuthorizationHelper(sc);
/* 172 */         callerPrincipal = helper.getCallerPrincipal(rm);
/*     */       }
/*     */ 
/* 175 */       if (callerPrincipal == null)
/*     */       {
/* 178 */         callerPrincipal = sc.getUtil().getUserPrincipal();
/* 179 */         if (rm != null) {
/* 180 */           callerPrincipal = rm.getPrincipal(callerPrincipal);
/*     */         }
/*     */       }
/* 183 */       if (callerPrincipal == null)
/*     */       {
/* 185 */         SecurityDomain domain = (SecurityDomain)ec.resolveAnnotation(SecurityDomain.class);
/* 186 */         String unauth = domain.unauthenticatedPrincipal();
/* 187 */         if ((unauth != null) && (unauth.length() > 0) && 
/* 188 */           (domain.unauthenticatedPrincipal() != null)) {
/* 189 */           callerPrincipal = new SimplePrincipal(unauth);
/*     */         }
/*     */       }
/*     */ 
/* 193 */       if (callerPrincipal == null) {
/* 194 */         throw new IllegalStateException("No valid security context for the caller identity");
/*     */       }
/* 196 */       this.beanPrincipal = callerPrincipal;
/*     */     }
/* 198 */     return this.beanPrincipal;
/*     */   }
/*     */ 
/*     */   public boolean isCallerInRole(Identity role)
/*     */   {
/* 205 */     throw new IllegalStateException("deprecated");
/*     */   }
/*     */ 
/*     */   public boolean isCallerInRole(String roleName)
/*     */   {
/* 210 */     EJBContainer ejbc = (EJBContainer)this.container;
/* 211 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 212 */     if (sc == null)
/*     */     {
/* 214 */       SecurityDomain domain = (SecurityDomain)ejbc.resolveAnnotation(SecurityDomain.class);
/*     */       try
/*     */       {
/* 217 */         sc = SecurityActions.createSecurityContext(domain.value());
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 221 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */ 
/* 225 */     Set roleRefs = new HashSet();
/* 226 */     JBossEnterpriseBeanMetaData eb = ejbc.getXml();
/* 227 */     if (eb != null)
/*     */     {
/* 229 */       Collection srf = eb.getSecurityRoleRefs();
/* 230 */       if (srf != null) {
/* 231 */         roleRefs.addAll(srf);
/*     */       }
/*     */     }
/*     */ 
/* 235 */     Set srset = new HashSet();
/* 236 */     for (SecurityRoleRefMetaData srmd : roleRefs)
/*     */     {
/* 238 */       srset.add(new SecurityRoleRef(srmd.getRoleName(), srmd.getRoleLink(), null));
/*     */     }
/* 240 */     Principal principal = getCallerPrincipal();
/* 241 */     EJBAuthorizationHelper helper = new EJBAuthorizationHelper(sc);
/* 242 */     return helper.isCallerInRole(roleName, ejbc.getEjbName(), principal, srset);
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService()
/*     */     throws IllegalStateException
/*     */   {
/* 300 */     return getContainer().getTimerService();
/*     */   }
/*     */ 
/*     */   public UserTransaction getUserTransaction() throws IllegalStateException
/*     */   {
/* 305 */     TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)getContainer());
/* 306 */     if (type != TransactionManagementType.BEAN) throw new IllegalStateException("Container " + getContainer().getEjbName() + ": it is illegal to inject UserTransaction into a CMT bean");
/*     */ 
/* 308 */     return new UserTransactionImpl();
/*     */   }
/*     */ 
/*     */   public EJBHome getEJBHome()
/*     */   {
/* 313 */     throw new IllegalStateException("EJB 3.0 does not have a home type.");
/*     */   }
/*     */ 
/*     */   public EJBLocalHome getEJBLocalHome()
/*     */   {
/* 318 */     throw new IllegalStateException("EJB 3.0 does not have a home type.");
/*     */   }
/*     */ 
/*     */   public Properties getEnvironment()
/*     */   {
/* 323 */     throw new EJBException("Deprecated");
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException
/*     */   {
/* 329 */     TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)getContainer());
/* 330 */     if (type != TransactionManagementType.CONTAINER) throw new IllegalStateException("Container " + getContainer().getEjbName() + ": it is illegal to call setRollbackOnly from BMT: " + type);
/*     */ 
/*     */     try
/*     */     {
/* 334 */       TransactionManager tm = TxUtil.getTransactionManager();
/*     */ 
/* 338 */       if (tm.getTransaction() == null) {
/* 339 */         throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
/*     */       }
/* 341 */       tm.setRollbackOnly();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 345 */       log.warn("failed to set rollback only; ignoring", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getRollbackOnly()
/*     */     throws IllegalStateException
/*     */   {
/* 352 */     TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)getContainer());
/* 353 */     if (type != TransactionManagementType.CONTAINER) {
/* 354 */       throw new IllegalStateException("Container " + getContainer().getEjbName() + ": it is illegal to call getRollbackOnly from BMT: " + type);
/*     */     }
/*     */     try
/*     */     {
/* 358 */       TransactionManager tm = TxUtil.getTransactionManager();
/*     */ 
/* 362 */       if (tm.getTransaction() == null) {
/* 363 */         throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
/*     */       }
/*     */ 
/* 366 */       int status = tm.getStatus();
/* 367 */       return (status == 1) || (status == 9) || (status == 4);
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 373 */       log.warn("failed to get tx manager status; ignoring", e);
/* 374 */     }return true;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  67 */     log = Logger.getLogger(EJBContextImpl.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJBContextImpl
 * JD-Core Version:    0.6.0
 */