/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ 
/*     */ public class EJBContainerInvocation<A extends EJBContainer, T extends BeanContext> extends MethodInvocation
/*     */ {
/*     */   private static final long serialVersionUID = 4941832732679380382L;
/*     */   protected T ctx;
/*     */   private BeanContextLifecycleCallback<T> callback;
/*     */ 
/*     */   public EJBContainerInvocation(MethodInfo info)
/*     */   {
/*  46 */     super(info, info.getInterceptors());
/*     */   }
/*     */ 
/*     */   public EJBContainerInvocation(Interceptor[] interceptors, long methodHash, Method advisedMethod, Method unadvisedMethod, Advisor advisor)
/*     */   {
/*  51 */     super(interceptors, methodHash, advisedMethod, unadvisedMethod, advisor);
/*     */   }
/*     */ 
/*     */   public EJBContainerInvocation()
/*     */   {
/*  56 */     super(null, null);
/*     */   }
/*     */ 
/*     */   public A getAdvisor()
/*     */   {
/*  62 */     return (EJBContainer)super.getAdvisor();
/*     */   }
/*     */ 
/*     */   public T getBeanContext()
/*     */   {
/*  67 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public void setBeanContext(T beanCtx)
/*     */   {
/*  72 */     if (beanCtx != null)
/*     */     {
/*  74 */       this.ctx = beanCtx;
/*     */ 
/*  76 */       if (this.callback != null)
/*  77 */         this.callback.attached(beanCtx);
/*     */     }
/*     */     else
/*     */     {
/*  81 */       if (this.callback != null) {
/*  82 */         this.callback.released(this.ctx);
/*     */       }
/*  84 */       this.ctx = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/*  90 */     return new EJBContainerInvocationWrapper(this, newchain);
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/*  95 */     EJBContainerInvocation wrapper = new EJBContainerInvocation(this.interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*  96 */     wrapper.metadata = this.metadata;
/*  97 */     wrapper.currentInterceptor = this.currentInterceptor;
/*  98 */     wrapper.setTargetObject(getTargetObject());
/*  99 */     wrapper.setArguments(getArguments());
/* 100 */     wrapper.setBeanContext(this.ctx);
/* 101 */     wrapper.callback = this.callback;
/* 102 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public void setContextCallback(BeanContextLifecycleCallback<T> callback)
/*     */   {
/* 107 */     this.callback = callback;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJBContainerInvocation
 * JD-Core Version:    0.6.0
 */