/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfo;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInjector;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RealmMapping;
/*     */ 
/*     */ public abstract class BaseContext<T extends Container>
/*     */   implements BeanContext<T>
/*     */ {
/*     */   protected static Logger log;
/*     */   protected T container;
/*     */   protected Object bean;
/*     */   protected RealmMapping rm;
/*     */   protected SimpleMetaData metadata;
/*     */   protected HashMap<Class, Object> interceptorInstances;
/*     */ 
/*     */   protected BaseContext(T container)
/*     */   {
/*  56 */     assert (container != null) : "container is null";
/*     */ 
/*  58 */     this.container = container;
/*     */   }
/*     */ 
/*     */   protected BaseContext(T container, Object bean)
/*     */   {
/*  63 */     this(container);
/*     */ 
/*  65 */     assert (bean != null) : "bean is null";
/*     */ 
/*  67 */     this.bean = bean;
/*     */   }
/*     */ 
/*     */   public Object getId()
/*     */   {
/*  72 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getInstance()
/*     */   {
/*  80 */     return this.bean;
/*     */   }
/*     */ 
/*     */   public T getContainer()
/*     */   {
/*  85 */     return this.container;
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/*  90 */     if (this.metadata == null) this.metadata = new SimpleMetaData();
/*  91 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public void initialiseInterceptorInstances()
/*     */   {
/*  96 */     HashSet interceptors = ((EJBContainer)this.container).getApplicableInterceptors();
/*     */     HashMap interceptorInjectors;
/*  97 */     if ((interceptors != null) && (interceptors.size() > 0) && (this.interceptorInstances == null))
/*     */     {
/*  99 */       interceptorInjectors = ((EJBContainer)this.container).getInterceptorInjectors();
/* 100 */       this.interceptorInstances = new HashMap();
/* 101 */       for (InterceptorInfo info : interceptors)
/*     */       {
/*     */         try
/*     */         {
/* 105 */           Object instance = info.getClazz().newInstance();
/* 106 */           this.interceptorInstances.put(info.getClazz(), instance);
/* 107 */           ((InterceptorInjector)interceptorInjectors.get(info.getClazz())).inject(this, instance);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 111 */           log.warn("Interceptors must have a public noargs constructor: " + info.getClazz().getName());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos)
/*     */   {
/* 119 */     Object[] interceptors = new Object[interceptorInfos.length];
/* 120 */     int i = 0;
/* 121 */     for (InterceptorInfo info : interceptorInfos)
/*     */     {
/* 123 */       interceptors[(i++)] = this.interceptorInstances.get(info.getClazz());
/*     */     }
/* 125 */     return interceptors;
/*     */   }
/*     */ 
/*     */   public Object getInvokedMethodKey()
/*     */   {
/* 130 */     return this.container;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  41 */     log = Logger.getLogger(BaseContext.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.BaseContext
 * JD-Core Version:    0.6.0
 */