/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerHandle;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TimerServiceImpl
/*     */   implements TimerService
/*     */ {
/*  58 */   private static Logger log = Logger.getLogger(TimerServiceImpl.class);
/*     */   private TransactionManager transactionManager;
/*     */   private PersistencePolicy persistencePolicy;
/*     */   private TimerIdGenerator timerIdGenerator;
/*     */   private RetryPolicy retryPolicy;
/*     */   private TimedObjectId timedObjectId;
/*     */   private TimedObjectInvoker timedObjectInvoker;
/*  75 */   private Map timers = new HashMap();
/*     */ 
/*     */   public TimerServiceImpl(TimedObjectId timedObjectId, TimedObjectInvoker timedObjectInvoker, TransactionManager transactionManager, PersistencePolicy persistencePolicy, RetryPolicy retryPolicy, TimerIdGenerator timerIdGenerator)
/*     */   {
/*  89 */     this.timedObjectId = timedObjectId;
/*  90 */     this.timedObjectInvoker = timedObjectInvoker;
/*  91 */     this.transactionManager = transactionManager;
/*  92 */     this.persistencePolicy = persistencePolicy;
/*  93 */     this.timerIdGenerator = timerIdGenerator;
/*  94 */     this.retryPolicy = retryPolicy;
/*     */   }
/*     */ 
/*     */   public Collection getAllTimers()
/*     */   {
/* 104 */     synchronized (this.timers)
/*     */     {
/* 106 */       return new ArrayList(this.timers.values());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Timer getTimer(TimerHandle handle)
/*     */   {
/* 115 */     TimerImpl timer = (TimerImpl)this.timers.get(handle);
/* 116 */     if ((timer != null) && (timer.isActive())) {
/* 117 */       return timer;
/*     */     }
/* 119 */     return null;
/*     */   }
/*     */ 
/*     */   public void shutdown(boolean keepState)
/*     */   {
/* 129 */     synchronized (this.timers)
/*     */     {
/* 131 */       Iterator it = this.timers.values().iterator();
/* 132 */       while (it.hasNext())
/*     */       {
/* 134 */         TimerImpl timer = (TimerImpl)it.next();
/* 135 */         timer.stopTimer();
/*     */ 
/* 137 */         if (!keepState)
/* 138 */           this.persistencePolicy.deleteTimer(timer.getTimerId(), timer.getTimedObjectId());
/*     */       }
/* 140 */       this.timers.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public TimedObjectInvoker getTimedObjectInvoker()
/*     */   {
/* 149 */     return this.timedObjectInvoker;
/*     */   }
/*     */ 
/*     */   public Timer createTimer(long duration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 168 */     if (duration < 0L) {
/* 169 */       throw new IllegalArgumentException("duration is negative");
/*     */     }
/* 171 */     return createTimer(new Date(System.currentTimeMillis() + duration), 0L, info);
/*     */   }
/*     */ 
/*     */   public Timer createTimer(long initialDuration, long intervalDuration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 197 */     if (initialDuration < 0L)
/* 198 */       throw new IllegalArgumentException("initial duration is negative");
/* 199 */     if (intervalDuration < 0L) {
/* 200 */       throw new IllegalArgumentException("interval duration is negative");
/*     */     }
/* 202 */     return createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info);
/*     */   }
/*     */ 
/*     */   public Timer createTimer(Date expiration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 219 */     if (expiration == null) {
/* 220 */       throw new IllegalArgumentException("expiration is null");
/*     */     }
/* 222 */     return createTimer(expiration, 0L, info);
/*     */   }
/*     */ 
/*     */   public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 248 */     if (initialExpiration == null)
/* 249 */       throw new IllegalArgumentException("initial expiration is null");
/* 250 */     if (intervalDuration < 0L) {
/* 251 */       throw new IllegalArgumentException("interval duration is negative");
/*     */     }
/*     */     try
/*     */     {
/* 255 */       String timerId = this.timerIdGenerator.nextTimerId();
/* 256 */       TimerImpl timer = new TimerImpl(this, timerId, this.timedObjectId, this.timedObjectInvoker, info);
/* 257 */       this.persistencePolicy.insertTimer(timerId, this.timedObjectId, initialExpiration, intervalDuration, info);
/* 258 */       timer.startTimer(initialExpiration, intervalDuration);
/* 259 */       return timer;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 263 */     throw new EJBException("Failed to create timer", e);
/*     */   }
/*     */ 
/*     */   public Collection getTimers()
/*     */     throws IllegalStateException, EJBException
/*     */   {
/* 277 */     ArrayList activeTimers = new ArrayList();
/* 278 */     synchronized (this.timers)
/*     */     {
/* 280 */       Iterator it = this.timers.values().iterator();
/* 281 */       while (it.hasNext())
/*     */       {
/* 283 */         TimerImpl timer = (TimerImpl)it.next();
/* 284 */         if (timer.isActive())
/* 285 */           activeTimers.add(timer);
/*     */       }
/*     */     }
/* 288 */     return activeTimers;
/*     */   }
/*     */ 
/*     */   Transaction getTransaction()
/*     */   {
/*     */     try
/*     */     {
/* 300 */       return this.transactionManager.getTransaction();
/*     */     }
/*     */     catch (SystemException e) {
/*     */     }
/* 304 */     return null;
/*     */   }
/*     */ 
/*     */   void addTimer(TimerImpl txtimer)
/*     */   {
/* 313 */     synchronized (this.timers)
/*     */     {
/* 315 */       TimerHandle handle = new TimerHandleImpl(txtimer);
/* 316 */       this.timers.put(handle, txtimer);
/*     */     }
/*     */   }
/*     */ 
/*     */   void removeTimer(TimerImpl txtimer)
/*     */   {
/* 325 */     synchronized (this.timers)
/*     */     {
/* 327 */       this.persistencePolicy.deleteTimer(txtimer.getTimerId(), txtimer.getTimedObjectId());
/* 328 */       this.timers.remove(new TimerHandleImpl(txtimer));
/*     */     }
/*     */   }
/*     */ 
/*     */   void retryTimeout(TimerImpl txtimer)
/*     */   {
/*     */     try
/*     */     {
/* 336 */       this.retryPolicy.retryTimeout(this.timedObjectInvoker, txtimer);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 340 */       log.error("Retry timeout failed for timer: " + txtimer, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.TimerServiceImpl
 * JD-Core Version:    0.6.0
 */