/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ import java.util.TimerTask;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.TimerHandle;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TimerImpl
/*     */   implements javax.ejb.Timer, Synchronization
/*     */ {
/*  55 */   private static Logger log = Logger.getLogger(TimerImpl.class);
/*     */   private static final int CREATED = 0;
/*     */   private static final int STARTED_IN_TX = 1;
/*     */   private static final int ACTIVE = 2;
/*     */   private static final int CANCELED_IN_TX = 3;
/*     */   private static final int CANCELED = 4;
/*     */   private static final int EXPIRED = 5;
/*     */   private static final int IN_TIMEOUT = 6;
/*     */   private static final int RETRY_TIMEOUT = 7;
/*  85 */   private static final String[] TIMER_STATES = { "created", "started_in_tx", "active", "canceled_in_tx", "canceled", "expired", "in_timeout", "retry_timeout" };
/*     */   private TimerServiceImpl timerService;
/*     */   private String timerId;
/*     */   private TimedObjectId timedObjectId;
/*     */   private TimedObjectInvoker timedObjectInvoker;
/*     */   private Date firstTime;
/*     */   private long periode;
/*     */   private Serializable info;
/*     */   private long nextExpire;
/*     */   private int timerState;
/*     */   private java.util.Timer utilTimer;
/*     */   private int hashCode;
/*     */ 
/*     */   TimerImpl(TimerServiceImpl timerService, String timerId, TimedObjectId timedObjectId, TimedObjectInvoker timedObjectInvoker, Serializable info)
/*     */   {
/* 107 */     this.timerService = timerService;
/* 108 */     this.timerId = timerId;
/* 109 */     this.timedObjectId = timedObjectId;
/* 110 */     this.timedObjectInvoker = timedObjectInvoker;
/* 111 */     this.info = info;
/*     */ 
/* 113 */     setTimerState(0);
/*     */   }
/*     */ 
/*     */   void startTimer(Date firstTime, long periode)
/*     */   {
/* 118 */     this.firstTime = firstTime;
/* 119 */     this.nextExpire = firstTime.getTime();
/* 120 */     this.periode = periode;
/*     */ 
/* 122 */     this.timerService.addTimer(this);
/* 123 */     registerTimerWithTx();
/*     */ 
/* 126 */     startInTx();
/*     */   }
/*     */ 
/*     */   public String getTimerId()
/*     */   {
/* 131 */     return this.timerId;
/*     */   }
/*     */ 
/*     */   public TimedObjectId getTimedObjectId()
/*     */   {
/* 136 */     return this.timedObjectId;
/*     */   }
/*     */ 
/*     */   public Date getFirstTime()
/*     */   {
/* 141 */     return this.firstTime;
/*     */   }
/*     */ 
/*     */   public long getPeriode()
/*     */   {
/* 146 */     return this.periode;
/*     */   }
/*     */ 
/*     */   public long getNextExpire()
/*     */   {
/* 151 */     return this.nextExpire;
/*     */   }
/*     */ 
/*     */   public Serializable getInfoInternal()
/*     */   {
/* 156 */     return this.info;
/*     */   }
/*     */ 
/*     */   public boolean isActive()
/*     */   {
/* 161 */     return (!isCanceled()) && (!isExpired());
/*     */   }
/*     */ 
/*     */   public boolean isInRetry() {
/* 165 */     return this.timerState == 7;
/*     */   }
/*     */ 
/*     */   public boolean isCanceled()
/*     */   {
/* 170 */     return (this.timerState == 3) || (this.timerState == 4);
/*     */   }
/*     */ 
/*     */   public boolean isExpired()
/*     */   {
/* 175 */     return this.timerState == 5;
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 189 */     assertTimedOut();
/* 190 */     assertAllowedOperation("Timer.cancel");
/* 191 */     registerTimerWithTx();
/* 192 */     cancelInTx();
/*     */   }
/*     */ 
/*     */   public void killTimer()
/*     */   {
/* 200 */     log.debug("killTimer: " + this);
/* 201 */     if (this.timerState != 5)
/* 202 */       setTimerState(4);
/* 203 */     this.timerService.removeTimer(this);
/* 204 */     this.utilTimer.cancel();
/*     */   }
/*     */ 
/*     */   private void cancelTimer()
/*     */   {
/* 212 */     if (this.timerState != 5)
/* 213 */       setTimerState(4);
/* 214 */     this.utilTimer.cancel();
/*     */   }
/*     */ 
/*     */   public void stopTimer()
/*     */   {
/* 222 */     log.debug("stopTimer: " + this);
/* 223 */     if (this.timerState != 5)
/* 224 */       setTimerState(4);
/* 225 */     this.utilTimer.cancel();
/*     */   }
/*     */ 
/*     */   public long getTimeRemaining()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 240 */     assertTimedOut();
/* 241 */     assertAllowedOperation("Timer.getTimeRemaining");
/* 242 */     return this.nextExpire - System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public Date getNextTimeout()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 257 */     assertTimedOut();
/* 258 */     assertAllowedOperation("Timer.getNextTimeout");
/* 259 */     return new Date(this.nextExpire);
/*     */   }
/*     */ 
/*     */   public Serializable getInfo()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 275 */     assertTimedOut();
/* 276 */     assertAllowedOperation("Timer.getInfo");
/* 277 */     return this.info;
/*     */   }
/*     */ 
/*     */   public TimerHandle getHandle()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 293 */     assertTimedOut();
/* 294 */     assertAllowedOperation("Timer.getHandle");
/* 295 */     return new TimerHandleImpl(this);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 303 */     if (obj == this) return true;
/* 304 */     if ((obj instanceof TimerImpl))
/*     */     {
/* 306 */       TimerImpl other = (TimerImpl)obj;
/* 307 */       return hashCode() == other.hashCode();
/*     */     }
/* 309 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 317 */     if (this.hashCode == 0)
/*     */     {
/* 319 */       String hash = "[" + this.timerId + "," + this.timedObjectId + "," + this.firstTime + "," + this.periode + "]";
/* 320 */       this.hashCode = hash.hashCode();
/*     */     }
/* 322 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 330 */     long remaining = this.nextExpire - System.currentTimeMillis();
/* 331 */     String retStr = "[id=" + this.timerId + ",target=" + this.timedObjectId + ",remaining=" + remaining + ",periode=" + this.periode + "," + TIMER_STATES[this.timerState] + "]";
/*     */ 
/* 333 */     return retStr;
/*     */   }
/*     */ 
/*     */   private void registerTimerWithTx()
/*     */   {
/* 341 */     Transaction tx = this.timerService.getTransaction();
/* 342 */     if (tx != null)
/*     */     {
/*     */       try
/*     */       {
/* 346 */         tx.registerSynchronization(this);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 350 */         log.error("Cannot register txtimer with Tx: " + this);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setTimerState(int state)
/*     */   {
/* 357 */     log.debug("setTimerState: " + TIMER_STATES[state]);
/* 358 */     this.timerState = state;
/*     */   }
/*     */ 
/*     */   private void startInTx()
/*     */   {
/* 364 */     this.utilTimer = new java.util.Timer("EJB-Timer-" + this.timerId + this.timedObjectId);
/*     */ 
/* 366 */     if (this.timerService.getTransaction() != null)
/*     */     {
/* 369 */       setTimerState(1);
/*     */     }
/*     */     else
/*     */     {
/* 373 */       scheduleTimeout();
/* 374 */       setTimerState(2);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void cancelInTx()
/*     */   {
/* 380 */     if (this.timerService.getTransaction() != null)
/* 381 */       setTimerState(3);
/*     */     else
/* 383 */       killTimer();
/*     */   }
/*     */ 
/*     */   private void scheduleTimeout()
/*     */   {
/* 388 */     if (this.periode > 0L)
/* 389 */       this.utilTimer.schedule(new TimerTaskImpl(this), new Date(this.nextExpire), this.periode);
/*     */     else
/* 391 */       this.utilTimer.schedule(new TimerTaskImpl(this), new Date(this.nextExpire));
/*     */   }
/*     */ 
/*     */   private void assertTimedOut()
/*     */   {
/* 399 */     if (this.timerState == 5)
/* 400 */       throw new NoSuchObjectLocalException("Timer has expired");
/* 401 */     if ((this.timerState == 3) || (this.timerState == 4))
/* 402 */       throw new NoSuchObjectLocalException("Timer was canceled");
/*     */   }
/*     */ 
/*     */   private void assertAllowedOperation(String timerMethod)
/*     */   {
/* 410 */     AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsAssociation.IN_BUSINESS_METHOD | AllowedOperationsAssociation.IN_EJB_TIMEOUT | AllowedOperationsAssociation.IN_SERVICE_ENDPOINT_METHOD | AllowedOperationsAssociation.IN_AFTER_BEGIN | AllowedOperationsAssociation.IN_BEFORE_COMPLETION | AllowedOperationsAssociation.IN_EJB_POST_CREATE | AllowedOperationsAssociation.IN_EJB_REMOVE | AllowedOperationsAssociation.IN_EJB_LOAD | AllowedOperationsAssociation.IN_EJB_STORE);
/*     */   }
/*     */ 
/*     */   public void beforeCompletion()
/*     */   {
/* 431 */     switch (this.timerState)
/*     */     {
/*     */     case 3:
/* 434 */       this.timerService.removeTimer(this);
/* 435 */       break;
/*     */     case 6:
/*     */     case 7:
/* 439 */       if (this.periode != 0L)
/*     */         break;
/* 441 */       this.timerService.removeTimer(this);
/*     */     case 4:
/*     */     case 5:
/*     */     }
/*     */   }
/*     */ 
/*     */   public void afterCompletion(int status)
/*     */   {
/* 455 */     if (status == 3)
/*     */     {
/* 457 */       log.debug("commit: " + this);
/*     */ 
/* 459 */       switch (this.timerState)
/*     */       {
/*     */       case 1:
/* 462 */         scheduleTimeout();
/* 463 */         setTimerState(2);
/* 464 */         break;
/*     */       case 3:
/* 467 */         cancelTimer();
/* 468 */         break;
/*     */       case 6:
/*     */       case 7:
/* 472 */         if (this.periode == 0L)
/*     */         {
/* 474 */           setTimerState(5);
/* 475 */           cancelTimer();
/*     */         }
/*     */         else
/*     */         {
/* 479 */           setTimerState(2);
/*     */         }case 2:
/*     */       case 4:
/*     */       case 5:
/*     */       }
/* 484 */     } else if (status == 4)
/*     */     {
/* 486 */       log.debug("rollback: " + this);
/*     */ 
/* 488 */       switch (this.timerState)
/*     */       {
/*     */       case 1:
/* 491 */         cancelTimer();
/* 492 */         break;
/*     */       case 3:
/* 495 */         setTimerState(2);
/* 496 */         break;
/*     */       case 6:
/* 499 */         setTimerState(7);
/* 500 */         log.debug("retry: " + this);
/* 501 */         this.timerService.retryTimeout(this);
/* 502 */         break;
/*     */       case 7:
/* 505 */         if (this.periode == 0L)
/*     */         {
/* 507 */           setTimerState(5);
/* 508 */           cancelTimer();
/*     */         }
/*     */         else
/*     */         {
/* 512 */           setTimerState(2);
/*     */         }
/*     */       case 2:
/*     */       case 4:
/*     */       case 5:
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private class TimerTaskImpl extends TimerTask
/*     */   {
/*     */     private TimerImpl timer;
/*     */ 
/*     */     public TimerTaskImpl(TimerImpl timer)
/*     */     {
/* 530 */       this.timer = timer;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 538 */       TimerImpl.log.debug("run: " + this.timer);
/*     */ 
/* 543 */       if ((TimerImpl.this.isActive()) && (TimerImpl.this.periode > 0L))
/*     */       {
/* 545 */         TimerImpl.access$214(TimerImpl.this, TimerImpl.this.periode);
/*     */       }
/*     */ 
/* 550 */       if (TimerImpl.this.isInRetry())
/*     */       {
/* 552 */         TimerImpl.log.debug("Timer in retry mode, skipping this scheduled execution");
/* 553 */         return;
/*     */       }
/*     */ 
/* 556 */       if (TimerImpl.this.isActive())
/*     */       {
/*     */         try
/*     */         {
/* 560 */           TimerImpl.this.setTimerState(6);
/* 561 */           TimerImpl.this.timedObjectInvoker.callTimeout(this.timer);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 565 */           TimerImpl.log.error("Error invoking ejbTimeout: " + e.toString());
/*     */         }
/*     */         finally
/*     */         {
/* 569 */           if (TimerImpl.this.timerState == 6)
/*     */           {
/* 571 */             TimerImpl.log.debug("Timer was not registered with Tx, resetting state: " + this.timer);
/* 572 */             if (TimerImpl.this.periode == 0L)
/*     */             {
/* 574 */               TimerImpl.this.setTimerState(5);
/* 575 */               TimerImpl.this.killTimer();
/*     */             }
/*     */             else
/*     */             {
/* 579 */               TimerImpl.this.setTimerState(2);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.TimerImpl
 * JD-Core Version:    0.6.0
 */