/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.text.ParseException;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerHandle;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class TimerHandleImpl
/*     */   implements TimerHandle
/*     */ {
/*     */   public static final String DATE_PATTERN = "dd-MMM-yyyy HH:mm:ss.SSS";
/*     */   private String timerId;
/*     */   private TimedObjectId timedObjectId;
/*     */   private Date firstTime;
/*     */   private long periode;
/*     */   private Serializable info;
/*     */   private int hashCode;
/*     */ 
/*     */   TimerHandleImpl(TimerImpl timer)
/*     */   {
/*  64 */     this.timerId = timer.getTimerId();
/*  65 */     this.timedObjectId = timer.getTimedObjectId();
/*  66 */     this.firstTime = timer.getFirstTime();
/*  67 */     this.periode = timer.getPeriode();
/*  68 */     this.info = timer.getInfoInternal();
/*     */   }
/*     */ 
/*     */   TimerHandleImpl(String timerId, TimedObjectId timedObjectId, Date firstTime, long periode, Serializable info)
/*     */   {
/*  76 */     this.timerId = timerId;
/*  77 */     this.timedObjectId = timedObjectId;
/*  78 */     this.firstTime = firstTime;
/*  79 */     this.periode = periode;
/*  80 */     this.info = info;
/*     */   }
/*     */ 
/*     */   private TimerHandleImpl(String externalForm)
/*     */   {
/*  88 */     if ((!externalForm.startsWith("[")) || (!externalForm.endsWith("]"))) {
/*  89 */       throw new IllegalArgumentException("Square brackets expected arround: " + externalForm);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  94 */       String inStr = externalForm.substring(1, externalForm.length() - 1);
/*     */ 
/*  96 */       if (!inStr.startsWith("id=")) {
/*  97 */         throw new IllegalArgumentException("Cannot parse: " + externalForm);
/*     */       }
/*  99 */       int targetIndex = inStr.indexOf(",target=");
/* 100 */       int firstIndex = inStr.indexOf(",first=");
/*     */ 
/* 102 */       String idStr = inStr.substring(3, targetIndex);
/* 103 */       String targetStr = inStr.substring(targetIndex + 8, firstIndex);
/* 104 */       String restStr = inStr.substring(firstIndex + 1);
/*     */ 
/* 106 */       this.timerId = idStr;
/* 107 */       this.timedObjectId = TimedObjectId.parse(targetStr);
/*     */ 
/* 109 */       StringTokenizer st = new StringTokenizer(restStr, ",=");
/* 110 */       if (st.countTokens() % 2 != 0) {
/* 111 */         throw new IllegalArgumentException("Cannot parse: " + externalForm);
/*     */       }
/* 113 */       SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
/*     */ 
/* 115 */       this.periode = -1L;
/*     */ 
/* 117 */       while (st.hasMoreTokens())
/*     */       {
/* 119 */         String key = st.nextToken();
/* 120 */         String value = st.nextToken();
/* 121 */         if (key.equals("first"))
/* 122 */           this.firstTime = sdf.parse(value);
/* 123 */         if (key.equals("periode")) {
/* 124 */           this.periode = new Long(value).longValue();
/*     */         }
/*     */       }
/* 127 */       if ((this.firstTime == null) || (this.periode < 0L))
/* 128 */         throw new IllegalArgumentException("Cannot parse: " + externalForm);
/*     */     }
/*     */     catch (ParseException e)
/*     */     {
/* 132 */       throw new IllegalArgumentException("Cannot parse date/time in: " + externalForm);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static TimerHandleImpl parse(String externalForm)
/*     */   {
/* 142 */     return new TimerHandleImpl(externalForm);
/*     */   }
/*     */ 
/*     */   public String toExternalForm()
/*     */   {
/* 151 */     SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
/* 152 */     String firstEvent = sdf.format(this.firstTime);
/* 153 */     return "[id=" + this.timerId + ",target=" + this.timedObjectId + ",first=" + firstEvent + ",periode=" + this.periode + "]";
/*     */   }
/*     */ 
/*     */   public String getTimerId()
/*     */   {
/* 158 */     return this.timerId;
/*     */   }
/*     */ 
/*     */   public TimedObjectId getTimedObjectId()
/*     */   {
/* 163 */     return this.timedObjectId;
/*     */   }
/*     */ 
/*     */   public Date getFirstTime()
/*     */   {
/* 168 */     return this.firstTime;
/*     */   }
/*     */ 
/*     */   public long getPeriode()
/*     */   {
/* 173 */     return this.periode;
/*     */   }
/*     */ 
/*     */   public Serializable getInfo()
/*     */   {
/* 178 */     return this.info;
/*     */   }
/*     */ 
/*     */   public Timer getTimer()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 194 */     EJBTimerService ejbTimerService = EJBTimerServiceLocator.getEjbTimerService();
/* 195 */     ObjectName containerId = this.timedObjectId.getContainerId();
/* 196 */     Object instancePk = this.timedObjectId.getInstancePk();
/* 197 */     TimerServiceImpl timerService = (TimerServiceImpl)ejbTimerService.getTimerService(containerId, instancePk);
/* 198 */     if (timerService == null) {
/* 199 */       throw new NoSuchObjectLocalException("TimerService not available: " + this.timedObjectId);
/*     */     }
/* 201 */     TimerImpl timer = (TimerImpl)timerService.getTimer(this);
/* 202 */     if ((timer == null) || (!timer.isActive())) {
/* 203 */       throw new NoSuchObjectLocalException("Timer not available: " + this.timedObjectId);
/*     */     }
/* 205 */     return timer;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 213 */     if (obj == this) return true;
/* 214 */     if ((obj instanceof TimerHandleImpl))
/*     */     {
/* 216 */       TimerHandleImpl other = (TimerHandleImpl)obj;
/* 217 */       return hashCode() == other.hashCode();
/*     */     }
/* 219 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 227 */     if (this.hashCode == 0)
/*     */     {
/* 229 */       this.hashCode = toExternalForm().hashCode();
/*     */     }
/* 231 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 239 */     return toExternalForm();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.TimerHandleImpl
 * JD-Core Version:    0.6.0
 */