/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ public class SecurityActions
/*     */ {
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 143 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader(Thread thread)
/*     */   {
/* 148 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader(thread);
/*     */   }
/*     */ 
/*     */   static SecurityContext createSecurityContext(String securityDomain)
/*     */     throws PrivilegedActionException
/*     */   {
/* 154 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(securityDomain)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 158 */         SecurityContext sc = SecurityContextFactory.createSecurityContext(this.val$securityDomain);
/* 159 */         SecurityContextAssociation.setSecurityContext(sc);
/* 160 */         return sc;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext() {
/* 167 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 172 */         return SecurityContextAssociation.getSecurityContext();
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void setSecurityContext(SecurityContext sc) {
/* 178 */     AccessController.doPrivileged(new PrivilegedAction(sc)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 183 */         SecurityContextAssociation.setSecurityContext(this.val$sc);
/* 184 */         return null;
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(ClassLoader loader) {
/* 190 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(loader);
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(Thread thread, ClassLoader loader)
/*     */   {
/* 195 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(thread, loader);
/*     */   }
/*     */ 
/*     */   static void pushRunAsIdentity(RunAs principal)
/*     */   {
/* 200 */     if (System.getSecurityManager() == null)
/*     */     {
/* 202 */       RunAsIdentityActions.NON_PRIVILEGED.push(principal);
/*     */     }
/*     */     else
/*     */     {
/* 206 */       RunAsIdentityActions.PRIVILEGED.push(principal);
/*     */     }
/*     */   }
/*     */ 
/*     */   static RunAs popRunAsIdentity()
/*     */   {
/* 212 */     if (System.getSecurityManager() == null)
/*     */     {
/* 214 */       return RunAsIdentityActions.NON_PRIVILEGED.pop();
/*     */     }
/*     */ 
/* 218 */     return RunAsIdentityActions.PRIVILEGED.pop();
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 252 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 256 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 261 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 266 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 271 */         thread.setContextClassLoader(cl);
/*     */       }
/* 252 */     };
/*     */ 
/* 275 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 277 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 281 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 277 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 287 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 292 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 296 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 303 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 308 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 309 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 317 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 322 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 323 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 275 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.TCLAction getTCLAction()
/*     */       {
/* 228 */         return System.getSecurityManager() == null ? SecurityActions.TCLAction.NON_PRIVILEGED : SecurityActions.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 233 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 238 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 243 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 248 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface RunAsIdentityActions
/*     */   {
/*  45 */     public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*  47 */       private final PrivilegedAction peekAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  51 */           SecurityContext sc = SecurityActions.getSecurityContext();
/*  52 */           if (sc == null)
/*  53 */             throw new IllegalStateException("Security Context is null");
/*  54 */           return sc.getOutgoingRunAs();
/*     */         }
/*  47 */       };
/*     */ 
/*  59 */       private final PrivilegedAction popAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  64 */           SecurityContext sc = SecurityActions.getSecurityContext();
/*  65 */           if (sc == null)
/*  66 */             throw new IllegalStateException("Security Context is null");
/*  67 */           RunAs ra = sc.getOutgoingRunAs();
/*  68 */           sc.setOutgoingRunAs(null);
/*  69 */           return ra;
/*     */         }
/*  59 */       };
/*     */ 
/*     */       public RunAs peek()
/*     */       {
/*  75 */         return (RunAs)AccessController.doPrivileged(this.peekAction);
/*     */       }
/*     */ 
/*     */       public void push(RunAs id)
/*     */       {
/*  80 */         AccessController.doPrivileged(new PrivilegedAction(id)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  86 */             SecurityContext sc = SecurityActions.getSecurityContext();
/*  87 */             if (sc == null)
/*  88 */               throw new IllegalStateException("Security Context is null");
/*  89 */             sc.setOutgoingRunAs(this.val$id);
/*  90 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public RunAs pop()
/*     */       {
/*  98 */         return (RunAs)AccessController.doPrivileged(this.popAction);
/*     */       }
/*  45 */     };
/*     */ 
/* 102 */     public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*     */       public RunAs peek()
/*     */       {
/* 106 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 107 */         if (sc == null)
/* 108 */           throw new IllegalStateException("Security Context is null");
/* 109 */         return sc.getOutgoingRunAs();
/*     */       }
/*     */ 
/*     */       public void push(RunAs id)
/*     */       {
/* 116 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 117 */         if (sc == null)
/* 118 */           throw new IllegalStateException("Security Context is null");
/* 119 */         sc.setOutgoingRunAs(id);
/*     */       }
/*     */ 
/*     */       public RunAs pop()
/*     */       {
/* 125 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 126 */         if (sc == null)
/* 127 */           throw new IllegalStateException("Security Context is null");
/* 128 */         RunAs ra = sc.getOutgoingRunAs();
/* 129 */         sc.setOutgoingRunAs(null);
/* 130 */         return ra;
/*     */       }
/* 102 */     };
/*     */ 
/*     */     public abstract RunAs peek();
/*     */ 
/*     */     public abstract void push(RunAs paramRunAs);
/*     */ 
/*     */     public abstract RunAs pop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.SecurityActions
 * JD-Core Version:    0.6.0
 */