/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class OracleDatabasePersistencePlugin extends GeneralPurposeDatabasePersistencePlugin
/*     */ {
/*  56 */   private static Logger log = Logger.getLogger(OracleDatabasePersistencePlugin.class);
/*     */ 
/*     */   public void insertTimer(String timerId, TimedObjectId timedObjectId, Date initialExpiration, long intervalDuration, Serializable info)
/*     */     throws SQLException
/*     */   {
/*  69 */     Connection con = null;
/*  70 */     PreparedStatement st = null;
/*     */     try
/*     */     {
/*  73 */       con = this.ds.getConnection();
/*     */ 
/*  75 */       String sql = "insert into " + getTableName() + " " + "(" + getColumnTimerID() + "," + getColumnTargetID() + "," + getColumnInitialDate() + "," + getColumnTimerInterval() + "," + getColumnInstancePK() + "," + getColumnInfo() + ") " + "values (?,?,?,?,?,?)";
/*     */ 
/*  80 */       st = con.prepareStatement(sql);
/*     */ 
/*  82 */       st.setString(1, timerId);
/*  83 */       st.setString(2, timedObjectId.toString());
/*  84 */       st.setTimestamp(3, new Timestamp(initialExpiration.getTime()));
/*  85 */       st.setLong(4, intervalDuration);
/*     */ 
/*  87 */       byte[] pkArr = serialize(timedObjectId.getInstancePk());
/*  88 */       if (pkArr != null)
/*     */       {
/*  90 */         InputStream is = new ByteArrayInputStream(pkArr);
/*  91 */         st.setBinaryStream(5, is, pkArr.length);
/*     */       }
/*     */       else
/*     */       {
/*  95 */         st.setBytes(5, null);
/*     */       }
/*     */ 
/*  98 */       byte[] infoArr = serialize(info);
/*  99 */       if (infoArr != null)
/*     */       {
/* 101 */         InputStream is = new ByteArrayInputStream(infoArr);
/* 102 */         st.setBinaryStream(6, is, infoArr.length);
/*     */       }
/*     */       else
/*     */       {
/* 106 */         st.setBytes(6, null);
/*     */       }
/*     */ 
/* 109 */       int rows = st.executeUpdate();
/* 110 */       if (rows != 1)
/* 111 */         log.error("Unable to insert timer for: " + timedObjectId);
/*     */     }
/*     */     finally
/*     */     {
/* 115 */       JDBCUtil.safeClose(st);
/* 116 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List selectTimers(ObjectName containerId)
/*     */     throws SQLException
/*     */   {
/* 127 */     Connection con = null;
/* 128 */     Statement st = null;
/* 129 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 132 */       con = this.ds.getConnection();
/*     */ 
/* 134 */       List list = new ArrayList();
/*     */ 
/* 136 */       st = con.createStatement();
/* 137 */       rs = st.executeQuery("select * from " + getTableName());
/* 138 */       while (rs.next())
/*     */       {
/* 140 */         timerId = rs.getString(getColumnTimerID());
/* 141 */         TimedObjectId targetId = TimedObjectId.parse(rs.getString(getColumnTargetID()));
/*     */ 
/* 145 */         if ((containerId == null) || (containerId.equals(targetId.getContainerId())))
/*     */         {
/* 147 */           Date initialDate = rs.getTimestamp(getColumnInitialDate());
/* 148 */           long interval = rs.getLong(getColumnTimerInterval());
/*     */ 
/* 150 */           InputStream isPk = rs.getBinaryStream(getColumnInstancePK());
/* 151 */           Serializable pKey = (Serializable)deserialize(isPk);
/* 152 */           Serializable info = null;
/*     */           try
/*     */           {
/* 155 */             InputStream isInfo = rs.getBinaryStream(getColumnInfo());
/* 156 */             info = (Serializable)deserialize(isInfo);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 163 */             log.warn("Cannot deserialize custom info object", e);
/*     */           }
/*     */ 
/* 166 */           targetId = new TimedObjectId(targetId.getContainerId(), pKey);
/* 167 */           TimerHandleImpl handle = new TimerHandleImpl(timerId, targetId, initialDate, interval, info);
/*     */ 
/* 169 */           list.add(handle);
/*     */         }
/*     */       }
/* 172 */       timerId = list;
/*     */     }
/*     */     finally
/*     */     {
/*     */       String timerId;
/* 176 */       JDBCUtil.safeClose(rs);
/* 177 */       JDBCUtil.safeClose(st);
/* 178 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.OracleDatabasePersistencePlugin
 * JD-Core Version:    0.6.0
 */