/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import javax.ejb.TimerService;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class EJBTimerServiceLocator
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(EJBTimerServiceLocator.class);
/*     */   private static EJBTimerService ejbTimerService;
/*     */ 
/*     */   public static EJBTimerService getEjbTimerService()
/*     */   {
/*     */     try
/*     */     {
/*  61 */       MBeanServer server = MBeanServerLocator.locateJBoss();
/*  62 */       if ((server != null) && (server.isRegistered(EJBTimerService.OBJECT_NAME))) {
/*  63 */         ejbTimerService = new MBeanDelegate(server);
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/*  70 */     if (ejbTimerService == null)
/*     */     {
/*  72 */       EJBTimerServiceImpl ejbTimerServiceImpl = new EJBTimerServiceImpl();
/*  73 */       ejbTimerService = ejbTimerServiceImpl;
/*     */       try
/*     */       {
/*  76 */         ejbTimerServiceImpl.create();
/*  77 */         ejbTimerServiceImpl.start();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  81 */         throw new RuntimeException("Cannot start EJBTimerService", e);
/*     */       }
/*     */     }
/*  84 */     return ejbTimerService;
/*     */   }
/*     */ 
/*     */   public static class MBeanDelegate
/*     */     implements EJBTimerService
/*     */   {
/*     */     private EJBTimerService mbeanEjbTimerService;
/*     */ 
/*     */     public MBeanDelegate(MBeanServer server)
/*     */     {
/*     */       try
/*     */       {
/*  98 */         this.mbeanEjbTimerService = ((EJBTimerService)MBeanProxyExt.create(EJBTimerService.class, EJBTimerService.OBJECT_NAME, server));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 102 */         throw new IllegalStateException("Cannot create EJBTimerService proxy: " + e.getMessage());
/*     */       }
/*     */     }
/*     */ 
/*     */     public TimerService createTimerService(ObjectName containerId, Object instancePk, Container container)
/*     */       throws IllegalStateException
/*     */     {
/*     */       try
/*     */       {
/* 111 */         TimerService timerService = this.mbeanEjbTimerService.createTimerService(containerId, instancePk, container);
/* 112 */         return timerService;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 116 */         EJBTimerServiceLocator.log.error("Cannot createTimerService", e);
/* 117 */       }return null;
/*     */     }
/*     */ 
/*     */     public TimerService createTimerService(ObjectName containerId, Object instancePk, TimedObjectInvoker invoker)
/*     */       throws IllegalStateException
/*     */     {
/*     */       try
/*     */       {
/* 126 */         TimerService timerService = this.mbeanEjbTimerService.createTimerService(containerId, instancePk, invoker);
/* 127 */         return timerService;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 131 */         EJBTimerServiceLocator.log.error("Cannot createTimerService", e);
/* 132 */       }return null;
/*     */     }
/*     */ 
/*     */     public TimerService getTimerService(ObjectName containerId, Object instancePk)
/*     */       throws IllegalStateException
/*     */     {
/*     */       try
/*     */       {
/* 141 */         TimerService timerService = this.mbeanEjbTimerService.getTimerService(containerId, instancePk);
/* 142 */         return timerService;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 146 */         EJBTimerServiceLocator.log.error("Cannot getTimerService", e);
/* 147 */       }return null;
/*     */     }
/*     */ 
/*     */     public void removeTimerService(ObjectName containerId, Object instancePk)
/*     */       throws IllegalStateException
/*     */     {
/*     */       try
/*     */       {
/* 156 */         this.mbeanEjbTimerService.removeTimerService(containerId, instancePk);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 160 */         EJBTimerServiceLocator.log.error("Cannot removeTimerService", e);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void removeTimerService(ObjectName containerId, boolean keepState) throws IllegalStateException
/*     */     {
/*     */       try
/*     */       {
/* 168 */         this.mbeanEjbTimerService.removeTimerService(containerId, keepState);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 172 */         EJBTimerServiceLocator.log.error("Cannot removeTimerService", e);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void restoreTimers(ObjectName containerId, ClassLoader loader) throws IllegalStateException
/*     */     {
/*     */       try
/*     */       {
/* 180 */         this.mbeanEjbTimerService.restoreTimers(containerId, loader);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 184 */         EJBTimerServiceLocator.log.error("Cannot restoreTimer", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.EJBTimerServiceLocator
 * JD-Core Version:    0.6.0
 */