/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb.ContainerMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class DatabasePersistencePolicy extends ServiceMBeanSupport
/*     */   implements DatabasePersistencePolicyMBean
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(DatabasePersistencePolicy.class);
/*     */   private DatabasePersistencePlugin dbpPlugin;
/*     */   private ObjectName dataSource;
/*     */   private String dbpPluginClassName;
/*  64 */   private String timersTable = "TIMERS";
/*     */   private List timersToRestore;
/*     */ 
/*     */   public void startService()
/*     */     throws Exception
/*     */   {
/*  75 */     if (this.dbpPluginClassName != null)
/*     */     {
/*  77 */       Class dbpPolicyClass = Thread.currentThread().getContextClassLoader().loadClass(this.dbpPluginClassName);
/*  78 */       this.dbpPlugin = ((DatabasePersistencePlugin)dbpPolicyClass.newInstance());
/*     */     }
/*     */     else
/*     */     {
/*  82 */       this.dbpPlugin = new GeneralPurposeDatabasePersistencePlugin();
/*     */     }
/*     */ 
/*  86 */     if ((this.dbpPlugin instanceof DatabasePersistencePluginExt))
/*     */     {
/*  89 */       ((DatabasePersistencePluginExt)this.dbpPlugin).init(this.server, this.dataSource, this.timersTable);
/*     */     }
/*     */     else
/*     */     {
/*  93 */       this.dbpPlugin.init(this.server, this.dataSource);
/*     */     }
/*     */ 
/*  97 */     if (!this.dbpPlugin.getTableName().equals(this.timersTable))
/*     */     {
/*  99 */       log.warn("Database persistence plugin '" + this.dbpPluginClassName + "' uses hardcoded timers table name: '" + this.dbpPlugin.getTableName());
/*     */     }
/*     */ 
/* 104 */     this.dbpPlugin.createTableIfNotExists();
/*     */   }
/*     */ 
/*     */   public void insertTimer(String timerId, TimedObjectId timedObjectId, Date firstEvent, long intervalDuration, Serializable info)
/*     */   {
/*     */     try
/*     */     {
/* 120 */       this.dbpPlugin.insertTimer(timerId, timedObjectId, firstEvent, intervalDuration, info);
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 124 */       RuntimeException ex = new IllegalStateException("Unable to persist timer");
/* 125 */       ex.initCause(e);
/* 126 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void deleteTimer(String timerId, TimedObjectId timedObjectId)
/*     */   {
/*     */     try
/*     */     {
/* 139 */       this.dbpPlugin.deleteTimer(timerId, timedObjectId);
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 143 */       log.warn("Unable to delete timer", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List listTimerHandles(ObjectName containerId, ClassLoader loader)
/*     */   {
/* 156 */     List list = new ArrayList();
/*     */ 
/* 158 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 161 */       if (loader != null)
/*     */       {
/* 163 */         Thread.currentThread().setContextClassLoader(loader);
/*     */       }
/* 165 */       list.addAll(this.dbpPlugin.selectTimers(containerId));
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 169 */       log.warn("Unable to get timer handles for containerId: " + containerId, e);
/*     */     }
/*     */     finally
/*     */     {
/* 174 */       Thread.currentThread().setContextClassLoader(oldCl);
/*     */     }
/* 176 */     return list;
/*     */   }
/*     */ 
/*     */   public List listTimerHandles()
/*     */   {
/* 184 */     List list = new ArrayList();
/*     */     try
/*     */     {
/* 187 */       list.addAll(this.dbpPlugin.selectTimers(null));
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 191 */       log.warn("Unable to get timer handles", e);
/*     */     }
/* 193 */     return list;
/*     */   }
/*     */ 
/*     */   public void restoreTimers()
/*     */   {
/* 201 */     if ((this.timersToRestore != null) && (this.timersToRestore.size() > 0))
/*     */     {
/* 203 */       log.debug("Restoring " + this.timersToRestore.size() + " timer(s)");
/*     */ 
/* 206 */       for (int i = 0; i < this.timersToRestore.size(); i++)
/*     */       {
/* 208 */         TimerHandleImpl handle = (TimerHandleImpl)this.timersToRestore.get(i);
/*     */         try
/*     */         {
/* 212 */           TimedObjectId targetId = handle.getTimedObjectId();
/* 213 */           ObjectName containerName = targetId.getContainerId();
/* 214 */           ContainerMBean container = (ContainerMBean)MBeanProxyExt.create(ContainerMBean.class, containerName, this.server);
/* 215 */           TimerService timerService = container.getTimerService(targetId.getInstancePk());
/* 216 */           timerService.createTimer(handle.getFirstTime(), handle.getPeriode(), handle.getInfo());
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 220 */           log.warn("Unable to restore timer record: " + handle);
/*     */         }
/*     */       }
/* 223 */       this.timersToRestore.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clearTimers()
/*     */   {
/*     */     try
/*     */     {
/* 234 */       this.dbpPlugin.clearTimers();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 238 */       log.warn("Unable to clear timers", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void resetAndRestoreTimers()
/*     */     throws SQLException
/*     */   {
/* 249 */     this.timersToRestore = this.dbpPlugin.selectTimers(null);
/* 250 */     log.debug("Found " + this.timersToRestore.size() + " timer(s)");
/* 251 */     if (this.timersToRestore.size() > 0)
/*     */     {
/* 254 */       clearTimers();
/*     */     }
/* 256 */     restoreTimers();
/*     */   }
/*     */ 
/*     */   public ObjectName getDataSource()
/*     */   {
/* 266 */     return this.dataSource;
/*     */   }
/*     */ 
/*     */   public void setDataSource(ObjectName dataSource)
/*     */   {
/* 274 */     this.dataSource = dataSource;
/*     */   }
/*     */ 
/*     */   public String getDatabasePersistencePlugin()
/*     */   {
/* 282 */     return this.dbpPluginClassName;
/*     */   }
/*     */ 
/*     */   public void setDatabasePersistencePlugin(String dbpPluginClass)
/*     */   {
/* 290 */     this.dbpPluginClassName = dbpPluginClass;
/*     */   }
/*     */ 
/*     */   public String getTimersTable()
/*     */   {
/* 298 */     return this.timersTable;
/*     */   }
/*     */ 
/*     */   public void setTimersTable(String timersTable)
/*     */   {
/* 306 */     this.timersTable = timersTable;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.DatabasePersistencePolicy
 * JD-Core Version:    0.6.0
 */