/*     */ package org.jboss.ejb.plugins.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.plugins.AbstractInterceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityIdentity;
/*     */ 
/*     */ public class PreSecurityInterceptor extends AbstractInterceptor
/*     */ {
/*  52 */   private String securityDomain = null;
/*     */ 
/*  54 */   private String timedObjectMethod = null;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  59 */     super.setContainer(container);
/*  60 */     if (container != null)
/*     */     {
/*  62 */       AuthenticationManager am = container.getSecurityManager();
/*  63 */       if (am != null)
/*     */       {
/*  65 */         this.securityDomain = am.getSecurityDomain();
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  70 */       this.timedObjectMethod = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class }).getName();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  75 */       this.log.trace("Exception in creating TimedObject method:", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  83 */     if (this.securityDomain == null) {
/*  84 */       return getNext().invoke(mi);
/*     */     }
/*     */ 
/*  87 */     SecurityIdentity si = null;
/*  88 */     Method m = mi.getMethod();
/*  89 */     boolean isEjbTimeOutMethod = (m != null) && (m.getName().equals(this.timedObjectMethod));
/*     */ 
/*  91 */     if ((mi.isLocal()) && (!isEjbTimeOutMethod))
/*     */     {
/*  94 */       SecurityContext sc = SecurityActions.getSecurityContext();
/*  95 */       if (sc != null) {
/*  96 */         si = sc.getUtil().getSecurityIdentity();
/*     */       }
/*     */ 
/*  99 */       mi.setSecurityContext(sc);
/*     */     }
/*     */     else
/*     */     {
/* 103 */       establishSecurityContext(mi);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 109 */       SecurityActions.pushCallerRunAsIdentity(SecurityActions.getSecurityContext().getOutgoingRunAs());
/* 110 */       Object returnValue = getNext().invoke(mi);
/* 111 */       localObject1 = returnValue;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 115 */       SecurityActions.popCallerRunAsIdentity();
/* 116 */       if ((mi.isLocal()) && (si != null))
/* 117 */         SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 125 */     if (this.securityDomain == null) {
/* 126 */       return getNext().invokeHome(mi);
/*     */     }
/* 128 */     SecurityIdentity si = null;
/* 129 */     Method m = mi.getMethod();
/* 130 */     boolean isEjbTimeOutMethod = (m != null) && (m.getName().equals(this.timedObjectMethod));
/*     */ 
/* 132 */     if ((mi.isLocal()) && (!isEjbTimeOutMethod))
/*     */     {
/* 135 */       SecurityContext sc = SecurityActions.getSecurityContext();
/* 136 */       if (sc != null) {
/* 137 */         si = sc.getUtil().getSecurityIdentity();
/*     */       }
/* 139 */       mi.setSecurityContext(sc);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       establishSecurityContext(mi);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 148 */       SecurityActions.pushCallerRunAsIdentity(SecurityActions.getSecurityContext().getOutgoingRunAs());
/* 149 */       Object returnValue = getNext().invokeHome(mi);
/* 150 */       localObject1 = returnValue;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 154 */       SecurityActions.popCallerRunAsIdentity();
/* 155 */       if ((mi.isLocal()) && (si != null))
/* 156 */         SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void establishSecurityContext(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 165 */     SecurityContext sc = mi.getSecurityContext();
/* 166 */     SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain, this.container.getSecurityContextClassName());
/*     */ 
/* 169 */     if (sc != null)
/*     */     {
/* 172 */       SecurityActions.setSecurityIdentity(newSC, sc.getUtil().getSecurityIdentity());
/*     */     }
/*     */     else
/*     */     {
/* 178 */       mi.setSecurityContext(newSC);
/*     */     }
/*     */ 
/* 181 */     newSC.setSecurityManagement(this.container.getSecurityManagement());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.security.PreSecurityInterceptor
 * JD-Core Version:    0.6.0
 */