/*     */ package org.jboss.ejb.plugins.lock;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashSet;
/*     */ import java.util.Stack;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ 
/*     */ public class SimpleReadWriteEJBLock extends BeanLockSupport
/*     */ {
/*     */   int writersWaiting;
/*     */   Transaction promotingReader;
/*     */   Transaction writer;
/*     */   HashSet readers;
/*     */   Object methodLock;
/*     */   boolean trace;
/* 280 */   private static Stack kRecycledRelievers = new Stack();
/*     */ 
/*     */   public SimpleReadWriteEJBLock()
/*     */   {
/*  63 */     this.writersWaiting = 0;
/*  64 */     this.promotingReader = null;
/*  65 */     this.writer = null;
/*  66 */     this.readers = new HashSet();
/*  67 */     this.methodLock = new Object();
/*  68 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   private void trace(Transaction tx, String message) {
/*  72 */     trace(tx, message, null);
/*     */   }
/*     */ 
/*     */   private void trace(Transaction tx, String message, Method method)
/*     */   {
/*  77 */     if (method != null)
/*  78 */       log.trace("LOCK(" + this.id + "):" + message + " : " + tx + " - " + method.getDeclaringClass().getName() + "." + method.getName());
/*     */     else
/*  80 */       log.trace("LOCK(" + this.id + "):" + message + " : " + tx);
/*     */   }
/*     */ 
/*     */   public void schedule(Invocation mi)
/*     */   {
/*  85 */     boolean reading = mi.getMethod() == null ? false : this.container.getBeanMetaData().isMethodReadOnly(mi.getMethod().getName());
/*  86 */     Transaction miTx = mi.getTransaction();
/*     */ 
/*  88 */     sync();
/*     */     try
/*     */     {
/*  91 */       if (reading)
/*     */       {
/*  93 */         if (this.trace)
/*  94 */           trace(miTx, "READ  (RQ)", mi.getMethod());
/*  95 */         getReadLock(miTx);
/*  96 */         if (this.trace)
/*  97 */           trace(miTx, "READ  (GT)", mi.getMethod());
/*     */       }
/*     */       else
/*     */       {
/* 101 */         if (this.trace)
/* 102 */           trace(miTx, "WRITE (RQ)", mi.getMethod());
/* 103 */         getWriteLock(miTx);
/* 104 */         if (this.trace)
/* 105 */           trace(miTx, "WRITE (GT)", mi.getMethod());
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 110 */       releaseSync();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getReadLock(Transaction tx)
/*     */   {
/* 116 */     boolean done = false;
/*     */ 
/* 118 */     while (!done)
/*     */     {
/* 120 */       if (tx == null)
/*     */       {
/* 122 */         done = this.writer == null;
/*     */       }
/* 124 */       else if (this.readers.contains(tx))
/*     */       {
/* 126 */         done = true;
/*     */       }
/* 128 */       else if ((this.writer == null) && (this.promotingReader == null) && (this.writersWaiting == 0))
/*     */       {
/*     */         try
/*     */         {
/* 132 */           ReadLockReliever reliever = getReliever();
/* 133 */           reliever.setup(this, tx);
/* 134 */           tx.registerSynchronization(reliever);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 138 */           throw new EJBException(e);
/*     */         }
/* 140 */         this.readers.add(tx);
/* 141 */         done = true;
/*     */       }
/* 143 */       else if ((this.writer != null) && (this.writer.equals(tx)))
/*     */       {
/* 145 */         done = true;
/*     */       }
/*     */ 
/* 148 */       if (done)
/*     */         continue;
/* 150 */       if (this.trace) {
/* 151 */         trace(tx, "READ (WT) writer:" + this.writer + " writers waiting: " + this.writersWaiting + " reader count: " + this.readers.size());
/*     */       }
/* 153 */       waitAWhile(tx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getWriteLock(Transaction tx)
/*     */   {
/* 160 */     boolean done = false;
/*     */ 
/* 163 */     if (tx == null) {
/* 164 */       throw new EJBException("Write lock requested without transaction.");
/*     */     }
/* 166 */     boolean isReader = this.readers.contains(tx);
/* 167 */     this.writersWaiting += 1;
/* 168 */     while (!done)
/*     */     {
/* 170 */       if ((this.writer == null) && ((this.readers.isEmpty()) || ((this.readers.size() == 1) && (isReader))))
/*     */       {
/* 172 */         this.writersWaiting -= 1;
/* 173 */         this.promotingReader = null;
/* 174 */         this.writer = tx;
/* 175 */         done = true; continue;
/*     */       }
/* 177 */       if ((this.writer != null) && (this.writer.equals(tx)))
/*     */       {
/* 179 */         this.writersWaiting -= 1;
/* 180 */         done = true; continue;
/*     */       }
/*     */ 
/* 184 */       if (isReader)
/*     */       {
/* 186 */         if ((this.promotingReader != null) && (!this.promotingReader.equals(tx)))
/*     */         {
/* 188 */           this.writersWaiting -= 1;
/* 189 */           throw new EJBException("Contention on read lock promotion for bean.  Exception in second transaction");
/*     */         }
/* 191 */         this.promotingReader = tx;
/*     */       }
/*     */ 
/* 194 */       if (this.trace) {
/* 195 */         trace(tx, "WRITE (WT) writer:" + this.writer + " writers waiting: " + this.writersWaiting + " reader count: " + this.readers.size());
/*     */       }
/* 197 */       waitAWhile(tx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void waitAWhile(Transaction tx)
/*     */   {
/* 208 */     releaseSync();
/*     */     try
/*     */     {
/* 211 */       synchronized (this.readers)
/*     */       {
/*     */         try
/*     */         {
/* 215 */           this.readers.wait(this.txTimeout);
/*     */         }
/*     */         catch (InterruptedException e) {
/*     */         }
/* 219 */         checkTransaction(tx);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 224 */       sync();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void notifyWaiters()
/*     */   {
/* 234 */     synchronized (this.readers)
/*     */     {
/* 236 */       this.readers.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void releaseReadLock(Transaction transaction)
/*     */   {
/* 242 */     if (this.trace) {
/* 243 */       trace(transaction, "READ  (UL)");
/*     */     }
/* 245 */     if (!this.readers.remove(transaction)) {
/* 246 */       throw new IllegalStateException("ReadWriteEJBLock: Read lock released when it wasn't taken");
/*     */     }
/* 248 */     notifyWaiters();
/*     */   }
/*     */ 
/*     */   private void releaseWriteLock(Transaction transaction)
/*     */   {
/* 253 */     if (this.trace) {
/* 254 */       trace(transaction, "WRITE (UL)");
/*     */     }
/* 256 */     if (this.synched == null) {
/* 257 */       throw new IllegalStateException("ReadWriteEJBLock: Do not call nextTransaction while not synched!");
/*     */     }
/* 259 */     if ((this.writer != null) && (!this.writer.equals(transaction))) {
/* 260 */       throw new IllegalStateException("ReadWriteEJBLock: can't unlock a write lock with a different transaction");
/*     */     }
/* 262 */     this.writer = null;
/* 263 */     notifyWaiters();
/*     */   }
/*     */ 
/*     */   public void endTransaction(Transaction transaction)
/*     */   {
/* 268 */     releaseWriteLock(transaction);
/*     */   }
/*     */ 
/*     */   public void wontSynchronize(Transaction transaction)
/*     */   {
/* 273 */     releaseWriteLock(transaction);
/*     */   }
/*     */ 
/*     */   public void endInvocation(Invocation mi)
/*     */   {
/*     */   }
/*     */ 
/*     */   static synchronized ReadLockReliever getReliever()
/*     */   {
/*     */     ReadLockReliever reliever;
/*     */     ReadLockReliever reliever;
/* 285 */     if (!kRecycledRelievers.empty())
/* 286 */       reliever = (ReadLockReliever)kRecycledRelievers.pop();
/*     */     else {
/* 288 */       reliever = new ReadLockReliever(null);
/*     */     }
/* 290 */     return reliever;
/*     */   }
/*     */ 
/*     */   private void checkTransaction(Transaction tx)
/*     */   {
/*     */     try
/*     */     {
/* 339 */       if ((tx != null) && (tx.getStatus() == 1))
/* 340 */         throw new EJBException("Transaction marked for rollback - probably a timeout.");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 344 */       throw new EJBException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ReadLockReliever
/*     */     implements Synchronization
/*     */   {
/*     */     SimpleReadWriteEJBLock lock;
/*     */     Transaction transaction;
/*     */ 
/*     */     protected void finalize()
/*     */     {
/* 300 */       recycle();
/*     */     }
/*     */ 
/*     */     protected void recycle()
/*     */     {
/* 305 */       this.lock = null;
/* 306 */       this.transaction = null;
/* 307 */       SimpleReadWriteEJBLock.kRecycledRelievers.push(this);
/*     */     }
/*     */ 
/*     */     void setup(SimpleReadWriteEJBLock lock, Transaction transaction)
/*     */     {
/* 312 */       this.lock = lock;
/* 313 */       this.transaction = transaction;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 322 */       this.lock.sync();
/*     */       try
/*     */       {
/* 325 */         this.lock.releaseReadLock(this.transaction);
/*     */       }
/*     */       finally
/*     */       {
/* 329 */         this.lock.releaseSync();
/*     */       }
/* 331 */       recycle();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.lock.SimpleReadWriteEJBLock
 * JD-Core Version:    0.6.0
 */