/*     */ package org.jboss.ejb.plugins.lock;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedList;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.monitor.LockMonitor;
/*     */ import org.jboss.util.deadlock.DeadlockDetector;
/*     */ 
/*     */ public class QueuedPessimisticEJBLock extends BeanLockSupport
/*     */ {
/*     */   private HashMap txLocks;
/*     */   private LinkedList txWaitQueue;
/*     */   private int txIdGen;
/*     */   protected LockMonitor lockMonitor;
/*     */   protected boolean deadlockDetection;
/*     */ 
/*     */   public QueuedPessimisticEJBLock()
/*     */   {
/*  67 */     this.txLocks = new HashMap();
/*  68 */     this.txWaitQueue = new LinkedList();
/*     */ 
/*  70 */     this.txIdGen = 0;
/*  71 */     this.lockMonitor = null;
/*     */ 
/*  73 */     this.deadlockDetection = true;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container) {
/*  77 */     this.container = container;
/*  78 */     this.lockMonitor = container.getLockManager().getLockMonitor();
/*     */   }
/*     */ 
/*     */   public boolean getDeadlockDetection()
/*     */   {
/*  83 */     return this.deadlockDetection;
/*     */   }
/*     */ 
/*     */   public void setDeadlockDetection(boolean flag) {
/*  87 */     this.deadlockDetection = flag;
/*     */   }
/*     */ 
/*     */   protected TxLock getTxLock(Transaction miTx)
/*     */   {
/* 157 */     TxLock lock = null;
/* 158 */     if (miTx == null)
/*     */     {
/* 161 */       lock = new TxLock(null);
/* 162 */       this.txWaitQueue.addLast(lock);
/*     */     }
/*     */     else
/*     */     {
/* 166 */       TxLock key = new TxLock(miTx);
/* 167 */       lock = (TxLock)this.txLocks.get(key);
/* 168 */       if (lock == null)
/*     */       {
/* 170 */         this.txLocks.put(key, key);
/* 171 */         this.txWaitQueue.addLast(key);
/* 172 */         lock = key;
/*     */       }
/*     */     }
/* 175 */     return lock;
/*     */   }
/*     */ 
/*     */   protected boolean isTxExpired(Transaction miTx)
/*     */     throws Exception
/*     */   {
/* 182 */     return (miTx != null) && (miTx.getStatus() == 1);
/*     */   }
/*     */ 
/*     */   public void schedule(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 190 */     boolean threadScheduled = false;
/* 191 */     while (!threadScheduled)
/*     */     {
/* 194 */       threadScheduled = doSchedule(mi);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean doSchedule(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 211 */     boolean wasThreadScheduled = false;
/* 212 */     Transaction miTx = mi.getTransaction();
/* 213 */     boolean trace = log.isTraceEnabled();
/* 214 */     sync();
/*     */     try
/*     */     {
/* 217 */       if (trace) log.trace("Begin schedule, key=" + mi.getId());
/*     */ 
/* 219 */       if (isTxExpired(miTx))
/*     */       {
/* 221 */         log.error("Saw rolled back tx=" + miTx);
/* 222 */         throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
/*     */       }
/*     */ 
/* 227 */       long startWait = System.currentTimeMillis();
/*     */       try
/*     */       {
/* 230 */         wasThreadScheduled = waitForTx(miTx, trace);
/* 231 */         if ((wasThreadScheduled) && (this.lockMonitor != null))
/*     */         {
/* 233 */           long endWait = System.currentTimeMillis() - startWait;
/* 234 */           this.lockMonitor.finishedContending(endWait);
/*     */         }
/*     */       }
/*     */       catch (Exception throwable)
/*     */       {
/* 239 */         if ((this.lockMonitor != null) && (isTxExpired(miTx)))
/*     */         {
/* 241 */           this.lockMonitor.increaseTimeouts();
/*     */         }
/* 243 */         if (this.lockMonitor != null)
/*     */         {
/* 245 */           long endWait = System.currentTimeMillis() - startWait;
/* 246 */           this.lockMonitor.finishedContending(endWait);
/*     */         }
/* 248 */         throw throwable;
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 253 */       if ((miTx == null) && (wasThreadScheduled))
/*     */       {
/* 259 */         nextTransaction();
/*     */       }
/* 261 */       releaseSync();
/*     */     }
/*     */ 
/* 265 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean waitForTx(Transaction miTx, boolean trace)
/*     */     throws Exception
/*     */   {
/* 275 */     boolean wasScheduled = false;
/*     */ 
/* 280 */     TxLock txLock = null;
/* 281 */     Object deadlocker = miTx;
/* 282 */     if (deadlocker == null) deadlocker = Thread.currentThread();
/*     */ 
/* 284 */     while ((getTransaction() != null) && (!getTransaction().equals(miTx)))
/*     */     {
/*     */       try
/*     */       {
/* 291 */         if (this.deadlockDetection == true) {
/* 292 */           DeadlockDetector.singleton.deadlockDetection(deadlocker, this);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 297 */         if ((txLock != null) && (txLock.isQueued))
/*     */         {
/* 299 */           this.txLocks.remove(txLock);
/* 300 */           this.txWaitQueue.remove(txLock);
/*     */         }
/* 302 */         throw e;
/*     */       }
/*     */ 
/* 305 */       wasScheduled = true;
/* 306 */       if (this.lockMonitor != null) this.lockMonitor.contending();
/*     */ 
/* 309 */       if (trace) log.trace("Transactional contention on context" + this.id);
/*     */ 
/* 312 */       if (txLock == null) {
/* 313 */         txLock = getTxLock(miTx);
/*     */       }
/* 315 */       if (trace) log.trace("Begin wait on Tx=" + getTransaction());
/*     */ 
/* 318 */       synchronized (txLock)
/*     */       {
/* 320 */         releaseSync();
/*     */         try
/*     */         {
/* 323 */           txLock.wait(this.txTimeout);
/*     */         }
/*     */         catch (InterruptedException ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 330 */       sync();
/*     */ 
/* 332 */       if (trace) log.trace("End wait on TxLock=" + getTransaction());
/* 333 */       if (!isTxExpired(miTx))
/*     */         continue;
/* 335 */       log.error(Thread.currentThread() + "Saw rolled back tx=" + miTx + " waiting for txLock");
/*     */ 
/* 339 */       if (txLock.isQueued)
/*     */       {
/* 344 */         this.txLocks.remove(txLock);
/* 345 */         this.txWaitQueue.remove(txLock);
/*     */       }
/* 347 */       else if ((getTransaction() != null) && (getTransaction().equals(miTx)))
/*     */       {
/* 350 */         nextTransaction();
/*     */       }
/* 352 */       if (miTx != null)
/*     */       {
/* 354 */         if (this.deadlockDetection == true)
/* 355 */           DeadlockDetector.singleton.removeWaiting(deadlocker);
/*     */       }
/* 357 */       throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
/*     */     }
/*     */ 
/* 362 */     if (!wasScheduled)
/*     */     {
/* 364 */       setTransaction(miTx);
/*     */     }
/* 366 */     return wasScheduled;
/*     */   }
/*     */ 
/*     */   protected void nextTransaction()
/*     */   {
/* 379 */     if (this.synched == null)
/*     */     {
/* 381 */       throw new IllegalStateException("do not call nextTransaction while not synched!");
/*     */     }
/*     */ 
/* 384 */     setTransaction(null);
/*     */ 
/* 386 */     if (!this.txWaitQueue.isEmpty())
/*     */     {
/* 388 */       TxLock thelock = (TxLock)this.txWaitQueue.removeFirst();
/* 389 */       this.txLocks.remove(thelock);
/* 390 */       thelock.isQueued = false;
/*     */ 
/* 393 */       setTransaction(thelock.waitingTx);
/*     */ 
/* 395 */       if (this.deadlockDetection == true) {
/* 396 */         DeadlockDetector.singleton.removeWaiting(thelock.deadlocker);
/*     */       }
/* 398 */       synchronized (thelock)
/*     */       {
/* 402 */         thelock.notifyAll();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endTransaction(Transaction transaction)
/*     */   {
/* 413 */     nextTransaction();
/*     */   }
/*     */ 
/*     */   public void wontSynchronize(Transaction trasaction)
/*     */   {
/* 418 */     nextTransaction();
/*     */   }
/*     */ 
/*     */   public void endInvocation(Invocation mi)
/*     */   {
/* 430 */     Transaction tx = mi.getTransaction();
/* 431 */     if ((tx != null) && (tx.equals(getTransaction())))
/*     */     {
/* 434 */       EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/* 435 */       if ((ctx == null) || (!ctx.hasTxSynchronization()))
/* 436 */         endTransaction(tx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeRef()
/*     */   {
/* 442 */     this.refs -= 1;
/* 443 */     if ((this.refs == 0) && (this.txWaitQueue.size() > 0))
/*     */     {
/* 445 */       log.error("removing bean lock and it has tx's in QUEUE! " + toString());
/* 446 */       throw new IllegalStateException("removing bean lock and it has tx's in QUEUE!");
/*     */     }
/* 448 */     if ((this.refs == 0) && (getTransaction() != null))
/*     */     {
/* 450 */       log.error("removing bean lock and it has tx set! " + toString());
/* 451 */       throw new IllegalStateException("removing bean lock and it has tx set!");
/*     */     }
/* 453 */     if (this.refs < 0)
/*     */     {
/* 455 */       log.error("negative lock reference count should never happen !");
/* 456 */       throw new IllegalStateException("negative lock reference count !");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 462 */     StringBuffer buffer = new StringBuffer(100);
/* 463 */     buffer.append(super.toString());
/* 464 */     buffer.append(", bean=").append(this.container.getBeanMetaData().getEjbName());
/* 465 */     buffer.append(", id=").append(this.id);
/* 466 */     buffer.append(", refs=").append(this.refs);
/* 467 */     buffer.append(", tx=").append(getTransaction());
/* 468 */     buffer.append(", synched=").append(this.synched);
/* 469 */     buffer.append(", timeout=").append(this.txTimeout);
/* 470 */     buffer.append(", queue=").append(new ArrayList(this.txWaitQueue));
/* 471 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private class TxLock
/*     */   {
/*  93 */     public Transaction waitingTx = null;
/*  94 */     public int id = 0;
/*     */     public String threadName;
/*     */     public boolean isQueued;
/*     */     public Object deadlocker;
/*     */ 
/*     */     public TxLock(Transaction trans)
/*     */     {
/* 106 */       this.threadName = Thread.currentThread().toString();
/* 107 */       this.waitingTx = trans;
/* 108 */       if (trans == null)
/*     */       {
/* 110 */         if (QueuedPessimisticEJBLock.this.txIdGen < 0) QueuedPessimisticEJBLock.access$002(QueuedPessimisticEJBLock.this, 0);
/* 111 */         this.id = QueuedPessimisticEJBLock.access$008(QueuedPessimisticEJBLock.this);
/* 112 */         this.deadlocker = Thread.currentThread();
/*     */       }
/*     */       else
/*     */       {
/* 116 */         this.deadlocker = trans;
/*     */       }
/* 118 */       this.isQueued = true;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj)
/*     */     {
/* 123 */       if (obj == this) return true;
/*     */ 
/* 125 */       TxLock lock = (TxLock)obj;
/*     */ 
/* 127 */       if ((lock.waitingTx == null) && (this.waitingTx == null))
/*     */       {
/* 129 */         return lock.id == this.id;
/*     */       }
/* 131 */       if ((lock.waitingTx != null) && (this.waitingTx != null))
/*     */       {
/* 133 */         return lock.waitingTx.equals(this.waitingTx);
/*     */       }
/* 135 */       return false;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 140 */       return this.id;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 146 */       StringBuffer buffer = new StringBuffer(100);
/* 147 */       buffer.append("TXLOCK waitingTx=").append(this.waitingTx);
/* 148 */       buffer.append(" id=").append(this.id);
/* 149 */       buffer.append(" thread=").append(this.threadName);
/* 150 */       buffer.append(" queued=").append(this.isQueued);
/* 151 */       return buffer.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock
 * JD-Core Version:    0.6.0
 */