/*     */ package org.jboss.ejb.plugins.lock;
/*     */ 
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.util.deadlock.ApplicationDeadlockException;
/*     */ import org.jboss.util.deadlock.DeadlockDetector;
/*     */ import org.jboss.util.deadlock.Resource;
/*     */ 
/*     */ public class NonReentrantLock
/*     */   implements Resource
/*     */ {
/*     */   protected Thread lockHolder;
/*  57 */   protected Object lock = new Object();
/*  58 */   protected volatile int held = 0;
/*  59 */   protected Transaction holdingTx = null;
/*     */   private boolean inNonReentrant;
/*     */ 
/*     */   public Object getResourceHolder()
/*     */   {
/*  64 */     if (this.holdingTx != null) return this.holdingTx;
/*  65 */     return this.lockHolder;
/*     */   }
/*     */ 
/*     */   protected boolean acquireNonReentrant(long waitTime, Transaction miTx)
/*     */     throws ApplicationDeadlockException, InterruptedException, NonReentrantLock.ReentranceException
/*     */   {
/*  71 */     synchronized (this.lock)
/*     */     {
/*  73 */       Thread curThread = Thread.currentThread();
/*  74 */       if (this.lockHolder != null)
/*     */       {
/*  76 */         if (this.lockHolder == curThread)
/*     */         {
/*  78 */           if (this.inNonReentrant)
/*     */           {
/*  80 */             throw new ReentranceException("The same thread reentered: thread-holder=" + this.lockHolder + ", holding tx=" + this.holdingTx + ", current tx=" + miTx);
/*     */           }
/*     */ 
/*     */         }
/*  87 */         else if ((miTx != null) && (miTx.equals(this.holdingTx)))
/*     */         {
/*  89 */           if (this.inNonReentrant)
/*     */           {
/*  91 */             throw new ReentranceException("The same tx reentered: tx=" + miTx + ", holding thread=" + this.lockHolder + ", current thread=" + curThread);
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 101 */           Object deadlocker = curThread;
/* 102 */           if (miTx != null) deadlocker = miTx;
/*     */           try
/*     */           {
/* 105 */             DeadlockDetector.singleton.deadlockDetection(deadlocker, this);
/* 106 */             while (this.lockHolder != null)
/*     */             {
/* 108 */               if (waitTime < 1L)
/*     */               {
/* 110 */                 this.lock.wait();
/*     */               }
/*     */               else
/*     */               {
/* 114 */                 this.lock.wait(waitTime);
/*     */               }
/*     */ 
/* 117 */               if ((waitTime <= 0L) || (this.lockHolder == null)) continue; int i = 0;
/*     */ 
/* 122 */               DeadlockDetector.singleton.removeWaiting(deadlocker); return i;
/*     */             } } finally { DeadlockDetector.singleton.removeWaiting(deadlocker);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 127 */       this.held += 1;
/* 128 */       this.lockHolder = curThread;
/* 129 */       this.holdingTx = miTx;
/* 130 */       this.inNonReentrant = true;
/*     */     }
/* 132 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean acquireReentrant(long waitTime, Transaction miTx)
/*     */     throws ApplicationDeadlockException, InterruptedException, NonReentrantLock.ReentranceException
/*     */   {
/* 138 */     synchronized (this.lock)
/*     */     {
/* 140 */       Thread curThread = Thread.currentThread();
/* 141 */       if (this.lockHolder != null)
/*     */       {
/* 143 */         if ((this.lockHolder != curThread) && ((miTx == null) || (miTx.equals(this.holdingTx))))
/*     */         {
/* 146 */           Object deadlocker = curThread;
/* 147 */           if (miTx != null) deadlocker = miTx;
/*     */           try
/*     */           {
/* 150 */             DeadlockDetector.singleton.deadlockDetection(deadlocker, this);
/* 151 */             while (this.lockHolder != null)
/*     */             {
/* 153 */               if (waitTime < 1L)
/*     */               {
/* 155 */                 this.lock.wait();
/*     */               }
/*     */               else
/*     */               {
/* 159 */                 this.lock.wait(waitTime);
/*     */               }
/*     */ 
/* 162 */               if ((waitTime <= 0L) || (this.lockHolder == null)) continue; int i = 0;
/*     */ 
/* 167 */               DeadlockDetector.singleton.removeWaiting(deadlocker); return i;
/*     */             } } finally { DeadlockDetector.singleton.removeWaiting(deadlocker);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 172 */       this.held += 1;
/* 173 */       this.lockHolder = curThread;
/* 174 */       this.holdingTx = miTx;
/*     */     }
/* 176 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean attempt(long waitTime, Transaction miTx, boolean nonReentrant)
/*     */     throws ApplicationDeadlockException, InterruptedException, NonReentrantLock.ReentranceException
/*     */   {
/* 182 */     return nonReentrant ? acquireNonReentrant(waitTime, miTx) : acquireReentrant(waitTime, miTx);
/*     */   }
/*     */ 
/*     */   public void release(boolean nonReentrant)
/*     */   {
/* 187 */     synchronized (this.lock)
/*     */     {
/* 189 */       this.held -= 1;
/* 190 */       if (this.held < 0)
/*     */       {
/* 192 */         throw new IllegalStateException("Released lock too many times");
/*     */       }
/* 194 */       if (this.held == 0)
/*     */       {
/* 196 */         this.lockHolder = null;
/* 197 */         this.holdingTx = null;
/* 198 */         this.lock.notify();
/*     */       }
/*     */ 
/* 201 */       if (nonReentrant)
/*     */       {
/* 203 */         this.inNonReentrant = false;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class ReentranceException extends Exception
/*     */   {
/*     */     public ReentranceException()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ReentranceException(String message)
/*     */     {
/*  50 */       super();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.lock.NonReentrantLock
 * JD-Core Version:    0.6.0
 */