/*     */ package org.jboss.ejb.plugins.lock;
/*     */ 
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.BeanLock;
/*     */ import org.jboss.ejb.BeanLockExt;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.deadlock.Resource;
/*     */ 
/*     */ public abstract class BeanLockSupport
/*     */   implements Resource, BeanLockExt
/*     */ {
/*  43 */   protected Container container = null;
/*     */ 
/*  49 */   protected int refs = 0;
/*     */ 
/*  52 */   protected Object id = null;
/*     */ 
/*  55 */   static Logger log = Logger.getLogger(BeanLock.class);
/*     */ 
/*  58 */   protected Transaction tx = null;
/*     */ 
/*  60 */   protected Thread synched = null;
/*  61 */   protected int synchedDepth = 0;
/*     */   protected int txTimeout;
/*     */ 
/*     */   public void setId(Object id)
/*     */   {
/*  66 */     this.id = id; } 
/*  67 */   public Object getId() { return this.id; } 
/*  68 */   public void setTimeout(int timeout) { this.txTimeout = timeout; } 
/*  69 */   public void setContainer(Container container) { this.container = container; } 
/*  70 */   public Object getResourceHolder() { return this.tx;
/*     */   }
/*     */ 
/*     */   public boolean attemptSync()
/*     */   {
/*  81 */     boolean didSync = false;
/*  82 */     synchronized (this)
/*     */     {
/*  84 */       Thread thread = Thread.currentThread();
/*  85 */       if ((this.synched == null) || (this.synched.equals(thread) == true))
/*     */       {
/*  87 */         this.synched = thread;
/*  88 */         this.synchedDepth += 1;
/*  89 */         didSync = true;
/*     */       }
/*     */     }
/*  92 */     return didSync;
/*     */   }
/*     */ 
/*     */   public void sync()
/*     */   {
/* 103 */     synchronized (this)
/*     */     {
/* 105 */       Thread thread = Thread.currentThread();
/* 106 */       while ((this.synched != null) && (!this.synched.equals(thread)))
/*     */       {
/*     */         try
/*     */         {
/* 110 */           wait();
/*     */         } catch (InterruptedException ex) {
/*     */         }
/*     */       }
/* 114 */       this.synched = thread;
/* 115 */       this.synchedDepth += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void releaseSync()
/*     */   {
/* 121 */     synchronized (this)
/*     */     {
/* 123 */       if (--this.synchedDepth == 0)
/* 124 */         this.synched = null;
/* 125 */       notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   public abstract void schedule(Invocation paramInvocation)
/*     */     throws Exception;
/*     */ 
/*     */   public void setTransaction(Transaction tx)
/*     */   {
/* 135 */     this.tx = tx; } 
/* 136 */   public Transaction getTransaction() { return this.tx; } 
/*     */   public abstract void endTransaction(Transaction paramTransaction);
/*     */ 
/*     */   public abstract void wontSynchronize(Transaction paramTransaction);
/*     */ 
/*     */   public abstract void endInvocation(Invocation paramInvocation);
/*     */ 
/* 143 */   public void addRef() { this.refs += 1; } 
/* 144 */   public void removeRef() { this.refs -= 1; } 
/* 145 */   public int getRefs() { return this.refs;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.lock.BeanLockSupport
 * JD-Core Version:    0.6.0
 */