/*     */ package org.jboss.ejb.plugins.local;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.naming.InitialContext;
/*     */ 
/*     */ class StatelessSessionProxy extends LocalProxy
/*     */   implements InvocationHandler
/*     */ {
/*     */   static final long serialVersionUID = 5677941766264344565L;
/*     */ 
/*     */   StatelessSessionProxy(String jndiName, BaseLocalProxyFactory factory)
/*     */   {
/*  45 */     super(jndiName, factory);
/*     */   }
/*     */ 
/*     */   protected Object getId()
/*     */   {
/*  50 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public final Object invoke(Object proxy, Method m, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  56 */     Object retValue = null;
/*  57 */     if (args == null) {
/*  58 */       args = EMPTY_ARGS;
/*     */     }
/*     */ 
/*  61 */     if (m.equals(TO_STRING))
/*     */     {
/*  63 */       retValue = this.jndiName + ":Stateless";
/*     */     }
/*  65 */     else if (m.equals(EQUALS))
/*     */     {
/*  67 */       retValue = invoke(proxy, IS_IDENTICAL, args);
/*     */     }
/*  69 */     else if (m.equals(HASH_CODE))
/*     */     {
/*  73 */       retValue = new Integer(hashCode());
/*     */     }
/*  75 */     else if (m.equals(GET_PRIMARY_KEY))
/*     */     {
/*  80 */       if ((proxy instanceof EJBObject))
/*     */       {
/*  82 */         throw new RemoteException("Call to getPrimaryKey not allowed on session bean");
/*     */       }
/*  84 */       if ((proxy instanceof EJBLocalObject))
/*     */       {
/*  86 */         throw new EJBException("Call to getPrimaryKey not allowed on session bean");
/*     */       }
/*     */     } else {
/*  89 */       if (m.equals(GET_EJB_HOME))
/*     */       {
/*  91 */         InitialContext ctx = new InitialContext();
/*  92 */         return ctx.lookup(this.jndiName);
/*     */       }
/*  94 */       if (m.equals(IS_IDENTICAL))
/*     */       {
/*  98 */         retValue = isIdentical(args[0], this.jndiName + ":Stateless");
/*     */       }
/*     */       else
/*     */       {
/* 103 */         retValue = this.factory.invoke(this.jndiName, m, args);
/*     */       }
/*     */     }
/* 106 */     return retValue;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.local.StatelessSessionProxy
 * JD-Core Version:    0.6.0
 */