/*     */ package org.jboss.ejb.plugins.local;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.naming.InitialContext;
/*     */ 
/*     */ public abstract class LocalProxy
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 8387750757101826407L;
/*  47 */   protected static final Object[] EMPTY_ARGS = new Object[0];
/*     */   protected static final Method TO_STRING;
/*     */   protected static final Method HASH_CODE;
/*     */   protected static final Method EQUALS;
/*     */   protected static final Method GET_PRIMARY_KEY;
/*     */   protected static final Method GET_EJB_HOME;
/*     */   protected static final Method IS_IDENTICAL;
/*     */   protected static final Method REMOVE;
/*     */   protected String jndiName;
/*     */   protected transient BaseLocalProxyFactory factory;
/*     */ 
/*     */   protected String getJndiName()
/*     */   {
/* 118 */     return this.jndiName;
/*     */   }
/*     */   protected abstract Object getId();
/*     */ 
/*     */   public LocalProxy(String jndiName, BaseLocalProxyFactory factory) {
/* 124 */     this.jndiName = jndiName;
/* 125 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   Boolean isIdentical(Object a, Object b)
/*     */   {
/* 139 */     EJBLocalObject ejb = (EJBLocalObject)a;
/* 140 */     Boolean isIdentical = Boolean.FALSE;
/* 141 */     if (ejb != null)
/*     */     {
/* 143 */       isIdentical = new Boolean(ejb.toString().equals(b));
/*     */     }
/* 145 */     return isIdentical;
/*     */   }
/*     */ 
/*     */   String toStringImpl()
/*     */   {
/* 154 */     return this.jndiName + ":" + getId();
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method m, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 160 */     Object id = getId();
/* 161 */     Object retValue = null;
/*     */ 
/* 164 */     if (m.equals(TO_STRING))
/*     */     {
/* 166 */       retValue = toStringImpl();
/*     */     }
/* 168 */     else if (m.equals(EQUALS))
/*     */     {
/* 170 */       retValue = invoke(proxy, IS_IDENTICAL, args);
/*     */     }
/* 172 */     else if (m.equals(HASH_CODE))
/*     */     {
/* 174 */       retValue = new Integer(id.hashCode());
/*     */     }
/* 178 */     else if (m.equals(GET_PRIMARY_KEY))
/*     */     {
/* 180 */       retValue = id;
/*     */     } else {
/* 182 */       if (m.equals(GET_EJB_HOME))
/*     */       {
/* 184 */         InitialContext ctx = new InitialContext();
/* 185 */         return ctx.lookup(this.jndiName);
/*     */       }
/* 187 */       if (m.equals(IS_IDENTICAL))
/*     */       {
/* 189 */         retValue = isIdentical(args[0], toStringImpl());
/*     */       }
/*     */     }
/* 191 */     return retValue;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 200 */     in.defaultReadObject();
/* 201 */     this.factory = ((BaseLocalProxyFactory)BaseLocalProxyFactory.invokerMap.get(this.jndiName));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 207 */     out.defaultWriteObject();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  80 */       Class[] empty = new Class[0];
/*  81 */       Class type = EJBLocalObject.class;
/*     */ 
/*  83 */       GET_PRIMARY_KEY = type.getMethod("getPrimaryKey", empty);
/*  84 */       GET_EJB_HOME = type.getMethod("getEJBLocalHome", empty);
/*  85 */       IS_IDENTICAL = type.getMethod("isIdentical", new Class[] { type });
/*  86 */       REMOVE = type.getMethod("remove", empty);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  90 */       e.printStackTrace();
/*  91 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 102 */       Class[] empty = new Class[0];
/* 103 */       Class type = Object.class;
/*     */ 
/* 105 */       TO_STRING = type.getMethod("toString", empty);
/* 106 */       HASH_CODE = type.getMethod("hashCode", empty);
/* 107 */       EQUALS = type.getMethod("equals", new Class[] { type });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 111 */       e.printStackTrace();
/* 112 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.local.LocalProxy
 * JD-Core Version:    0.6.0
 */