/*    */ package org.jboss.ejb.plugins.local;
/*    */ 
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.ejb.NoSuchObjectLocalException;
/*    */ 
/*    */ class EntityProxy extends LocalProxy
/*    */   implements InvocationHandler
/*    */ {
/*    */   static final long serialVersionUID = 5196148608172665115L;
/*    */   private Object cacheKey;
/*    */   private boolean removed;
/*    */ 
/*    */   EntityProxy(String jndiName, Object id, BaseLocalProxyFactory factory)
/*    */   {
/* 41 */     super(jndiName, factory);
/* 42 */     this.cacheKey = id;
/*    */   }
/*    */ 
/*    */   protected Object getId()
/*    */   {
/* 47 */     return this.cacheKey;
/*    */   }
/*    */ 
/*    */   public final Object invoke(Object proxy, Method m, Object[] args)
/*    */     throws Throwable
/*    */   {
/* 53 */     if (this.removed)
/*    */     {
/* 55 */       throw new NoSuchObjectLocalException("The instance has been removed: " + toStringImpl());
/*    */     }
/*    */ 
/* 58 */     if (args == null) {
/* 59 */       args = EMPTY_ARGS;
/*    */     }
/* 61 */     Object retValue = super.invoke(proxy, m, args);
/* 62 */     if (retValue == null)
/*    */     {
/* 65 */       retValue = this.factory.invoke(this.cacheKey, m, args);
/*    */     }
/*    */ 
/* 68 */     if (m.equals(REMOVE))
/*    */     {
/* 70 */       this.removed = true;
/*    */     }
/*    */ 
/* 73 */     return retValue;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.local.EntityProxy
 * JD-Core Version:    0.6.0
 */