/*     */ package org.jboss.ejb.plugins.inflow;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javax.jms.MessageListener;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.InvokerProxyBindingMetaData;
/*     */ import org.jboss.metadata.MessageDrivenMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JBossJMSMessageEndpointFactory extends JBossMessageEndpointFactory
/*     */ {
/*  42 */   protected static String jmsra = "jms-ra.rar";
/*     */ 
/*     */   protected String resolveResourceAdapterName()
/*     */     throws DeploymentException
/*     */   {
/*  48 */     String result = super.resolveResourceAdapterName();
/*  49 */     if (result == null)
/*  50 */       result = jmsra;
/*  51 */     return result;
/*     */   }
/*     */ 
/*     */   protected void resolveMessageListener()
/*     */     throws DeploymentException
/*     */   {
/*  58 */     if (this.metaData.getMessagingType() == null)
/*  59 */       this.messagingTypeClass = MessageListener.class;
/*     */     else
/*  61 */       super.resolveMessageListener();
/*     */   }
/*     */ 
/*     */   protected void augmentActivationConfigProperties()
/*     */     throws DeploymentException
/*     */   {
/*  71 */     super.augmentActivationConfigProperties();
/*     */ 
/*  74 */     if (this.messagingTypeClass.equals(MessageListener.class))
/*     */     {
/*  76 */       checkActivationConfig("destination", this.metaData.getDestinationJndiName());
/*  77 */       checkActivationConfig("destinationType", this.metaData.getDestinationType());
/*  78 */       checkActivationConfig("messageSelector", this.metaData.getMessageSelector());
/*  79 */       if (3 == this.metaData.getAcknowledgeMode())
/*  80 */         checkActivationConfig("acknowledgeMode", "DUPS_OK_ACKNOWLEDGE");
/*     */       else
/*  82 */         checkActivationConfig("acknowledgeMode", "AUTO_ACKNOWLEDGE");
/*  83 */       if (0 == this.metaData.getSubscriptionDurability())
/*  84 */         checkActivationConfig("subscriptionDurability", "Durable");
/*     */       else
/*  86 */         checkActivationConfig("subscriptionDurability", "NonDurable");
/*  87 */       checkActivationConfig("clientID", this.metaData.getClientId());
/*  88 */       checkActivationConfig("subscriptionName", this.metaData.getSubscriptionId());
/*     */ 
/*  91 */       if (jmsra.equals(this.resourceAdapterName))
/*     */       {
/*  93 */         checkActivationConfig("user", this.metaData.getUser());
/*  94 */         checkActivationConfig("password", this.metaData.getPasswd());
/*  95 */         Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
/*  96 */         checkActivationConfig("maxMessages", MetaData.getOptionalChildContent(proxyConfig, "MaxMessages"));
/*  97 */         checkActivationConfig("minSession", MetaData.getOptionalChildContent(proxyConfig, "MinimumSize"));
/*  98 */         checkActivationConfig("maxSession", MetaData.getOptionalChildContent(proxyConfig, "MaximumSize"));
/*  99 */         checkActivationConfig("keepAlive", MetaData.getOptionalChildContent(proxyConfig, "KeepAliveMillis"));
/* 100 */         Element mdbConfig = MetaData.getOptionalChild(proxyConfig, "MDBConfig");
/* 101 */         if (mdbConfig != null)
/*     */         {
/*     */           try
/*     */           {
/* 105 */             if ("false".equalsIgnoreCase(MetaData.getElementContent(MetaData.getUniqueChild(mdbConfig, "DeliveryActive"))))
/*     */             {
/* 107 */               setDeliveryActive(false);
/*     */             }
/*     */           }
/*     */           catch (Exception ignore)
/*     */           {
/*     */           }
/*     */ 
/* 114 */           checkActivationConfig("reconnectInterval", MetaData.getOptionalChildContent(proxyConfig, "ReconnectIntervalSec"));
/* 115 */           checkActivationConfig("deliveryActive", MetaData.getOptionalChildContent(proxyConfig, "DeliveryActive"));
/* 116 */           checkActivationConfig("providerAdapterJNDI", MetaData.getOptionalChildContent(proxyConfig, "JMSProviderAdapterJNDI"));
/*     */ 
/* 118 */           Element dlqEl = MetaData.getOptionalChild(mdbConfig, "DLQConfig");
/* 119 */           if (dlqEl != null)
/*     */           {
/* 121 */             checkActivationConfig("useDLQ", "true");
/* 122 */             checkActivationConfig("DLQJNDIName", MetaData.getElementContent(MetaData.getUniqueChild(dlqEl, "DestinationQueue")));
/*     */             try
/*     */             {
/* 125 */               checkActivationConfig("DLQMaxResent", MetaData.getElementContent(MetaData.getUniqueChild(dlqEl, "MaxTimesRedelivered")));
/*     */             }
/*     */             catch (Exception ignored)
/*     */             {
/*     */             }
/*     */ 
/* 134 */             checkActivationConfig("DLQUser", MetaData.getElementContent(MetaData.getOptionalChild(dlqEl, "DLQUser")));
/* 135 */             checkActivationConfig("DLQPassword", MetaData.getElementContent(MetaData.getOptionalChild(dlqEl, "DLQPassword")));
/*     */           }
/*     */           else
/*     */           {
/* 140 */             checkActivationConfig("useDLQ", "false");
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void checkActivationConfig(String name, String value)
/*     */   {
/* 155 */     if ((value != null) && (!this.properties.containsKey(name)))
/*     */     {
/* 157 */       org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData md = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
/* 158 */       org.jboss.metadata.ActivationConfigPropertyMetaData metaData = new org.jboss.metadata.ActivationConfigPropertyMetaData(md);
/* 159 */       md.setName(name);
/* 160 */       md.setValue(value);
/* 161 */       this.properties.put(name, metaData);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.inflow.JBossJMSMessageEndpointFactory
 * JD-Core Version:    0.6.0
 */