/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.schema;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class RelationTable
/*     */   implements Table
/*     */ {
/*     */   private static final byte CREATED = 1;
/*     */   private static final byte DELETED = 2;
/*     */   private final Schema schema;
/*     */   private final int tableId;
/*     */   private final DataSource ds;
/*     */   private final String tableName;
/*     */   private final JDBCCMRFieldBridge2 leftField;
/*     */   private final JDBCCMRFieldBridge2 rightField;
/*     */   private final Logger log;
/*     */   private String insertSql;
/*     */   private String deleteSql;
/*     */ 
/*     */   public RelationTable(JDBCCMRFieldBridge2 leftField, JDBCCMRFieldBridge2 rightField, Schema schema, int tableId)
/*     */     throws DeploymentException
/*     */   {
/*  62 */     this.schema = schema;
/*  63 */     this.tableId = tableId;
/*  64 */     this.leftField = leftField;
/*  65 */     this.rightField = rightField;
/*     */ 
/*  67 */     JDBCRelationMetaData metadata = leftField.getMetaData().getRelationMetaData();
/*  68 */     this.ds = metadata.getDataSource();
/*  69 */     this.tableName = SQLUtil.fixTableName(metadata.getDefaultTableName(), this.ds);
/*     */ 
/*  71 */     this.log = Logger.getLogger(getClass().getName() + "." + this.tableName);
/*     */ 
/*  75 */     this.insertSql = ("insert into " + this.tableName + " (");
/*     */ 
/*  77 */     JDBCCMPFieldBridge2[] keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
/*  78 */     this.insertSql += keyFields[0].getColumnName();
/*  79 */     for (int i = 1; i < keyFields.length; i++)
/*     */     {
/*  81 */       this.insertSql = (this.insertSql + ", " + keyFields[i].getColumnName());
/*     */     }
/*     */ 
/*  84 */     keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
/*  85 */     this.insertSql = (this.insertSql + ", " + keyFields[0].getColumnName());
/*  86 */     for (int i = 1; i < keyFields.length; i++)
/*     */     {
/*  88 */       this.insertSql = (this.insertSql + ", " + keyFields[i].getColumnName());
/*     */     }
/*     */ 
/*  91 */     this.insertSql += ") values (?";
/*  92 */     for (int i = 1; i < this.leftField.getTableKeyFields().length + this.rightField.getTableKeyFields().length; i++)
/*     */     {
/*  94 */       this.insertSql += ", ?";
/*     */     }
/*     */ 
/*  97 */     this.insertSql += ")";
/*     */ 
/*  99 */     this.log.debug("insert sql: " + this.insertSql);
/*     */ 
/* 101 */     this.deleteSql = ("delete from " + this.tableName + " where ");
/* 102 */     keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
/* 103 */     this.deleteSql = (this.deleteSql + keyFields[0].getColumnName() + "=?");
/* 104 */     for (int i = 1; i < keyFields.length; i++)
/*     */     {
/* 106 */       this.deleteSql = (this.deleteSql + " and " + keyFields[i].getColumnName() + "=?");
/*     */     }
/*     */ 
/* 109 */     keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
/* 110 */     this.deleteSql = (this.deleteSql + " and " + keyFields[0].getColumnName() + "=?");
/* 111 */     for (int i = 1; i < keyFields.length; i++)
/*     */     {
/* 113 */       this.deleteSql = (this.deleteSql + " and " + keyFields[i].getColumnName() + "=?");
/*     */     }
/*     */ 
/* 116 */     this.log.debug("delete sql: " + this.deleteSql);
/*     */   }
/*     */ 
/*     */   public void addRelation(JDBCCMRFieldBridge2 field1, Object key1, JDBCCMRFieldBridge2 field2, Object key2)
/*     */   {
/* 123 */     View view = getView();
/* 124 */     if (field1 == this.leftField)
/*     */     {
/* 126 */       view.addKeys(key1, key2);
/*     */     }
/*     */     else
/*     */     {
/* 130 */       view.addKeys(key2, key1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeRelation(JDBCCMRFieldBridge2 field1, Object key1, JDBCCMRFieldBridge2 field2, Object key2)
/*     */   {
/* 136 */     View view = getView();
/* 137 */     if (field1 == this.leftField)
/*     */     {
/* 139 */       view.removeKeys(key1, key2);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       view.removeKeys(key2, key1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTableId()
/*     */   {
/* 151 */     return this.tableId;
/*     */   }
/*     */ 
/*     */   public String getTableName()
/*     */   {
/* 156 */     return this.tableName;
/*     */   }
/*     */ 
/*     */   public Table.View createView(Transaction tx)
/*     */   {
/* 161 */     return new View(null);
/*     */   }
/*     */ 
/*     */   private void delete(View view)
/*     */     throws SQLException
/*     */   {
/* 168 */     if (view.deleted == null)
/*     */     {
/* 170 */       if (this.log.isTraceEnabled())
/*     */       {
/* 172 */         this.log.trace("no rows to delete");
/*     */       }
/* 174 */       return;
/*     */     }
/*     */ 
/* 177 */     Connection con = null;
/* 178 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 181 */       if (this.log.isDebugEnabled())
/*     */       {
/* 183 */         this.log.debug("executing : " + this.deleteSql);
/*     */       }
/*     */ 
/* 186 */       con = this.ds.getConnection();
/* 187 */       ps = con.prepareStatement(this.deleteSql);
/*     */ 
/* 189 */       int batchCount = 0;
/* 190 */       while (view.deleted != null)
/*     */       {
/* 192 */         RelationKeys keys = view.deleted;
/*     */ 
/* 194 */         int paramInd = 1;
/* 195 */         JDBCCMPFieldBridge2[] keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
/* 196 */         for (int pkInd = 0; pkInd < keyFields.length; pkInd++)
/*     */         {
/* 198 */           JDBCCMPFieldBridge2 pkField = keyFields[pkInd];
/* 199 */           Object fieldValue = pkField.getPrimaryKeyValue(keys.leftKey);
/* 200 */           paramInd = pkField.setArgumentParameters(ps, paramInd, fieldValue);
/*     */         }
/*     */ 
/* 203 */         keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
/* 204 */         for (int pkInd = 0; pkInd < keyFields.length; pkInd++)
/*     */         {
/* 206 */           JDBCCMPFieldBridge2 pkField = keyFields[pkInd];
/* 207 */           Object fieldValue = pkField.getPrimaryKeyValue(keys.rightKey);
/* 208 */           paramInd = pkField.setArgumentParameters(ps, paramInd, fieldValue);
/*     */         }
/*     */ 
/* 211 */         ps.addBatch();
/* 212 */         batchCount++;
/*     */ 
/* 214 */         keys.dereference();
/*     */       }
/*     */ 
/* 217 */       ps.executeBatch();
/*     */ 
/* 219 */       if (view.deleted != null)
/*     */       {
/* 221 */         throw new IllegalStateException("There are still rows to delete!");
/*     */       }
/*     */ 
/* 224 */       if (this.log.isTraceEnabled())
/*     */       {
/* 226 */         this.log.trace("deleted rows: " + batchCount);
/*     */       }
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 231 */       this.log.error("Failed to delete view: " + e.getMessage(), e);
/* 232 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 236 */       JDBCUtil.safeClose(ps);
/* 237 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void insert(View view) throws SQLException
/*     */   {
/* 243 */     if (view.created == null)
/*     */     {
/* 245 */       if (this.log.isTraceEnabled())
/*     */       {
/* 247 */         this.log.trace("no rows to insert");
/*     */       }
/* 249 */       return;
/*     */     }
/*     */ 
/* 252 */     Connection con = null;
/* 253 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 256 */       if (this.log.isDebugEnabled())
/*     */       {
/* 258 */         this.log.debug("executing : " + this.insertSql);
/*     */       }
/*     */ 
/* 261 */       con = this.ds.getConnection();
/* 262 */       ps = con.prepareStatement(this.insertSql);
/*     */ 
/* 264 */       int batchCount = 0;
/* 265 */       while (view.created != null)
/*     */       {
/* 267 */         RelationKeys keys = view.created;
/*     */ 
/* 269 */         JDBCCMPFieldBridge2[] keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
/* 270 */         int paramInd = 1;
/* 271 */         for (int fInd = 0; fInd < keyFields.length; fInd++)
/*     */         {
/* 273 */           JDBCCMPFieldBridge2 field = keyFields[fInd];
/* 274 */           Object fieldValue = field.getPrimaryKeyValue(keys.leftKey);
/* 275 */           paramInd = field.setArgumentParameters(ps, paramInd, fieldValue);
/*     */         }
/*     */ 
/* 278 */         keyFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
/* 279 */         for (int fInd = 0; fInd < keyFields.length; fInd++)
/*     */         {
/* 281 */           JDBCCMPFieldBridge2 field = keyFields[fInd];
/* 282 */           Object fieldValue = field.getPrimaryKeyValue(keys.rightKey);
/* 283 */           paramInd = field.setArgumentParameters(ps, paramInd, fieldValue);
/*     */         }
/*     */ 
/* 286 */         ps.addBatch();
/* 287 */         batchCount++;
/*     */ 
/* 289 */         keys.dereference();
/*     */       }
/*     */ 
/* 292 */       ps.executeBatch();
/*     */ 
/* 294 */       if (this.log.isTraceEnabled())
/*     */       {
/* 296 */         this.log.trace("inserted rows: " + batchCount);
/*     */       }
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 301 */       this.log.error("Failed to insert new rows: " + e.getMessage(), e);
/* 302 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 306 */       JDBCUtil.safeClose(ps);
/* 307 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   private View getView()
/*     */   {
/* 313 */     return (View)this.schema.getView(this);
/*     */   }
/*     */ 
/*     */   private class RelationKeys
/*     */   {
/*     */     private final RelationTable.View view;
/*     */     private final Object leftKey;
/*     */     private final Object rightKey;
/*     */     private byte state;
/*     */     private RelationKeys next;
/*     */     private RelationKeys prev;
/*     */ 
/*     */     public RelationKeys(RelationTable.View view, Object leftKey, Object rightKey)
/*     */     {
/* 418 */       this.view = view;
/* 419 */       this.leftKey = leftKey;
/* 420 */       this.rightKey = rightKey;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object leftKey, Object rightKey)
/*     */     {
/* 427 */       return (this.leftKey.equals(leftKey)) && (this.rightKey.equals(rightKey));
/*     */     }
/*     */ 
/*     */     public void dereference()
/*     */     {
/* 432 */       if ((this.state == 1) && (this == RelationTable.View.access$400(this.view)))
/*     */       {
/* 434 */         RelationTable.View.access$402(this.view, this.next);
/*     */       }
/* 436 */       else if ((this.state == 2) && (this == RelationTable.View.access$100(this.view)))
/*     */       {
/* 438 */         RelationTable.View.access$102(this.view, this.next);
/*     */       }
/*     */ 
/* 441 */       if (this.next != null)
/*     */       {
/* 443 */         this.next.prev = this.prev;
/*     */       }
/*     */ 
/* 446 */       if (this.prev != null)
/*     */       {
/* 448 */         this.prev.next = this.next;
/*     */       }
/*     */ 
/* 451 */       this.next = null;
/* 452 */       this.prev = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class View
/*     */     implements Table.View
/*     */   {
/*     */     private RelationTable.RelationKeys created;
/*     */     private RelationTable.RelationKeys deleted;
/*     */ 
/*     */     private View()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void addKeys(Object leftKey, Object rightKey)
/*     */     {
/* 328 */       RelationTable.RelationKeys keys = this.deleted;
/* 329 */       while (keys != null)
/*     */       {
/* 331 */         if (keys.equals(leftKey, rightKey))
/*     */         {
/* 333 */           keys.dereference();
/* 334 */           return;
/*     */         }
/* 336 */         keys = keys.next;
/*     */       }
/*     */ 
/* 340 */       keys = new RelationTable.RelationKeys(RelationTable.this, this, leftKey, rightKey);
/*     */ 
/* 342 */       if (this.created != null)
/*     */       {
/* 344 */         RelationTable.RelationKeys.access$502(keys, this.created);
/* 345 */         RelationTable.RelationKeys.access$602(this.created, keys);
/*     */       }
/* 347 */       this.created = keys;
/* 348 */       RelationTable.RelationKeys.access$702(keys, 1);
/*     */     }
/*     */ 
/*     */     public void removeKeys(Object leftKey, Object rightKey)
/*     */     {
/* 354 */       RelationTable.RelationKeys keys = this.created;
/* 355 */       while (keys != null)
/*     */       {
/* 357 */         if (keys.equals(leftKey, rightKey))
/*     */         {
/* 359 */           keys.dereference();
/* 360 */           return;
/*     */         }
/* 362 */         keys = keys.next;
/*     */       }
/*     */ 
/* 366 */       keys = new RelationTable.RelationKeys(RelationTable.this, this, leftKey, rightKey);
/*     */ 
/* 368 */       if (this.deleted != null)
/*     */       {
/* 370 */         RelationTable.RelationKeys.access$502(keys, this.deleted);
/* 371 */         RelationTable.RelationKeys.access$602(this.deleted, keys);
/*     */       }
/* 373 */       this.deleted = keys;
/* 374 */       RelationTable.RelationKeys.access$702(keys, 2);
/*     */     }
/*     */ 
/*     */     public void flushDeleted(Schema.Views views)
/*     */       throws SQLException
/*     */     {
/* 381 */       RelationTable.this.delete(this);
/*     */     }
/*     */ 
/*     */     public void flushCreated(Schema.Views views) throws SQLException
/*     */     {
/* 386 */       RelationTable.this.insert(this);
/*     */     }
/*     */ 
/*     */     public void flushUpdated()
/*     */       throws SQLException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void committed()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void rolledback()
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.schema.RelationTable
 * JD-Core Version:    0.6.0
 */