/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.schema;
/*     */ 
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class PartitionedTableCache extends ServiceMBeanSupport
/*     */   implements Cache, PartitionedTableCacheMBean
/*     */ {
/*  37 */   private Cache.Listener listener = Cache.Listener.NOOP;
/*     */   private final int minCapacity;
/*     */   private final int minPartitionCapacity;
/*     */   private int maxCapacity;
/*     */   private int maxPartitionCapacity;
/*     */   private final TableCache[] partitions;
/*     */   private Overager overager;
/*     */ 
/*     */   public PartitionedTableCache(int minCapacity, int maxCapacity, int partitionsTotal)
/*     */   {
/*  50 */     this.minCapacity = minCapacity;
/*  51 */     this.maxCapacity = maxCapacity;
/*     */ 
/*  53 */     this.minPartitionCapacity = (minCapacity / partitionsTotal + 1);
/*  54 */     this.maxPartitionCapacity = (maxCapacity / partitionsTotal + 1);
/*  55 */     this.partitions = new TableCache[partitionsTotal];
/*  56 */     for (int i = 0; i < this.partitions.length; i++)
/*     */     {
/*  58 */       this.partitions[i] = new TableCache(i, this.minPartitionCapacity, this.maxPartitionCapacity);
/*     */     }
/*     */ 
/*  61 */     if (this.log.isTraceEnabled())
/*     */     {
/*  63 */       this.log.trace("min-capacity=" + minCapacity + ", max-capacity=" + maxCapacity + ", partitions=" + partitionsTotal);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stopService()
/*     */   {
/*  69 */     if (this.overager != null)
/*     */     {
/*  71 */       this.overager.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void initOverager(long period, long maxAge, String threadName)
/*     */   {
/*  77 */     long periodMs = period * 1000L;
/*  78 */     long maxAgeMs = maxAge * 1000L;
/*  79 */     this.overager = new Overager(maxAgeMs, periodMs);
/*  80 */     new Thread(this.overager, threadName).start();
/*     */   }
/*     */ 
/*     */   public void registerListener(Cache.Listener listener)
/*     */   {
/*  88 */     if (this.log.isTraceEnabled())
/*     */     {
/*  90 */       this.log.trace("registered listener for " + getServiceName());
/*     */     }
/*     */ 
/*  93 */     this.listener = listener;
/*  94 */     for (int i = 0; i < this.partitions.length; i++)
/*     */     {
/*  96 */       this.partitions[i].registerListener(listener);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 105 */     int size = 0;
/* 106 */     for (int i = 0; i < this.partitions.length; i++)
/*     */     {
/* 108 */       size += this.partitions[i].size();
/*     */     }
/* 110 */     return size;
/*     */   }
/*     */ 
/*     */   public int getMaxCapacity()
/*     */   {
/* 118 */     return this.maxCapacity;
/*     */   }
/*     */ 
/*     */   public void setMaxCapacity(int maxCapacity)
/*     */   {
/* 126 */     this.maxCapacity = maxCapacity;
/* 127 */     this.maxPartitionCapacity = (maxCapacity / this.partitions.length + 1);
/* 128 */     for (int i = 0; i < this.partitions.length; i++)
/*     */     {
/* 130 */       this.partitions[i].setMaxCapacity(this.maxPartitionCapacity);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMinCapacity()
/*     */   {
/* 139 */     return this.minCapacity;
/*     */   }
/*     */ 
/*     */   public int getPartitionsTotal()
/*     */   {
/* 147 */     return this.partitions.length;
/*     */   }
/*     */ 
/*     */   public int getMinPartitionCapacity()
/*     */   {
/* 155 */     return this.minPartitionCapacity;
/*     */   }
/*     */ 
/*     */   public int getMaxPartitionCapacity()
/*     */   {
/* 163 */     return this.maxPartitionCapacity;
/*     */   }
/*     */ 
/*     */   public void lock()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void lock(Object key)
/*     */   {
/* 172 */     int partitionIndex = getPartitionIndex(key);
/* 173 */     this.partitions[partitionIndex].lock(key);
/*     */   }
/*     */ 
/*     */   public void unlock()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void unlock(Object key)
/*     */   {
/* 182 */     int partitionIndex = getPartitionIndex(key);
/* 183 */     this.partitions[partitionIndex].unlock(key);
/*     */   }
/*     */ 
/*     */   public Object[] getFields(Object pk)
/*     */   {
/* 188 */     int i = getPartitionIndex(pk);
/* 189 */     return this.partitions[i].getFields(pk);
/*     */   }
/*     */ 
/*     */   public Object[] getRelations(Object pk)
/*     */   {
/* 194 */     int i = getPartitionIndex(pk);
/* 195 */     return this.partitions[i].getRelations(pk);
/*     */   }
/*     */ 
/*     */   public void put(Transaction tx, Object pk, Object[] fields, Object[] relations)
/*     */   {
/* 200 */     int i = getPartitionIndex(pk);
/* 201 */     this.partitions[i].put(tx, pk, fields, relations);
/*     */   }
/*     */ 
/*     */   public void remove(Transaction tx, Object pk)
/*     */   {
/* 206 */     int i = getPartitionIndex(pk);
/* 207 */     this.partitions[i].remove(tx, pk);
/*     */   }
/*     */ 
/*     */   public boolean contains(Transaction tx, Object pk)
/*     */   {
/* 212 */     int i = getPartitionIndex(pk);
/* 213 */     return this.partitions[i].contains(tx, pk);
/*     */   }
/*     */ 
/*     */   public void lockForUpdate(Transaction tx, Object pk) throws Exception
/*     */   {
/* 218 */     int i = getPartitionIndex(pk);
/* 219 */     this.partitions[i].lockForUpdate(tx, pk);
/*     */   }
/*     */ 
/*     */   public void releaseLock(Transaction tx, Object pk) throws Exception
/*     */   {
/* 224 */     int i = getPartitionIndex(pk);
/* 225 */     this.partitions[i].releaseLock(tx, pk);
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 230 */     for (int i = 0; i < this.partitions.length; i++)
/*     */     {
/* 232 */       TableCache partition = this.partitions[i];
/* 233 */       partition.lock();
/*     */       try
/*     */       {
/* 236 */         partition.flush();
/*     */       }
/*     */       finally
/*     */       {
/* 240 */         partition.unlock();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private int getPartitionIndex(Object key)
/*     */   {
/* 249 */     int hash = key.hashCode();
/*     */ 
/* 251 */     if (hash < 0)
/*     */     {
/* 253 */       hash = hash == -2147483648 ? 2147483647 : -hash;
/*     */     }
/* 255 */     return hash % this.partitions.length;
/*     */   }
/*     */ 
/*     */   private class Overager
/*     */     implements Runnable
/*     */   {
/*     */     private final long maxAgeMs;
/*     */     private final long periodMs;
/* 264 */     private boolean run = true;
/*     */ 
/*     */     public Overager(long maxAgeMs, long periodMs)
/*     */     {
/* 268 */       this.maxAgeMs = maxAgeMs;
/* 269 */       this.periodMs = periodMs;
/*     */     }
/*     */ 
/*     */     public void stop()
/*     */     {
/* 274 */       this.run = false;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 279 */       while (this.run)
/*     */       {
/* 281 */         long lastUpdated = System.currentTimeMillis() - this.maxAgeMs;
/* 282 */         for (int i = 0; i < PartitionedTableCache.this.partitions.length; i++)
/*     */         {
/* 284 */           PartitionedTableCache.this.partitions[i].ageOut(lastUpdated);
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 289 */           Thread.sleep(this.periodMs);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.schema.PartitionedTableCache
 * JD-Core Version:    0.6.0
 */