/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.schema;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.cache.invalidation.Invalidatable;
/*     */ import org.jboss.cache.invalidation.InvalidationGroup;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class CacheInvalidator
/*     */   implements Invalidatable
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(CacheInvalidator.class);
/*     */   private final Cache cache;
/*     */   private final TransactionManager tm;
/*     */   private final InvalidationGroup group;
/*     */ 
/*     */   public CacheInvalidator(Cache cache, TransactionManager tm, InvalidationGroup group)
/*     */   {
/*  48 */     this.cache = cache;
/*  49 */     this.tm = tm;
/*  50 */     this.group = group;
/*  51 */     group.register(this);
/*  52 */     log.debug("registered to group " + group.getGroupName());
/*     */   }
/*     */ 
/*     */   public void unregister()
/*     */   {
/*  57 */     this.group.unregister(this);
/*  58 */     log.debug("unregistered from group " + this.group.getGroupName());
/*     */   }
/*     */ 
/*     */   public void isInvalid(Serializable key)
/*     */   {
/*  63 */     Transaction tx = null;
/*     */     try
/*     */     {
/*  66 */       tx = this.tm.getTransaction();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/*  70 */       log.error("Failed to obtain the current transaction", e);
/*  71 */       throw new IllegalStateException("Failed to obtain the current transaction: " + e.getMessage());
/*     */     }
/*     */ 
/*  74 */     if (log.isTraceEnabled())
/*     */     {
/*  76 */       log.trace("invalidating key=" + key);
/*     */     }
/*     */ 
/*  79 */     this.cache.lock(key);
/*     */     try
/*     */     {
/*  82 */       this.cache.remove(tx, key);
/*     */     }
/*     */     catch (Cache.RemoveException e)
/*     */     {
/*  86 */       if (log.isTraceEnabled())
/*     */       {
/*  88 */         log.trace(e.getMessage());
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*  93 */       this.cache.unlock(key);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void areInvalid(Serializable[] keys)
/*     */   {
/*  99 */     Transaction tx = null;
/*     */     try
/*     */     {
/* 102 */       tx = this.tm.getTransaction();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 106 */       log.error("Failed to obtain the current transaction", e);
/* 107 */       throw new IllegalStateException("Failed to obtain the current transaction: " + e.getMessage());
/*     */     }
/*     */ 
/* 110 */     boolean trace = log.isTraceEnabled();
/* 111 */     for (int i = 0; i < keys.length; i++)
/*     */     {
/* 113 */       if (trace)
/*     */       {
/* 115 */         log.trace("invalidating key[" + i + "]=" + keys[i]);
/*     */       }
/*     */ 
/* 118 */       this.cache.lock(keys[i]);
/*     */       try
/*     */       {
/* 121 */         this.cache.remove(tx, keys[i]);
/*     */       }
/*     */       catch (Cache.RemoveException e)
/*     */       {
/* 125 */         if (trace)
/*     */         {
/* 127 */           log.trace(e.getMessage());
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 132 */         this.cache.unlock(keys[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invalidateAll()
/*     */   {
/* 139 */     this.cache.lock();
/*     */     try
/*     */     {
/* 142 */       this.cache.flush();
/*     */     }
/*     */     finally
/*     */     {
/* 146 */       this.cache.unlock();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.schema.CacheInvalidator
 * JD-Core Version:    0.6.0
 */