/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.keygen;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.DuplicateKeyException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.CreateCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractCreateCommand
/*     */   implements CreateCommand
/*     */ {
/*     */   protected JDBCEntityBridge2 entityBridge;
/*     */   protected Logger log;
/*     */   protected JDBCCMPFieldBridge2 pkField;
/*     */   protected String pkSql;
/*     */ 
/*     */   public void init(JDBCStoreManager2 manager)
/*     */     throws DeploymentException
/*     */   {
/*  59 */     this.entityBridge = ((JDBCEntityBridge2)manager.getEntityBridge());
/*  60 */     this.log = Logger.getLogger(getClass().getName() + "." + this.entityBridge.getEntityName());
/*     */ 
/*  62 */     JDBCFieldBridge[] pkFields = this.entityBridge.getPrimaryKeyFields();
/*  63 */     if (pkFields.length > 1)
/*     */     {
/*  65 */       throw new DeploymentException("This entity-command cannot be used with composite primary keys!");
/*     */     }
/*     */ 
/*  68 */     this.pkField = ((JDBCCMPFieldBridge2)pkFields[0]);
/*  69 */     this.pkSql = "";
/*     */   }
/*     */ 
/*     */   public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws CreateException
/*     */   {
/*  75 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*     */     Object pk;
/*  76 */     if (ctx.getId() == null) { Connection con = null;
/*  79 */       PreparedStatement ps = null;
/*  80 */       ResultSet rs = null;
/*     */       Object pk;
/*     */       try { if (this.log.isDebugEnabled())
/*     */         {
/*  85 */           this.log.debug("executing sql: " + this.pkSql);
/*     */         }
/*     */ 
/*  88 */         con = this.entityBridge.getDataSource().getConnection();
/*  89 */         ps = con.prepareStatement(this.pkSql);
/*  90 */         rs = ps.executeQuery();
/*     */ 
/*  92 */         if (!rs.next())
/*     */         {
/*  94 */           throw new CreateException("pk-sql " + this.pkSql + " returned no results!");
/*     */         }
/*     */ 
/*  97 */         pk = this.pkField.loadArgumentResults(rs, 1);
/*  98 */         pctx.setFieldValue(this.pkField.getRowIndex(), pk);
/*  99 */         pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 103 */         this.log.error("Failed to execute pk sql. error code: " + e.getErrorCode() + ", sql state: " + e.getSQLState(), e);
/* 104 */         throw new CreateException("Failed to execute pk sql: " + e.getMessage() + ", error code: " + e.getErrorCode() + ", sql state: " + e.getSQLState());
/*     */       }
/*     */       finally
/*     */       {
/* 109 */         JDBCUtil.safeClose(rs);
/* 110 */         JDBCUtil.safeClose(ps);
/* 111 */         JDBCUtil.safeClose(con);
/*     */       }
/*     */ 
/* 114 */       if (pk == null)
/*     */       {
/* 116 */         this.log.error("Primary key for created instance is null.");
/* 117 */         throw new CreateException("Primary key for created instance is null.");
/*     */       }
/*     */ 
/* 120 */       pctx.setPk(pk);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 127 */         pctx.flush();
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 131 */         if ("23000".equals(e.getSQLState()))
/*     */         {
/* 133 */           throw new DuplicateKeyException("Unique key violation or invalid foreign key value: pk=" + ctx.getId());
/*     */         }
/*     */ 
/* 137 */         throw new CreateException("Failed to create instance: pk=" + ctx.getId() + ", state=" + e.getSQLState() + ", msg=" + e.getMessage());
/*     */       }
/*     */ 
/* 144 */       pk = ctx.getId();
/*     */     }
/* 146 */     return pk;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.keygen.AbstractCreateCommand
 * JD-Core Version:    0.6.0
 */