/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.bridge;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.proxy.compiler.InvocationHandler;
/*     */ import org.jboss.proxy.compiler.Proxies.ProxyTarget;
/*     */ 
/*     */ public class JDBCEntityBridge2
/*     */   implements JDBCAbstractEntityBridge
/*     */ {
/*     */   private final JDBCStoreManager2 manager;
/*     */   private final JDBCEntityMetaData metadata;
/*     */   private final EntityTable table;
/*     */   private final String tableName;
/*     */   private final String qualifiedTableName;
/*     */   private final Logger log;
/*     */   private JDBCCMPFieldBridge2[] pkFields;
/*     */   private JDBCCMPFieldBridge2[] cmpFields;
/*     */   private JDBCCMPFieldBridge2[] tableFields;
/*     */   private JDBCCMRFieldBridge2[] cmrFields;
/*     */   private JDBCCMPFieldBridge2 versionField;
/*     */   private int cmrCount;
/*     */ 
/*     */   public JDBCEntityBridge2(JDBCStoreManager2 manager, JDBCEntityMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/*  77 */     this.manager = manager;
/*  78 */     this.metadata = metadata;
/*  79 */     this.log = Logger.getLogger(getClass().getName() + "." + metadata.getName());
/*     */ 
/*  81 */     this.table = manager.getSchema().createEntityTable(metadata, this);
/*  82 */     this.tableName = SQLUtil.getTableNameWithoutSchema(metadata.getDefaultTableName());
/*  83 */     this.qualifiedTableName = SQLUtil.fixTableName(metadata.getDefaultTableName(), this.table.getDataSource());
/*     */   }
/*     */ 
/*     */   public void init()
/*     */     throws DeploymentException
/*     */   {
/*  90 */     loadCMPFields(this.metadata);
/*  91 */     loadCMRFields(this.metadata);
/*     */ 
/*  93 */     JDBCOptimisticLockingMetaData olMD = this.metadata.getOptimisticLocking();
/*  94 */     if (olMD != null)
/*     */     {
/*  96 */       if (olMD.getLockingStrategy() != JDBCOptimisticLockingMetaData.VERSION_COLUMN_STRATEGY)
/*     */       {
/*  98 */         throw new DeploymentException("Only version-column optimistic locking strategy is supported at the moment.");
/*     */       }
/*     */ 
/* 102 */       JDBCCMPFieldMetaData versionMD = olMD.getLockingField();
/* 103 */       this.versionField = ((JDBCCMPFieldBridge2)getFieldByName(versionMD.getFieldName()));
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldBridge2 getVersionField()
/*     */   {
/* 109 */     return this.versionField;
/*     */   }
/*     */ 
/*     */   public void resolveRelationships() throws DeploymentException
/*     */   {
/* 114 */     for (int i = 0; i < this.cmrFields.length; i++)
/*     */     {
/* 116 */       this.cmrFields[i].resolveRelationship();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start() throws DeploymentException
/*     */   {
/* 122 */     if (this.versionField != null)
/*     */     {
/* 124 */       this.versionField.initVersion();
/*     */     }
/*     */ 
/* 127 */     this.table.start();
/*     */ 
/* 129 */     if (this.cmrFields != null)
/*     */     {
/* 131 */       for (int i = 0; i < this.cmrFields.length; i++)
/*     */       {
/* 133 */         this.cmrFields[i].initLoader();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 140 */     this.table.stop();
/*     */   }
/*     */ 
/*     */   public JDBCEntityMetaData getMetaData()
/*     */   {
/* 145 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public EntityTable getTable()
/*     */   {
/* 150 */     return this.table;
/*     */   }
/*     */ 
/*     */   public JDBCFieldBridge[] getPrimaryKeyFields()
/*     */   {
/* 155 */     return this.pkFields;
/*     */   }
/*     */ 
/*     */   public JDBCFieldBridge[] getTableFields()
/*     */   {
/* 160 */     return this.tableFields;
/*     */   }
/*     */ 
/*     */   public JDBCAbstractCMRFieldBridge[] getCMRFields()
/*     */   {
/* 165 */     return this.cmrFields;
/*     */   }
/*     */ 
/*     */   public JDBCEntityPersistenceStore getManager()
/*     */   {
/* 170 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public EntityContainer getContainer()
/*     */   {
/* 175 */     return this.manager.getContainer();
/*     */   }
/*     */ 
/*     */   public Object extractPrimaryKeyFromInstance(EntityEnterpriseContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 182 */       Object pk = null;
/* 183 */       for (int i = 0; i < this.pkFields.length; i++)
/*     */       {
/* 185 */         JDBCCMPFieldBridge2 pkField = this.pkFields[i];
/* 186 */         Object fieldValue = pkField.getValue(ctx);
/* 187 */         pk = pkField.setPrimaryKeyValue(pk, fieldValue);
/*     */       }
/* 189 */       return pk;
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 193 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 197 */     throw new EJBException("Internal error extracting primary key from instance", e);
/*     */   }
/*     */ 
/*     */   public static void destroyPersistenceContext(EntityEnterpriseContext ctx)
/*     */   {
/* 205 */     Object instance = ctx.getInstance();
/* 206 */     if ((instance instanceof Proxies.ProxyTarget))
/*     */     {
/* 208 */       InvocationHandler handler = ((Proxies.ProxyTarget)instance).getInvocationHandler();
/* 209 */       if ((handler instanceof EntityBridgeInvocationHandler))
/*     */       {
/* 211 */         ((EntityBridgeInvocationHandler)handler).setContext(null);
/*     */       }
/*     */     }
/* 214 */     ctx.setPersistenceContext(null);
/*     */   }
/*     */ 
/*     */   public void initPersistenceContext(EntityEnterpriseContext ctx)
/*     */   {
/* 221 */     Object instance = ctx.getInstance();
/* 222 */     if ((instance instanceof Proxies.ProxyTarget))
/*     */     {
/* 224 */       InvocationHandler handler = ((Proxies.ProxyTarget)instance).getInvocationHandler();
/* 225 */       if ((handler instanceof EntityBridgeInvocationHandler))
/*     */       {
/* 227 */         ((EntityBridgeInvocationHandler)handler).setContext(ctx);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void initInstance(EntityEnterpriseContext ctx)
/*     */   {
/* 234 */     ctx.setPersistenceContext(new PersistentContext(this, this.table.getRow(ctx.getId())));
/* 235 */     for (int i = 0; i < this.tableFields.length; i++)
/*     */     {
/* 237 */       this.tableFields[i].initInstance(ctx);
/*     */     }
/*     */ 
/* 240 */     for (int i = 0; i < this.cmrFields.length; i++)
/*     */     {
/* 242 */       this.cmrFields[i].initInstance(ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List getFields()
/*     */   {
/* 251 */     List fields = new ArrayList();
/* 252 */     for (int i = 0; i < this.pkFields.length; i++)
/*     */     {
/* 254 */       fields.add(this.pkFields[i]);
/*     */     }
/*     */ 
/* 257 */     for (int i = 0; i < this.cmpFields.length; i++)
/*     */     {
/* 259 */       fields.add(this.cmpFields[i]);
/*     */     }
/*     */ 
/* 262 */     for (int i = 0; i < this.cmrFields.length; i++)
/*     */     {
/* 264 */       fields.add(this.cmrFields[i]);
/*     */     }
/*     */ 
/* 267 */     return fields;
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext instance)
/*     */   {
/* 272 */     PersistentContext pctx = (PersistentContext)instance.getPersistenceContext();
/* 273 */     return pctx.isDirty();
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext instance)
/*     */   {
/* 278 */     PersistentContext pctx = (PersistentContext)instance.getPersistenceContext();
/* 279 */     boolean modified = pctx.isDirty();
/*     */ 
/* 281 */     if ((!modified) && (this.cmrFields != null))
/*     */     {
/* 283 */       for (int i = 0; i < this.cmrFields.length; i++)
/*     */       {
/* 285 */         JDBCCMRFieldBridge2.FieldState cmrState = pctx.getCMRState(i);
/* 286 */         if ((cmrState == null) || (!cmrState.isModified()))
/*     */           continue;
/* 288 */         modified = true;
/* 289 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 293 */     return modified;
/*     */   }
/*     */ 
/*     */   public Class getPrimaryKeyClass()
/*     */   {
/* 298 */     return this.metadata.getPrimaryKeyClass();
/*     */   }
/*     */ 
/*     */   public Class getHomeClass()
/*     */   {
/* 303 */     return this.metadata.getHomeClass();
/*     */   }
/*     */ 
/*     */   public Class getLocalHomeClass()
/*     */   {
/* 308 */     return this.metadata.getLocalHomeClass();
/*     */   }
/*     */ 
/*     */   public String getTableName()
/*     */   {
/* 313 */     return this.tableName;
/*     */   }
/*     */ 
/*     */   public String getQualifiedTableName()
/*     */   {
/* 318 */     return this.qualifiedTableName;
/*     */   }
/*     */ 
/*     */   public DataSource getDataSource()
/*     */   {
/* 323 */     return this.table.getDataSource();
/*     */   }
/*     */ 
/*     */   public boolean[] getLoadGroupMask(String eagerLoadGroupName)
/*     */   {
/* 329 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public int getNextCMRIndex()
/*     */   {
/* 334 */     return this.cmrCount++;
/*     */   }
/*     */ 
/*     */   public void remove(EntityEnterpriseContext ctx) throws RemoveException
/*     */   {
/* 339 */     if (this.cmrFields != null)
/*     */     {
/* 341 */       for (int i = 0; i < this.cmrFields.length; i++)
/*     */       {
/* 343 */         this.cmrFields[i].remove(ctx);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getEntityName()
/*     */   {
/* 352 */     return this.metadata.getName();
/*     */   }
/*     */ 
/*     */   public String getAbstractSchemaName()
/*     */   {
/* 357 */     return this.metadata.getAbstractSchemaName();
/*     */   }
/*     */ 
/*     */   public FieldBridge getFieldByName(String fieldName)
/*     */   {
/* 363 */     for (int i = 0; i < this.pkFields.length; i++)
/*     */     {
/* 365 */       FieldBridge field = this.pkFields[i];
/* 366 */       if (field.getFieldName().equals(fieldName))
/*     */       {
/* 368 */         return field;
/*     */       }
/*     */     }
/*     */ 
/* 372 */     for (int i = 0; i < this.cmpFields.length; i++)
/*     */     {
/* 374 */       FieldBridge field = this.cmpFields[i];
/* 375 */       if (field.getFieldName().equals(fieldName))
/*     */       {
/* 377 */         return field;
/*     */       }
/*     */     }
/*     */ 
/* 381 */     for (int i = 0; i < this.cmrFields.length; i++)
/*     */     {
/* 383 */       FieldBridge field = this.cmrFields[i];
/* 384 */       if (field.getFieldName().equals(fieldName))
/*     */       {
/* 386 */         return field;
/*     */       }
/*     */     }
/*     */ 
/* 390 */     throw new IllegalStateException("Field " + fieldName + " not found in entity " + getEntityName());
/*     */   }
/*     */ 
/*     */   public Class getRemoteInterface()
/*     */   {
/* 395 */     return this.metadata.getRemoteClass();
/*     */   }
/*     */ 
/*     */   public Class getLocalInterface()
/*     */   {
/* 400 */     return this.metadata.getLocalClass();
/*     */   }
/*     */ 
/*     */   JDBCCMPFieldBridge2 addTableField(JDBCCMPFieldMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/* 407 */     this.table.addField();
/* 408 */     if (this.tableFields == null)
/*     */     {
/* 410 */       this.tableFields = new JDBCCMPFieldBridge2[1];
/*     */     }
/*     */     else
/*     */     {
/* 414 */       JDBCCMPFieldBridge2[] tmp = this.tableFields;
/* 415 */       this.tableFields = new JDBCCMPFieldBridge2[this.tableFields.length + 1];
/* 416 */       System.arraycopy(tmp, 0, this.tableFields, 0, tmp.length);
/*     */     }
/* 418 */     int tableIndex = this.tableFields.length - 1;
/* 419 */     JDBCCMPFieldBridge2 cmpField = new JDBCCMPFieldBridge2(this.manager, this, metadata, tableIndex);
/* 420 */     this.tableFields[(this.tableFields.length - 1)] = cmpField;
/* 421 */     return cmpField;
/*     */   }
/*     */ 
/*     */   private void loadCMPFields(JDBCEntityMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/* 430 */     List cmpFieldsList = new ArrayList(metadata.getCMPFields().size());
/*     */ 
/* 432 */     List pkFieldsList = new ArrayList(metadata.getCMPFields().size());
/*     */ 
/* 435 */     Iterator iter = metadata.getCMPFields().iterator();
/* 436 */     while (iter.hasNext())
/*     */     {
/* 438 */       JDBCCMPFieldMetaData cmpFieldMetaData = (JDBCCMPFieldMetaData)iter.next();
/* 439 */       JDBCCMPFieldBridge2 cmpField = addTableField(cmpFieldMetaData);
/* 440 */       if (cmpFieldMetaData.isPrimaryKeyMember())
/*     */       {
/* 442 */         pkFieldsList.add(cmpField);
/*     */       }
/*     */       else
/*     */       {
/* 446 */         cmpFieldsList.add(cmpField);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 451 */     this.pkFields = new JDBCCMPFieldBridge2[pkFieldsList.size()];
/* 452 */     for (int i = 0; i < pkFieldsList.size(); i++)
/*     */     {
/* 454 */       this.pkFields[i] = ((JDBCCMPFieldBridge2)pkFieldsList.get(i));
/*     */     }
/*     */ 
/* 458 */     this.cmpFields = new JDBCCMPFieldBridge2[metadata.getCMPFields().size() - this.pkFields.length];
/* 459 */     int cmpFieldIndex = 0;
/* 460 */     for (int i = 0; i < cmpFieldsList.size(); i++)
/*     */     {
/* 462 */       this.cmpFields[(cmpFieldIndex++)] = ((JDBCCMPFieldBridge2)cmpFieldsList.get(i));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void loadCMRFields(JDBCEntityMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/* 469 */     this.cmrFields = new JDBCCMRFieldBridge2[metadata.getRelationshipRoles().size()];
/*     */ 
/* 471 */     int cmrFieldIndex = 0;
/* 472 */     for (Iterator iter = metadata.getRelationshipRoles().iterator(); iter.hasNext(); )
/*     */     {
/* 474 */       JDBCRelationshipRoleMetaData relationshipRole = (JDBCRelationshipRoleMetaData)iter.next();
/* 475 */       JDBCCMRFieldBridge2 cmrField = new JDBCCMRFieldBridge2(this, this.manager, relationshipRole);
/* 476 */       this.cmrFields[(cmrFieldIndex++)] = cmrField;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2
 * JD-Core Version:    0.6.0
 */