/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.plugins.AbstractInterceptor;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.LocalEJBInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ 
/*     */ public class RelationInterceptor extends AbstractInterceptor
/*     */ {
/*     */   private Logger log;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  51 */     this.container = ((EntityContainer)container);
/*  52 */     if (container != null)
/*     */     {
/*  54 */       this.log = Logger.getLogger(getClass().getName() + "." + container.getBeanMetaData().getEjbName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  65 */     if (!(mi instanceof CMRInvocation))
/*     */     {
/*  67 */       return getNext().invoke(mi);
/*     */     }
/*     */ 
/*  70 */     CMRMessage msg = ((CMRInvocation)mi).getCmrMessage();
/*     */ 
/*  73 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*  74 */     JDBCCMRFieldBridge2 cmrField = (JDBCCMRFieldBridge2)mi.getArguments()[0];
/*     */ 
/*  76 */     if (CMRMessage.ADD_RELATION == msg)
/*     */     {
/*  78 */       Object relatedId = mi.getArguments()[1];
/*  79 */       if (this.log.isTraceEnabled())
/*     */       {
/*  81 */         this.log.trace("Add relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
/*     */       }
/*     */ 
/*  86 */       cmrField.addRelatedId(ctx, relatedId);
/*     */     }
/*  88 */     else if (CMRMessage.REMOVE_RELATION == msg)
/*     */     {
/*  91 */       Object relatedId = mi.getArguments()[1];
/*  92 */       if (this.log.isTraceEnabled())
/*     */       {
/*  94 */         this.log.trace("Remove relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
/*     */       }
/*     */ 
/*  99 */       cmrField.removeRelatedId(ctx, relatedId);
/*     */     }
/*     */     else
/*     */     {
/* 104 */       throw new EJBException("Unknown cmp2.0-relationship-message=" + msg);
/*     */     }
/*     */ 
/* 107 */     return null;
/*     */   }
/* 124 */   public static final class CMRMessage implements Serializable { private static int nextOrdinal = 0;
/* 125 */     private static final CMRMessage[] VALUES = new CMRMessage[5];
/*     */ 
/* 127 */     public static final CMRMessage ADD_RELATED_ID = new CMRMessage("ADD_RELATED_ID");
/* 128 */     public static final CMRMessage REMOVE_RELATED_ID = new CMRMessage("REMOVE_RELATED_ID");
/* 129 */     public static final CMRMessage DESTROY_EXISTING_RELATIONSHIPS = new CMRMessage("DESTROY_EXISTING_RELATIONSHIPS");
/*     */     private final transient String name;
/*     */     private final int ordinal;
/*     */ 
/* 136 */     private CMRMessage(String name) { this.name = name;
/* 137 */       this.ordinal = (nextOrdinal++);
/* 138 */       VALUES[this.ordinal] = this;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 143 */       return this.name;
/*     */     }
/*     */ 
/*     */     Object readResolve() throws ObjectStreamException
/*     */     {
/* 148 */       return VALUES[this.ordinal];
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class RelationInvocation extends LocalEJBInvocation
/*     */   {
/*     */     public final RelationInterceptor.CMRMessage msg;
/*     */ 
/*     */     public RelationInvocation(RelationInterceptor.CMRMessage msg)
/*     */     {
/* 118 */       this.msg = msg;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.RelationInterceptor
 * JD-Core Version:    0.6.0
 */