/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.DuplicateKeyException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class PkSqlCreateCommand
/*     */   implements CreateCommand
/*     */ {
/*     */   private Logger log;
/*     */   private JDBCEntityBridge2 entityBridge;
/*     */   private String pkSql;
/*     */   private JDBCCMPFieldBridge2 pkField;
/*     */ 
/*     */   public void init(JDBCStoreManager2 manager)
/*     */     throws DeploymentException
/*     */   {
/*  55 */     this.entityBridge = ((JDBCEntityBridge2)manager.getEntityBridge());
/*  56 */     this.log = Logger.getLogger(getClass().getName() + "." + this.entityBridge.getEntityName());
/*     */ 
/*  58 */     JDBCFieldBridge[] pkFields = this.entityBridge.getPrimaryKeyFields();
/*  59 */     if (pkFields.length > 1)
/*     */     {
/*  61 */       throw new DeploymentException("This entity-command cannot be used with composite primary keys!");
/*     */     }
/*  63 */     this.pkField = ((JDBCCMPFieldBridge2)pkFields[0]);
/*     */ 
/*  65 */     JDBCEntityCommandMetaData metadata = this.entityBridge.getMetaData().getEntityCommand();
/*  66 */     this.pkSql = metadata.getAttribute("pk-sql");
/*  67 */     if (this.pkSql == null)
/*     */     {
/*  69 */       throw new DeploymentException("pk-sql attribute must be set for entity " + this.entityBridge.getEntityName());
/*     */     }
/*  71 */     if (this.log.isDebugEnabled())
/*     */     {
/*  73 */       this.log.debug("entity-command generate pk sql: " + this.pkSql);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws CreateException
/*     */   {
/*  80 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*     */     Object pk;
/*  81 */     if (ctx.getId() == null) { Connection con = null;
/*  84 */       PreparedStatement ps = null;
/*  85 */       ResultSet rs = null;
/*     */       Object pk;
/*     */       try { if (this.log.isDebugEnabled())
/*     */         {
/*  90 */           this.log.debug("executing sql: " + this.pkSql);
/*     */         }
/*     */ 
/*  93 */         con = this.entityBridge.getDataSource().getConnection();
/*  94 */         ps = con.prepareStatement(this.pkSql);
/*  95 */         rs = ps.executeQuery();
/*     */ 
/*  97 */         if (!rs.next())
/*     */         {
/*  99 */           throw new CreateException("pk-sql " + this.pkSql + " returned no results!");
/*     */         }
/*     */ 
/* 102 */         pk = this.pkField.loadArgumentResults(rs, 1);
/* 103 */         pctx.setFieldValue(this.pkField.getRowIndex(), pk);
/* 104 */         pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 108 */         this.log.error("Failed to execute pk sql. error code: " + e.getErrorCode() + ", sql state: " + e.getSQLState(), e);
/* 109 */         throw new CreateException("Failed to execute pk sql: " + e.getMessage() + ", error code: " + e.getErrorCode() + ", sql state: " + e.getSQLState());
/*     */       }
/*     */       finally
/*     */       {
/* 114 */         JDBCUtil.safeClose(rs);
/* 115 */         JDBCUtil.safeClose(ps);
/* 116 */         JDBCUtil.safeClose(con);
/*     */       }
/*     */ 
/* 119 */       if (pk == null)
/*     */       {
/* 121 */         this.log.error("Primary key for created instance is null.");
/* 122 */         throw new CreateException("Primary key for created instance is null.");
/*     */       }
/*     */ 
/* 125 */       pctx.setPk(pk);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 132 */         pctx.flush();
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 136 */         if ("23000".equals(e.getSQLState()))
/*     */         {
/* 138 */           throw new DuplicateKeyException("Unique key violation or invalid foreign key value: pk=" + ctx.getId());
/*     */         }
/*     */ 
/* 142 */         throw new CreateException("Failed to create instance: pk=" + ctx.getId() + ", state=" + e.getSQLState() + ", msg=" + e.getMessage());
/*     */       }
/*     */ 
/* 149 */       pk = ctx.getId();
/*     */     }
/* 151 */     return pk;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.PkSqlCreateCommand
 * JD-Core Version:    0.6.0
 */