/*    */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.EJBQLToSQL92Compiler;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.QLCompiler;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JBossQLQueryCommand extends AbstractQueryCommand
/*    */ {
/*    */   public JBossQLQueryCommand(JDBCEntityBridge2 entity, JDBCJBossQLQueryMetaData metadata)
/*    */     throws DeploymentException
/*    */   {
/* 41 */     this.entity = entity;
/*    */ 
/* 43 */     JDBCStoreManager2 manager = (JDBCStoreManager2)entity.getManager();
/* 44 */     QLCompiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
/*    */     try
/*    */     {
/* 48 */       compiler.compileJBossQL(metadata.getJBossQL(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 56 */       t.printStackTrace();
/* 57 */       throw new DeploymentException("Error compiling JBossQL statement '" + metadata.getJBossQL() + "'", t);
/*    */     }
/*    */ 
/* 60 */     this.sql = compiler.getSQL();
/*    */ 
/* 62 */     setOffsetParam(compiler.getOffsetParam());
/* 63 */     setOffsetValue(compiler.getOffsetValue());
/* 64 */     setLimitParam(compiler.getLimitParam());
/* 65 */     setLimitValue(compiler.getLimitValue());
/*    */ 
/* 67 */     this.log = Logger.getLogger(getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName());
/* 68 */     this.log.debug("sql: " + this.sql);
/*    */ 
/* 70 */     setParameters(compiler.getInputParameters());
/* 71 */     setResultType(metadata.getMethod().getReturnType());
/*    */ 
/* 73 */     if (!compiler.isSelectEntity())
/*    */     {
/* 75 */       if (compiler.isSelectField())
/*    */       {
/* 77 */         setFieldReader((JDBCCMPFieldBridge2)compiler.getSelectField());
/*    */       }
/*    */       else
/*    */       {
/* 81 */         setFunctionReader(compiler.getSelectFunction());
/*    */       }
/*    */     }
/*    */     else
/*    */     {
/* 86 */       setEntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.JBossQLQueryCommand
 * JD-Core Version:    0.6.0
 */