/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.EJBQLToSQL92Compiler;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.QLCompiler;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DynamicQueryCommand
/*     */   implements QueryCommand
/*     */ {
/*     */   private Logger log;
/*     */   private JDBCEntityBridge2 entity;
/*     */   private JDBCDynamicQLQueryMetaData metadata;
/*     */   private AbstractQueryCommand.CollectionFactory collectionFactory;
/*     */ 
/*     */   public DynamicQueryCommand(JDBCEntityBridge2 entity, JDBCDynamicQLQueryMetaData metadata)
/*     */   {
/*  52 */     this.log = Logger.getLogger(getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName());
/*     */ 
/*  54 */     this.entity = entity;
/*  55 */     this.metadata = metadata;
/*     */ 
/*  57 */     Class returnType = metadata.getMethod().getReturnType();
/*  58 */     if (Collection.class.isAssignableFrom(returnType))
/*     */     {
/*  60 */       if (Set.class.isAssignableFrom(returnType))
/*     */       {
/*  62 */         this.collectionFactory = AbstractQueryCommand.SET_FACTORY;
/*     */       }
/*     */       else
/*     */       {
/*  66 */         this.collectionFactory = AbstractQueryCommand.COLLECTION_FACTORY;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCStoreManager2 getStoreManager()
/*     */   {
/*  73 */     return (JDBCStoreManager2)this.entity.getManager();
/*     */   }
/*     */ 
/*     */   public Collection fetchCollection(Schema schema, GenericEntityObjectFactory factory, Object[] args)
/*     */     throws FinderException
/*     */   {
/*  79 */     if (this.log.isTraceEnabled())
/*     */     {
/*  81 */       this.log.trace("executing dynamic-ql: " + args[0]);
/*     */     }
/*     */ 
/*  84 */     JDBCStoreManager2 manager = (JDBCStoreManager2)this.entity.getManager();
/*  85 */     QLCompiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
/*     */     try
/*     */     {
/*  88 */       compiler.compileJBossQL((String)args[0], this.metadata.getMethod().getReturnType(), getParamTypes(args), this.metadata);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  96 */       this.log.error("Error compiling JBossQL statement '" + args[0] + "'", t);
/*  97 */       throw new FinderException("Error compiling JBossQL statement '" + args[0] + "'");
/*     */     }
/*     */ 
/* 100 */     String sql = compiler.getSQL();
/*     */ 
/* 102 */     int offsetParam = compiler.getOffsetParam();
/* 103 */     int offsetValue = compiler.getOffsetValue();
/* 104 */     int limitParam = compiler.getLimitParam();
/* 105 */     int limitValue = compiler.getLimitValue();
/*     */     AbstractQueryCommand.ResultReader resultReader;
/*     */     AbstractQueryCommand.ResultReader resultReader;
/* 108 */     if (!compiler.isSelectEntity())
/*     */     {
/*     */       AbstractQueryCommand.ResultReader resultReader;
/* 110 */       if (compiler.isSelectField())
/*     */       {
/* 112 */         resultReader = new AbstractQueryCommand.FieldReader((JDBCCMPFieldBridge2)compiler.getSelectField());
/*     */       }
/*     */       else
/*     */       {
/* 116 */         resultReader = new AbstractQueryCommand.FunctionReader(compiler.getSelectFunction());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 121 */       resultReader = new AbstractQueryCommand.EntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
/*     */     }
/*     */ 
/* 124 */     return AbstractQueryCommand.fetchCollection(this.entity, sql, toArray(compiler.getInputParameters()), AbstractQueryCommand.toInt(args, offsetParam, offsetValue), AbstractQueryCommand.toInt(args, limitParam, limitValue), new AbstractQueryCommand.EagerCollectionStrategy(this.collectionFactory, resultReader, this.log), schema, factory, (Object[])(Object[])args[1], this.log);
/*     */   }
/*     */ 
/*     */   public Object fetchOne(Schema schema, GenericEntityObjectFactory factory, Object[] args)
/*     */     throws FinderException
/*     */   {
/* 133 */     if (this.log.isTraceEnabled())
/*     */     {
/* 135 */       this.log.trace("executing dynamic-ql: " + args[0]);
/*     */     }
/*     */ 
/* 138 */     JDBCStoreManager2 manager = (JDBCStoreManager2)this.entity.getManager();
/* 139 */     QLCompiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
/*     */     try
/*     */     {
/* 142 */       compiler.compileJBossQL((String)args[0], this.metadata.getMethod().getReturnType(), getParamTypes(args), this.metadata);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 150 */       this.log.error("Error compiling JBossQL statement '" + args[0] + "'", t);
/* 151 */       throw new FinderException("Error compiling JBossQL statement '" + args[0] + "'");
/*     */     }
/*     */ 
/* 154 */     String sql = compiler.getSQL();
/*     */     AbstractQueryCommand.ResultReader resultReader;
/*     */     AbstractQueryCommand.ResultReader resultReader;
/* 157 */     if (!compiler.isSelectEntity())
/*     */     {
/*     */       AbstractQueryCommand.ResultReader resultReader;
/* 159 */       if (compiler.isSelectField())
/*     */       {
/* 161 */         resultReader = new AbstractQueryCommand.FieldReader((JDBCCMPFieldBridge2)compiler.getSelectField());
/*     */       }
/*     */       else
/*     */       {
/* 165 */         resultReader = new AbstractQueryCommand.FunctionReader(compiler.getSelectFunction());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 170 */       resultReader = new AbstractQueryCommand.EntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
/*     */     }
/*     */ 
/* 173 */     return AbstractQueryCommand.fetchOne(this.entity, sql, toArray(compiler.getInputParameters()), resultReader, (Object[])(Object[])args[1], factory, this.log);
/*     */   }
/*     */ 
/*     */   private static Class[] getParamTypes(Object[] args)
/*     */     throws FinderException
/*     */   {
/* 183 */     Object[] parameters = (Object[])(Object[])args[1];
/*     */     Class[] parameterTypes;
/*     */     Class[] parameterTypes;
/* 184 */     if (parameters == null)
/*     */     {
/* 186 */       parameterTypes = new Class[0];
/*     */     }
/*     */     else
/*     */     {
/* 191 */       parameterTypes = new Class[parameters.length];
/* 192 */       for (int i = 0; i < parameters.length; i++)
/*     */       {
/* 194 */         if (parameters[i] == null)
/*     */         {
/* 196 */           throw new FinderException("Parameter[" + i + "] is null");
/*     */         }
/* 198 */         parameterTypes[i] = parameters[i].getClass();
/*     */       }
/*     */     }
/* 201 */     return parameterTypes;
/*     */   }
/*     */ 
/*     */   static QueryParameter[] toArray(List p)
/*     */   {
/* 206 */     QueryParameter[] params = null;
/* 207 */     if (p.size() > 0)
/*     */     {
/* 209 */       params = (QueryParameter[])(QueryParameter[])p.toArray(new QueryParameter[p.size()]);
/*     */     }
/* 211 */     return params;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.DynamicQueryCommand
 * JD-Core Version:    0.6.0
 */