/*    */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*    */ 
/*    */ import java.net.URL;
/*    */ import java.util.Collections;
/*    */ import java.util.Hashtable;
/*    */ import java.util.Iterator;
/*    */ import java.util.Set;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.MetaData;
/*    */ import org.jboss.metadata.XmlFileLoader;
/*    */ import org.jboss.system.ServiceMBeanSupport;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class MetaDataLibrary extends ServiceMBeanSupport
/*    */   implements MetaDataLibraryMBean
/*    */ {
/* 46 */   private final Hashtable typeMappings = new Hashtable();
/*    */ 
/*    */   public JDBCTypeMappingMetaData findTypeMappingMetaData(String name)
/*    */   {
/* 53 */     return (JDBCTypeMappingMetaData)this.typeMappings.get(name);
/*    */   }
/*    */ 
/*    */   public Set getTypeMappingNames()
/*    */   {
/* 61 */     return Collections.unmodifiableSet(this.typeMappings.keySet());
/*    */   }
/*    */ 
/*    */   public void startService() throws Exception
/*    */   {
/* 66 */     ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
/*    */ 
/* 68 */     URL stdJDBCUrl = classLoader.getResource("standardjbosscmp-jdbc.xml");
/* 69 */     if (stdJDBCUrl == null)
/*    */     {
/* 71 */       throw new DeploymentException("No standardjbosscmp-jdbc.xml found");
/*    */     }
/*    */ 
/* 74 */     boolean debug = this.log.isDebugEnabled();
/* 75 */     if (debug)
/*    */     {
/* 77 */       this.log.debug("Loading standardjbosscmp-jdbc.xml : " + stdJDBCUrl.toString());
/*    */     }
/* 79 */     Element stdJDBCElement = XmlFileLoader.getDocument(stdJDBCUrl, true).getDocumentElement();
/*    */ 
/* 81 */     Element typeMaps = MetaData.getOptionalChild(stdJDBCElement, "type-mappings");
/*    */     Iterator i;
/* 82 */     if (typeMaps != null)
/*    */     {
/* 84 */       for (i = MetaData.getChildrenByTagName(typeMaps, "type-mapping"); i.hasNext(); )
/*    */       {
/* 86 */         Element typeMappingElement = (Element)i.next();
/* 87 */         JDBCTypeMappingMetaData typeMapping = new JDBCTypeMappingMetaData(typeMappingElement);
/* 88 */         this.typeMappings.put(typeMapping.getName(), typeMapping);
/*    */ 
/* 90 */         this.log.debug("added type-mapping: " + typeMapping.getName());
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stopService() throws Exception
/*    */   {
/* 97 */     this.typeMappings.clear();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.MetaDataLibrary
 * JD-Core Version:    0.6.0
 */