/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCValuePropertyMetaData
/*     */ {
/*     */   private final String propertyName;
/*     */   private final Class propertyType;
/*     */   private final String columnName;
/*     */   private final String sqlType;
/*     */   private final int jdbcType;
/*     */   private final boolean notNull;
/*     */   private final Method getter;
/*     */   private final Method setter;
/*     */ 
/*     */   public JDBCValuePropertyMetaData(Element element, Class classType)
/*     */     throws DeploymentException
/*     */   {
/*  60 */     this.propertyName = MetaData.getUniqueChildContent(element, "property-name");
/*     */ 
/*  63 */     String columnNameString = MetaData.getOptionalChildContent(element, "column-name");
/*     */ 
/*  65 */     if (columnNameString != null)
/*  66 */       this.columnName = columnNameString;
/*     */     else {
/*  68 */       this.columnName = this.propertyName;
/*     */     }
/*     */ 
/*  72 */     Element notNullElement = MetaData.getOptionalChild(element, "not-null");
/*  73 */     this.notNull = (notNullElement != null);
/*     */     try
/*     */     {
/*  77 */       this.getter = classType.getMethod(toGetterName(this.propertyName), new Class[0]);
/*     */     } catch (Exception e) {
/*  79 */       throw new DeploymentException("Unable to find getter for property " + this.propertyName + " on dependent value class " + classType.getName());
/*     */     }
/*     */ 
/*  85 */     this.propertyType = this.getter.getReturnType();
/*     */     try
/*     */     {
/*  89 */       this.setter = classType.getMethod(toSetterName(this.propertyName), new Class[] { this.propertyType });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  93 */       throw new DeploymentException("Unable to find setter for property " + this.propertyName + " on dependent value class " + classType.getName());
/*     */     }
/*     */ 
/*  99 */     String jdbcString = MetaData.getOptionalChildContent(element, "jdbc-type");
/*     */ 
/* 101 */     if (jdbcString != null) {
/* 102 */       this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcString);
/*     */ 
/* 105 */       this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*     */     } else {
/* 107 */       this.jdbcType = -2147483648;
/* 108 */       this.sqlType = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getPropertyName()
/*     */   {
/* 120 */     return this.propertyName;
/*     */   }
/*     */ 
/*     */   public Class getPropertyType()
/*     */   {
/* 130 */     return this.propertyType;
/*     */   }
/*     */ 
/*     */   public String getColumnName()
/*     */   {
/* 139 */     return this.columnName;
/*     */   }
/*     */ 
/*     */   public int getJDBCType()
/*     */   {
/* 149 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public String getSqlType()
/*     */   {
/* 159 */     return this.sqlType;
/*     */   }
/*     */ 
/*     */   public boolean isNotNull()
/*     */   {
/* 167 */     return this.notNull;
/*     */   }
/*     */ 
/*     */   public Method getGetter()
/*     */   {
/* 177 */     return this.getter;
/*     */   }
/*     */ 
/*     */   public Method getSetter()
/*     */   {
/* 187 */     return this.setter;
/*     */   }
/*     */ 
/*     */   private static String toGetterName(String propertyName) {
/* 191 */     return "get" + upCaseFirstCharacter(propertyName);
/*     */   }
/*     */ 
/*     */   private static String toSetterName(String propertyName) {
/* 195 */     return "set" + upCaseFirstCharacter(propertyName);
/*     */   }
/*     */ 
/*     */   private static String upCaseFirstCharacter(String propertyName) {
/* 199 */     return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCValuePropertyMetaData
 * JD-Core Version:    0.6.0
 */