/*    */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collections;
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.metadata.MetaData;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public final class JDBCValueClassMetaData
/*    */ {
/*    */   private final Class javaType;
/*    */   private final List properties;
/*    */ 
/*    */   public JDBCValueClassMetaData(Element classElement, ClassLoader classLoader)
/*    */     throws DeploymentException
/*    */   {
/* 53 */     String className = MetaData.getUniqueChildContent(classElement, "class");
/*    */     try {
/* 55 */       this.javaType = classLoader.loadClass(className);
/*    */     } catch (ClassNotFoundException e) {
/* 57 */       throw new DeploymentException("dependent-value-class not found: " + className);
/*    */     }
/*    */ 
/* 60 */     List propertyList = new ArrayList();
/* 61 */     Iterator iterator = MetaData.getChildrenByTagName(classElement, "property");
/* 62 */     while (iterator.hasNext()) {
/* 63 */       Element propertyElement = (Element)iterator.next();
/*    */ 
/* 65 */       propertyList.add(new JDBCValuePropertyMetaData(propertyElement, this.javaType));
/*    */     }
/* 67 */     this.properties = Collections.unmodifiableList(propertyList);
/*    */   }
/*    */ 
/*    */   public Class getJavaType()
/*    */   {
/* 76 */     return this.javaType;
/*    */   }
/*    */ 
/*    */   public List getProperties()
/*    */   {
/* 85 */     return this.properties;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCValueClassMetaData
 * JD-Core Version:    0.6.0
 */