/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCTypeMappingMetaData
/*     */ {
/*  42 */   private static final String[] PRIMITIVES = { "boolean", "byte", "char", "short", "int", "long", "float", "double" };
/*     */ 
/*  46 */   private static final String[] PRIMITIVE_CLASSES = { "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double" };
/*     */   public static final String CONCAT = "concat";
/*     */   public static final String SUBSTRING = "substring";
/*     */   public static final String LCASE = "lcase";
/*     */   public static final String UCASE = "ucase";
/*     */   public static final String LENGTH = "length";
/*     */   public static final String LOCATE = "locate";
/*     */   public static final String ABS = "abs";
/*     */   public static final String SQRT = "sqrt";
/*     */   public static final String COUNT = "count";
/*     */   public static final String MOD = "mod";
/*     */   public static JDBCFunctionMappingMetaData COUNT_FUNC;
/*     */   public static JDBCFunctionMappingMetaData MAX_FUNC;
/*     */   public static JDBCFunctionMappingMetaData MIN_FUNC;
/*     */   public static JDBCFunctionMappingMetaData AVG_FUNC;
/*     */   public static JDBCFunctionMappingMetaData SUM_FUNC;
/*     */   private final String name;
/*  87 */   private final HashMap mappings = new HashMap();
/*     */ 
/*  89 */   private final HashMap functionMappings = new HashMap();
/*     */   private final String aliasHeaderPrefix;
/*     */   private final String aliasHeaderSuffix;
/*     */   private final int aliasMaxLength;
/*     */   private final boolean subquerySupported;
/*     */   private final String trueMapping;
/*     */   private final String falseMapping;
/*     */   private final int maxKeysInDelete;
/* 101 */   private JDBCFunctionMappingMetaData rowLocking = null;
/* 102 */   private JDBCFunctionMappingMetaData fkConstraint = null;
/* 103 */   private JDBCFunctionMappingMetaData pkConstraint = null;
/* 104 */   private JDBCFunctionMappingMetaData autoIncrement = null;
/* 105 */   private JDBCFunctionMappingMetaData addColumn = null;
/* 106 */   private JDBCFunctionMappingMetaData dropColumn = null;
/* 107 */   private JDBCFunctionMappingMetaData alterColumn = null;
/*     */ 
/*     */   public JDBCTypeMappingMetaData(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 120 */     this.name = MetaData.getUniqueChildContent(element, "name");
/*     */ 
/* 123 */     String rowLockingSQL = MetaData.getUniqueChildContent(element, "row-locking-template");
/* 124 */     if ((rowLockingSQL != null) && (!rowLockingSQL.trim().equals("")))
/*     */     {
/* 126 */       this.rowLocking = new JDBCFunctionMappingMetaData("row-locking", rowLockingSQL);
/*     */     }
/*     */ 
/* 130 */     String pkConstraintSQL = MetaData.getUniqueChildContent(element, "pk-constraint-template");
/* 131 */     if ((pkConstraintSQL != null) && (!pkConstraintSQL.trim().equals("")))
/*     */     {
/* 133 */       this.pkConstraint = new JDBCFunctionMappingMetaData("pk-constraint", pkConstraintSQL);
/*     */     }
/*     */ 
/* 137 */     String fkConstraintSQL = MetaData.getUniqueChildContent(element, "fk-constraint-template");
/* 138 */     if ((fkConstraintSQL != null) && (!fkConstraintSQL.trim().equals("")))
/*     */     {
/* 140 */       this.fkConstraint = new JDBCFunctionMappingMetaData("fk-constraint", fkConstraintSQL);
/*     */     }
/*     */ 
/* 144 */     String alterColumnSQL = MetaData.getOptionalChildContent(element, "add-column-template");
/* 145 */     if ((alterColumnSQL != null) && (!alterColumnSQL.trim().equals("")))
/*     */     {
/* 147 */       this.addColumn = new JDBCFunctionMappingMetaData("add-column-template", alterColumnSQL);
/*     */     }
/*     */     else
/*     */     {
/* 151 */       this.addColumn = new JDBCFunctionMappingMetaData("add-column-template", "ALTER TABLE ?1 ADD ?2 ?3");
/*     */     }
/* 153 */     alterColumnSQL = MetaData.getOptionalChildContent(element, "alter-column-template");
/* 154 */     if ((alterColumnSQL != null) && (!alterColumnSQL.trim().equals("")))
/*     */     {
/* 156 */       this.alterColumn = new JDBCFunctionMappingMetaData("alter-column-template", alterColumnSQL);
/*     */     }
/*     */     else
/*     */     {
/* 160 */       this.alterColumn = new JDBCFunctionMappingMetaData("alter-column-template", "ALTER TABLE ?1 ALTER ?2 TYPE ?3");
/*     */     }
/* 162 */     alterColumnSQL = MetaData.getOptionalChildContent(element, "drop-column-template");
/* 163 */     if ((alterColumnSQL != null) && (!alterColumnSQL.trim().equals("")))
/*     */     {
/* 165 */       this.dropColumn = new JDBCFunctionMappingMetaData("drop-column-template", alterColumnSQL);
/*     */     }
/*     */     else
/*     */     {
/* 169 */       this.dropColumn = new JDBCFunctionMappingMetaData("drop-column-template", "ALTER TABLE ?1 DROP ?2");
/*     */     }
/*     */ 
/* 174 */     String autoIncrementSQL = MetaData.getOptionalChildContent(element, "auto-increment-template");
/* 175 */     if ((autoIncrementSQL != null) && (!autoIncrementSQL.trim().equals("")))
/*     */     {
/* 177 */       this.autoIncrement = new JDBCFunctionMappingMetaData("auto-increment", autoIncrementSQL);
/*     */     }
/*     */ 
/* 181 */     Iterator iterator = MetaData.getChildrenByTagName(element, "mapping");
/* 182 */     while (iterator.hasNext())
/*     */     {
/* 184 */       Element mappingElement = (Element)iterator.next();
/* 185 */       JDBCMappingMetaData mapping = new JDBCMappingMetaData(mappingElement);
/* 186 */       this.mappings.put(mapping.getJavaType(), mapping);
/*     */     }
/*     */ 
/* 189 */     addDefaultFunctionMapping();
/*     */ 
/* 192 */     Iterator functions = MetaData.getChildrenByTagName(element, "function-mapping");
/* 193 */     while (functions.hasNext())
/*     */     {
/* 195 */       Element mappingElement = (Element)functions.next();
/* 196 */       JDBCFunctionMappingMetaData functionMapping = new JDBCFunctionMappingMetaData(mappingElement);
/* 197 */       this.functionMappings.put(functionMapping.getFunctionName().toLowerCase(), functionMapping);
/*     */     }
/*     */ 
/* 200 */     this.aliasHeaderPrefix = MetaData.getUniqueChildContent(element, "alias-header-prefix");
/*     */ 
/* 202 */     this.aliasHeaderSuffix = MetaData.getUniqueChildContent(element, "alias-header-suffix");
/*     */ 
/* 204 */     String aliasMaxLengthString = MetaData.getUniqueChildContent(element, "alias-max-length");
/*     */     try
/*     */     {
/* 207 */       this.aliasMaxLength = Integer.parseInt(aliasMaxLengthString);
/*     */     }
/*     */     catch (NumberFormatException e)
/*     */     {
/* 211 */       throw new DeploymentException("Invalid number format in alias-max-length " + aliasMaxLengthString + "': " + e);
/*     */     }
/*     */ 
/* 215 */     String subquerySupportedStr = MetaData.getUniqueChildContent(element, "subquery-supported");
/* 216 */     this.subquerySupported = Boolean.valueOf(subquerySupportedStr).booleanValue();
/* 217 */     this.trueMapping = MetaData.getUniqueChildContent(element, "true-mapping");
/* 218 */     this.falseMapping = MetaData.getUniqueChildContent(element, "false-mapping");
/*     */ 
/* 220 */     String str = MetaData.getOptionalChildContent(element, "max-keys-in-delete");
/* 221 */     if (str != null)
/*     */     {
/*     */       try
/*     */       {
/* 225 */         this.maxKeysInDelete = Integer.parseInt(str);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 229 */         throw new DeploymentException("Failed to parse int value '" + str + "' for max-keys-in-delete", e);
/*     */       }
/*     */ 
/* 232 */       if (this.maxKeysInDelete < 0)
/*     */       {
/* 234 */         throw new DeploymentException("The value of max-keys-in-delete cannot be less than 0: " + this.maxKeysInDelete);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 239 */       this.maxKeysInDelete = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 251 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getAliasHeaderPrefix()
/*     */   {
/* 264 */     return this.aliasHeaderPrefix;
/*     */   }
/*     */ 
/*     */   public String getAliasHeaderSuffix()
/*     */   {
/* 277 */     return this.aliasHeaderSuffix;
/*     */   }
/*     */ 
/*     */   public int getAliasMaxLength()
/*     */   {
/* 287 */     return this.aliasMaxLength;
/*     */   }
/*     */ 
/*     */   public boolean isSubquerySupported()
/*     */   {
/* 295 */     return this.subquerySupported;
/*     */   }
/*     */ 
/*     */   public String getTrueMapping()
/*     */   {
/* 303 */     return this.trueMapping;
/*     */   }
/*     */ 
/*     */   public String getFalseMapping()
/*     */   {
/* 311 */     return this.falseMapping;
/*     */   }
/*     */ 
/*     */   public int getMaxKeysInDelete()
/*     */   {
/* 316 */     return this.maxKeysInDelete;
/*     */   }
/*     */ 
/*     */   public JDBCMappingMetaData getTypeMappingMetaData(Class type)
/*     */   {
/* 321 */     String javaType = type.getName();
/*     */ 
/* 324 */     for (int i = 0; i < PRIMITIVES.length; i++)
/*     */     {
/* 326 */       if (!javaType.equals(PRIMITIVES[i])) {
/*     */         continue;
/*     */       }
/* 329 */       javaType = PRIMITIVE_CLASSES[i];
/* 330 */       break;
/*     */     }
/*     */ 
/* 335 */     JDBCMappingMetaData mapping = (JDBCMappingMetaData)this.mappings.get(javaType);
/*     */ 
/* 338 */     if (mapping == null)
/*     */     {
/* 340 */       mapping = (JDBCMappingMetaData)this.mappings.get("java.lang.Object");
/*     */     }
/*     */ 
/* 343 */     return mapping;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getFunctionMapping(String name)
/*     */   {
/* 348 */     JDBCFunctionMappingMetaData funcMapping = (JDBCFunctionMappingMetaData)this.functionMappings.get(name.toLowerCase());
/* 349 */     if (funcMapping == null)
/* 350 */       throw new IllegalStateException("Function " + name + " is not defined for " + this.name);
/* 351 */     return funcMapping;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getRowLockingTemplate()
/*     */   {
/* 360 */     return this.rowLocking;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getPkConstraintTemplate()
/*     */   {
/* 368 */     return this.pkConstraint;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getFkConstraintTemplate()
/*     */   {
/* 376 */     return this.fkConstraint;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getAutoIncrementTemplate()
/*     */   {
/* 384 */     return this.autoIncrement;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getAddColumnTemplate()
/*     */   {
/* 392 */     return this.addColumn;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getDropColumnTemplate()
/*     */   {
/* 400 */     return this.dropColumn;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData getAlterColumnTemplate()
/*     */   {
/* 408 */     return this.alterColumn;
/*     */   }
/*     */ 
/*     */   public Collection getMappings()
/*     */   {
/* 413 */     return this.mappings.values();
/*     */   }
/*     */ 
/*     */   private void addDefaultFunctionMapping()
/*     */     throws DeploymentException
/*     */   {
/* 421 */     JDBCFunctionMappingMetaData function = new JDBCFunctionMappingMetaData("concat", new String[] { "{fn concat(", ", ", ")}" }, new int[] { 0, 1 });
/*     */ 
/* 428 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 431 */     function = new JDBCFunctionMappingMetaData("substring", new String[] { "{fn substring(", ", ", ", ", ")}" }, new int[] { 0, 1, 2 });
/*     */ 
/* 439 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 442 */     function = new JDBCFunctionMappingMetaData("lcase", new String[] { "{fn lcase(", ")}" }, new int[] { 0 });
/*     */ 
/* 448 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 451 */     function = new JDBCFunctionMappingMetaData("ucase", new String[] { "{fn ucase(", ")}" }, new int[] { 0 });
/*     */ 
/* 457 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 460 */     function = new JDBCFunctionMappingMetaData("length", new String[] { "{fn length(", ")}" }, new int[] { 0 });
/*     */ 
/* 466 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 469 */     function = new JDBCFunctionMappingMetaData("locate", new String[] { "{fn locate(", ", ", ", ", ")}" }, new int[] { 0, 1, 2 });
/*     */ 
/* 477 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 480 */     function = new JDBCFunctionMappingMetaData("abs", new String[] { "{fn abs(", ")}" }, new int[] { 0 });
/*     */ 
/* 486 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 489 */     function = new JDBCFunctionMappingMetaData("sqrt", new String[] { "{fn sqrt(", ")}" }, new int[] { 0 });
/*     */ 
/* 495 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */ 
/* 498 */     function = new JDBCFunctionMappingMetaData("mod", "mod(?1, ?2)");
/* 499 */     this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  73 */       COUNT_FUNC = new JDBCFunctionMappingMetaData("count", "count(?1 ?2)");
/*  74 */       MAX_FUNC = new JDBCFunctionMappingMetaData("max", "max(?1 ?2)");
/*  75 */       MIN_FUNC = new JDBCFunctionMappingMetaData("min", "min(?1 ?2)");
/*  76 */       AVG_FUNC = new JDBCFunctionMappingMetaData("avg", "avg(?1 ?2)");
/*  77 */       SUM_FUNC = new JDBCFunctionMappingMetaData("sum", "sum(?1 ?2)");
/*     */     }
/*     */     catch (DeploymentException e)
/*     */     {
/*  81 */       throw new IllegalStateException(e.getMessage());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData
 * JD-Core Version:    0.6.0
 */