/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JDBCReadAheadMetaData
/*     */ {
/*  44 */   public static final JDBCReadAheadMetaData DEFAULT = new JDBCReadAheadMetaData();
/*     */   private static final byte NONE = 0;
/*     */   private static final byte ON_LOAD = 1;
/*     */   private static final byte ON_FIND = 2;
/*  55 */   private static final List STRATEGIES = Arrays.asList(new String[] { "none", "on-load", "on-find" });
/*     */   private final byte strategy;
/*     */   private final int pageSize;
/*     */   private final String eagerLoadGroup;
/*     */   private final List leftJoinList;
/*     */ 
/*     */   private JDBCReadAheadMetaData()
/*     */   {
/*  74 */     this.strategy = 1;
/*  75 */     this.pageSize = 255;
/*  76 */     this.eagerLoadGroup = "*";
/*  77 */     this.leftJoinList = Collections.EMPTY_LIST;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData(String strategy, int pageSize, String eagerLoadGroup)
/*     */   {
/*  87 */     this(strategy, pageSize, eagerLoadGroup, Collections.EMPTY_LIST);
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData(String strategy, int pageSize, String eagerLoadGroup, List leftJoins)
/*     */   {
/*  92 */     this.strategy = (byte)STRATEGIES.indexOf(strategy);
/*  93 */     if (this.strategy < 0)
/*     */     {
/*  95 */       throw new IllegalArgumentException("Unknown read ahead strategy '" + strategy + "'.");
/*     */     }
/*  97 */     this.pageSize = pageSize;
/*  98 */     this.eagerLoadGroup = eagerLoadGroup;
/*  99 */     this.leftJoinList = leftJoins;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData(Element element, JDBCReadAheadMetaData defaultValue)
/*     */     throws DeploymentException
/*     */   {
/* 115 */     String strategyStr = MetaData.getUniqueChildContent(element, "strategy");
/* 116 */     this.strategy = (byte)STRATEGIES.indexOf(strategyStr);
/* 117 */     if (this.strategy < 0)
/*     */     {
/* 119 */       throw new DeploymentException("Unknown read ahead strategy '" + strategyStr + "'.");
/*     */     }
/*     */ 
/* 123 */     String pageSizeStr = MetaData.getOptionalChildContent(element, "page-size");
/* 124 */     if (pageSizeStr != null)
/*     */     {
/*     */       try
/*     */       {
/* 128 */         this.pageSize = Integer.parseInt(pageSizeStr);
/*     */       }
/*     */       catch (NumberFormatException ex)
/*     */       {
/* 132 */         throw new DeploymentException("Invalid number format in read-ahead page-size '" + pageSizeStr + "': " + ex);
/*     */       }
/* 134 */       if (this.pageSize < 0)
/*     */       {
/* 136 */         throw new DeploymentException("Negative value for read ahead page-size '" + pageSizeStr + "'.");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 141 */       this.pageSize = defaultValue.getPageSize();
/*     */     }
/*     */ 
/* 145 */     Element eagerLoadGroupElement = MetaData.getOptionalChild(element, "eager-load-group");
/* 146 */     if (eagerLoadGroupElement != null)
/*     */     {
/* 148 */       this.eagerLoadGroup = MetaData.getElementContent(eagerLoadGroupElement);
/*     */     }
/*     */     else
/*     */     {
/* 152 */       this.eagerLoadGroup = defaultValue.getEagerLoadGroup();
/*     */     }
/*     */ 
/* 156 */     Iterator iter = MetaData.getChildrenByTagName(element, "left-join");
/* 157 */     this.leftJoinList = JDBCLeftJoinMetaData.readLeftJoinList(iter);
/*     */   }
/*     */ 
/*     */   public boolean isNone()
/*     */   {
/* 165 */     return this.strategy == 0;
/*     */   }
/*     */ 
/*     */   public boolean isOnLoad()
/*     */   {
/* 173 */     return this.strategy == 1;
/*     */   }
/*     */ 
/*     */   public boolean isOnFind()
/*     */   {
/* 181 */     return this.strategy == 2;
/*     */   }
/*     */ 
/*     */   public int getPageSize()
/*     */   {
/* 189 */     return this.pageSize;
/*     */   }
/*     */ 
/*     */   public String getEagerLoadGroup()
/*     */   {
/* 197 */     return this.eagerLoadGroup;
/*     */   }
/*     */ 
/*     */   public Iterator getLeftJoins()
/*     */   {
/* 202 */     return this.leftJoinList.iterator();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 211 */     return "[JDBCReadAheadMetaData : strategy=" + STRATEGIES.get(this.strategy) + ", pageSize=" + this.pageSize + ", eagerLoadGroup=" + this.eagerLoadGroup + ", left-join" + this.leftJoinList + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData
 * JD-Core Version:    0.6.0
 */