/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.metadata.QueryMetaData;
/*     */ 
/*     */ public final class JDBCQlQueryMetaData
/*     */   implements JDBCQueryMetaData
/*     */ {
/*     */   private final Method method;
/*     */   private final String ejbQl;
/*     */   private final boolean resultTypeMappingLocal;
/*     */   private final JDBCReadAheadMetaData readAhead;
/*     */   private final Class compiler;
/*     */   private final boolean lazyResultSetLoading;
/*     */ 
/*     */   public JDBCQlQueryMetaData(QueryMetaData queryMetaData, Method method, Class qlCompiler, boolean lazyResultSetLoading)
/*     */   {
/*  70 */     this.method = method;
/*  71 */     this.readAhead = JDBCReadAheadMetaData.DEFAULT;
/*  72 */     this.ejbQl = queryMetaData.getEjbQl();
/*  73 */     this.resultTypeMappingLocal = queryMetaData.getResultTypeMapping().equals("Local");
/*     */ 
/*  75 */     this.compiler = qlCompiler;
/*  76 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public JDBCQlQueryMetaData(JDBCQlQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading)
/*     */   {
/*  88 */     this.method = defaults.getMethod();
/*  89 */     this.readAhead = readAhead;
/*  90 */     this.ejbQl = defaults.getEjbQl();
/*  91 */     this.resultTypeMappingLocal = defaults.resultTypeMappingLocal;
/*  92 */     this.compiler = compiler;
/*  93 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public JDBCQlQueryMetaData(JDBCQlQueryMetaData jdbcQueryMetaData, Method method, JDBCReadAheadMetaData readAhead)
/*     */   {
/* 105 */     this.method = method;
/* 106 */     this.readAhead = readAhead;
/* 107 */     this.ejbQl = jdbcQueryMetaData.getEjbQl();
/* 108 */     this.resultTypeMappingLocal = jdbcQueryMetaData.resultTypeMappingLocal;
/* 109 */     this.compiler = jdbcQueryMetaData.compiler;
/* 110 */     this.lazyResultSetLoading = jdbcQueryMetaData.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 116 */     return this.method;
/*     */   }
/*     */ 
/*     */   public Class getQLCompilerClass()
/*     */   {
/* 121 */     return this.compiler;
/*     */   }
/*     */ 
/*     */   public String getEjbQl()
/*     */   {
/* 131 */     return this.ejbQl;
/*     */   }
/*     */ 
/*     */   public boolean isResultTypeMappingLocal()
/*     */   {
/* 137 */     return this.resultTypeMappingLocal;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/* 147 */     return this.readAhead;
/*     */   }
/*     */ 
/*     */   public boolean isLazyResultSetLoading()
/*     */   {
/* 152 */     return this.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 166 */     if ((o instanceof JDBCQlQueryMetaData))
/*     */     {
/* 168 */       return ((JDBCQlQueryMetaData)o).method.equals(this.method);
/*     */     }
/* 170 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 181 */     return this.method.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 196 */     return "[JDBCQlQueryMetaData : method=" + this.method + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData
 * JD-Core Version:    0.6.0
 */