/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.sql.Types;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCMappingMetaData
/*     */ {
/*  42 */   private static Logger log = Logger.getLogger(JDBCMappingMetaData.class.getName());
/*     */   private final String javaType;
/*     */   private final int jdbcType;
/*     */   private final String sqlType;
/*     */   private final String paramSetter;
/*     */   private final String resultReader;
/*     */ 
/*     */   public static int getJdbcTypeFromName(String name)
/*     */     throws DeploymentException
/*     */   {
/*  54 */     if (name == null)
/*     */     {
/*  56 */       throw new DeploymentException("jdbc-type cannot be null");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  61 */       Integer constant = (Integer)Types.class.getField(name).get(null);
/*  62 */       return constant.intValue();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  67 */       log.warn("Unrecognized jdbc-type: " + name + ", using Types.OTHER", e);
/*  68 */     }return 1111;
/*     */   }
/*     */ 
/*     */   public JDBCMappingMetaData(Element element)
/*     */     throws DeploymentException
/*     */   {
/*  93 */     this.javaType = MetaData.getUniqueChildContent(element, "java-type");
/*  94 */     this.jdbcType = getJdbcTypeFromName(MetaData.getUniqueChildContent(element, "jdbc-type"));
/*  95 */     this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*  96 */     this.paramSetter = MetaData.getOptionalChildContent(element, "param-setter");
/*  97 */     this.resultReader = MetaData.getOptionalChildContent(element, "result-reader");
/*     */   }
/*     */ 
/*     */   public String getJavaType()
/*     */   {
/* 108 */     return this.javaType;
/*     */   }
/*     */ 
/*     */   public int getJdbcType()
/*     */   {
/* 119 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public String getSqlType()
/*     */   {
/* 130 */     return this.sqlType;
/*     */   }
/*     */ 
/*     */   public String getParamSetter()
/*     */   {
/* 135 */     return this.paramSetter;
/*     */   }
/*     */ 
/*     */   public String getResultReader()
/*     */   {
/* 140 */     return this.resultReader;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData
 * JD-Core Version:    0.6.0
 */