/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCLeftJoinMetaData
/*     */ {
/*     */   private final String cmrField;
/*     */   private final String eagerLoadGroup;
/*     */   private final List leftJoinList;
/*     */ 
/*     */   public static List readLeftJoinList(Iterator leftJoinIterator)
/*     */     throws DeploymentException
/*     */   {
/*  52 */     if (leftJoinIterator.hasNext())
/*     */     {
/*  54 */       List leftJoinList = new ArrayList();
/*  55 */       while (leftJoinIterator.hasNext())
/*     */       {
/*  57 */         Element leftJoinElement = (Element)leftJoinIterator.next();
/*  58 */         JDBCLeftJoinMetaData leftJoin = new JDBCLeftJoinMetaData(leftJoinElement);
/*  59 */         leftJoinList.add(leftJoin);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  64 */     List leftJoinList = Collections.EMPTY_LIST;
/*     */ 
/*  66 */     return leftJoinList;
/*     */   }
/*     */ 
/*     */   public JDBCLeftJoinMetaData(String cmrField, String eagerLoadGroup, List leftJoinList)
/*     */   {
/*  74 */     this.cmrField = cmrField;
/*  75 */     this.eagerLoadGroup = eagerLoadGroup;
/*  76 */     this.leftJoinList = leftJoinList;
/*     */   }
/*     */ 
/*     */   public JDBCLeftJoinMetaData(Element element) throws DeploymentException
/*     */   {
/*  81 */     this.cmrField = element.getAttribute("cmr-field");
/*  82 */     if ((this.cmrField == null) || (this.cmrField.trim().length() == 0))
/*     */     {
/*  84 */       throw new DeploymentException("left-join MUST have non-empty cmr-field attribute.");
/*     */     }
/*     */ 
/*  87 */     String eagerLoadGroup = element.getAttribute("eager-load-group");
/*  88 */     if ((eagerLoadGroup == null) || (eagerLoadGroup.trim().length() == 0))
/*     */     {
/*  90 */       this.eagerLoadGroup = "*";
/*     */     }
/*     */     else
/*     */     {
/*  94 */       this.eagerLoadGroup = eagerLoadGroup;
/*     */     }
/*     */ 
/*  97 */     Iterator leftJoinIterator = MetaData.getChildrenByTagName(element, "left-join");
/*  98 */     this.leftJoinList = readLeftJoinList(leftJoinIterator);
/*     */   }
/*     */ 
/*     */   public String getCmrField()
/*     */   {
/* 103 */     return this.cmrField;
/*     */   }
/*     */ 
/*     */   public String getEagerLoadGroup()
/*     */   {
/* 108 */     return this.eagerLoadGroup;
/*     */   }
/*     */ 
/*     */   public Iterator getLeftJoins()
/*     */   {
/* 113 */     return this.leftJoinList.iterator();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*     */     boolean result;
/*     */     boolean result;
/* 119 */     if (o == this)
/*     */     {
/* 121 */       result = true;
/*     */     }
/*     */     else
/*     */     {
/*     */       boolean result;
/* 123 */       if ((o instanceof JDBCLeftJoinMetaData))
/*     */       {
/* 125 */         JDBCLeftJoinMetaData other = (JDBCLeftJoinMetaData)o;
/* 126 */         result = (this.cmrField == null ? other.cmrField == null : this.cmrField.equals(other.cmrField)) && (this.eagerLoadGroup == null ? other.eagerLoadGroup == null : this.eagerLoadGroup.equals(other.eagerLoadGroup)) && (this.leftJoinList == null ? other.leftJoinList == null : this.leftJoinList.equals(other.leftJoinList));
/*     */       }
/*     */       else
/*     */       {
/* 133 */         result = false;
/*     */       }
/*     */     }
/* 135 */     return result;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 140 */     int result = -2147483648;
/* 141 */     result += (this.cmrField == null ? 0 : this.cmrField.hashCode());
/* 142 */     result += (this.eagerLoadGroup == null ? 0 : this.eagerLoadGroup.hashCode());
/* 143 */     result += (this.leftJoinList == null ? 0 : this.leftJoinList.hashCode());
/* 144 */     return result;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 149 */     return "[cmr-field=" + this.cmrField + ", eager-load-group=" + this.eagerLoadGroup + ", left-join=" + this.leftJoinList + ']';
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCLeftJoinMetaData
 * JD-Core Version:    0.6.0
 */