/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCJBossQLQueryMetaData
/*     */   implements JDBCQueryMetaData
/*     */ {
/*     */   private final Method method;
/*     */   private final String jbossQL;
/*     */   private final boolean resultTypeMappingLocal;
/*     */   private final JDBCReadAheadMetaData readAhead;
/*     */   private final Class compiler;
/*     */   private final boolean lazyResultSetLoading;
/*     */ 
/*     */   public JDBCJBossQLQueryMetaData(JDBCJBossQLQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class qlCompiler, boolean lazyResultSetLoading)
/*     */     throws DeploymentException
/*     */   {
/*  72 */     this.method = defaults.getMethod();
/*  73 */     this.readAhead = readAhead;
/*  74 */     this.jbossQL = defaults.getJBossQL();
/*  75 */     this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
/*  76 */     this.compiler = qlCompiler;
/*  77 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public JDBCJBossQLQueryMetaData(boolean resultTypeMappingLocal, Element element, Method method, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading)
/*     */     throws DeploymentException
/*     */   {
/*  92 */     this.method = method;
/*  93 */     this.readAhead = readAhead;
/*  94 */     this.jbossQL = MetaData.getElementContent(element);
/*  95 */     if ((this.jbossQL == null) || (this.jbossQL.trim().length() == 0))
/*     */     {
/*  97 */       throw new DeploymentException("jboss-ql element is empty");
/*     */     }
/*  99 */     this.resultTypeMappingLocal = resultTypeMappingLocal;
/* 100 */     this.compiler = compiler;
/* 101 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 107 */     return this.method;
/*     */   }
/*     */ 
/*     */   public Class getQLCompilerClass()
/*     */   {
/* 112 */     return this.compiler;
/*     */   }
/*     */ 
/*     */   public String getJBossQL()
/*     */   {
/* 122 */     return this.jbossQL;
/*     */   }
/*     */ 
/*     */   public boolean isResultTypeMappingLocal()
/*     */   {
/* 128 */     return this.resultTypeMappingLocal;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/* 138 */     return this.readAhead;
/*     */   }
/*     */ 
/*     */   public boolean isLazyResultSetLoading()
/*     */   {
/* 143 */     return this.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 157 */     if ((o instanceof JDBCJBossQLQueryMetaData))
/*     */     {
/* 159 */       return ((JDBCJBossQLQueryMetaData)o).method.equals(this.method);
/*     */     }
/* 161 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 172 */     return this.method.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 187 */     return "[JDBCJBossQLQueryMetaData : method=" + this.method + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData
 * JD-Core Version:    0.6.0
 */