/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.StringReader;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCFunctionMappingMetaData
/*     */ {
/*     */   private final String functionName;
/*     */   private String[] sqlChunks;
/*     */   private int[] parameters;
/*     */ 
/*     */   public JDBCFunctionMappingMetaData(String functionName, String[] sqlChunks, int[] parameters)
/*     */   {
/*  40 */     this.functionName = functionName;
/*  41 */     this.sqlChunks = sqlChunks;
/*  42 */     this.parameters = parameters;
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData(Element element) throws DeploymentException
/*     */   {
/*  47 */     this.functionName = MetaData.getUniqueChildContent(element, "function-name");
/*     */ 
/*  49 */     String sql = MetaData.getUniqueChildContent(element, "function-sql");
/*  50 */     initFromString(sql);
/*     */   }
/*     */ 
/*     */   public JDBCFunctionMappingMetaData(String functionName, String sql) throws DeploymentException
/*     */   {
/*  55 */     this.functionName = functionName;
/*  56 */     initFromString(sql);
/*     */   }
/*     */ 
/*     */   private void initFromString(String sql) throws DeploymentException
/*     */   {
/*  61 */     ArrayList chunkList = new ArrayList();
/*  62 */     ArrayList parameterList = new ArrayList();
/*     */ 
/*  65 */     if (sql.charAt(0) == '?')
/*     */     {
/*  67 */       chunkList.add("");
/*     */     }
/*     */ 
/*  70 */     StringBuffer chunk = new StringBuffer();
/*  71 */     StringReader reader = new StringReader(sql);
/*     */     try
/*     */     {
/*  74 */       for (int c = reader.read(); c >= 0; c = reader.read())
/*     */       {
/*  76 */         if (c != 63)
/*     */         {
/*  78 */           chunk.append((char)c);
/*     */         }
/*     */         else
/*     */         {
/*  82 */           chunkList.add(chunk.toString());
/*  83 */           chunk = new StringBuffer();
/*     */ 
/*  86 */           StringBuffer number = new StringBuffer();
/*  87 */           for (int digit = reader.read(); digit >= 0; digit = reader.read())
/*     */           {
/*  89 */             if (Character.isDigit((char)digit))
/*     */             {
/*  91 */               number.append((char)digit);
/*     */             }
/*     */             else
/*     */             {
/*  95 */               if (digit < 0)
/*     */                 break;
/*  97 */               chunk.append((char)digit); break;
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 102 */           if (number.length() == 0)
/*     */           {
/* 104 */             throw new DeploymentException("Invalid parameter in function-sql: " + sql);
/*     */           }
/*     */           Integer parameter;
/*     */           try {
/* 109 */             parameter = new Integer(number.toString());
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 113 */             throw new DeploymentException("Invalid parameter number in function-sql: number=" + number + " sql=" + sql);
/*     */           }
/* 115 */           parameterList.add(parameter);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 122 */       throw new DeploymentException("Error parsing function-sql: " + sql);
/*     */     }
/* 124 */     chunkList.add(chunk.toString());
/*     */ 
/* 127 */     this.sqlChunks = new String[chunkList.size()];
/* 128 */     chunkList.toArray(this.sqlChunks);
/*     */ 
/* 131 */     this.parameters = new int[parameterList.size()];
/* 132 */     for (int i = 0; i < this.parameters.length; i++)
/*     */     {
/* 134 */       this.parameters[i] = (((Integer)parameterList.get(i)).intValue() - 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getFunctionName()
/*     */   {
/* 140 */     return this.functionName;
/*     */   }
/*     */ 
/*     */   public StringBuffer getFunctionSql(Object[] args, StringBuffer buf)
/*     */   {
/* 145 */     for (int i = 0; i < this.sqlChunks.length; i++)
/*     */     {
/* 147 */       if (i < this.parameters.length)
/*     */       {
/* 152 */         Object arg = args[this.parameters[i]];
/* 153 */         if (arg != null)
/*     */         {
/* 155 */           buf.append(this.sqlChunks[i]);
/* 156 */           buf.append(arg);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 162 */         buf.append(this.sqlChunks[i]);
/*     */       }
/*     */     }
/* 165 */     return buf;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData
 * JD-Core Version:    0.6.0
 */