/*      */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.ObjectName;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.metadata.MetaData;
/*      */ import org.jboss.metadata.QueryMetaData;
/*      */ import org.jboss.mx.util.MBeanServerLocator;
/*      */ import org.w3c.dom.Element;
/*      */ 
/*      */ public final class JDBCEntityMetaData
/*      */ {
/*      */   private final JDBCApplicationMetaData jdbcApplication;
/*      */   private final String dataSourceName;
/*      */   private final String datasourceMappingName;
/*      */   private final JDBCTypeMappingMetaData datasourceMapping;
/*      */   private final String entityName;
/*      */   private final String abstractSchemaName;
/*      */   private final Class entityClass;
/*      */   private final Class homeClass;
/*      */   private final Class remoteClass;
/*      */   private final Class localHomeClass;
/*      */   private final Class localClass;
/*      */   private final boolean isCMP1x;
/*      */   private final String tableName;
/*      */   private final boolean createTable;
/*      */   private final boolean removeTable;
/*      */   private final boolean alterTable;
/*      */   private final ArrayList tablePostCreateCmd;
/*      */   private final boolean rowLocking;
/*      */   private final boolean readOnly;
/*      */   private final int readTimeOut;
/*      */   private final boolean primaryKeyConstraint;
/*      */   private final Class primaryKeyClass;
/*      */   private final String primaryKeyFieldName;
/*  178 */   private final Map cmpFieldsByName = new HashMap();
/*  179 */   private final List cmpFields = new ArrayList();
/*      */ 
/*  184 */   private final Map loadGroups = new HashMap();
/*      */   private final String eagerLoadGroup;
/*  196 */   private final List lazyLoadGroups = new ArrayList();
/*      */ 
/*  201 */   private final Map queries = new HashMap();
/*      */   private final JDBCQueryMetaDataFactory queryFactory;
/*      */   private final JDBCReadAheadMetaData readAhead;
/*      */   private final boolean cleanReadAheadOnLoad;
/*      */   private final int listCacheMax;
/*      */   private final int fetchSize;
/*      */   private final JDBCEntityCommandMetaData entityCommand;
/*      */   private final JDBCOptimisticLockingMetaData optimisticLocking;
/*      */   private final JDBCAuditMetaData audit;
/*      */   private final Class qlCompiler;
/*      */   private final boolean throwRuntimeExceptions;
/*      */ 
/*      */   public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, EntityMetaData entity)
/*      */     throws DeploymentException
/*      */   {
/*  274 */     this.jdbcApplication = jdbcApplication;
/*  275 */     this.entityName = entity.getEjbName();
/*  276 */     this.listCacheMax = 1000;
/*  277 */     this.fetchSize = 0;
/*      */     try
/*      */     {
/*  281 */       this.entityClass = getClassLoader().loadClass(entity.getEjbClass());
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  285 */       throw new DeploymentException("entity class not found for ejb-name: " + this.entityName, e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  290 */       this.primaryKeyClass = getClassLoader().loadClass(entity.getPrimaryKeyClass());
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  294 */       throw new DeploymentException("could not load primary key class: " + entity.getPrimaryKeyClass());
/*      */     }
/*      */ 
/*  300 */     this.isCMP1x = entity.isCMP1x();
/*  301 */     if (this.isCMP1x)
/*      */     {
/*  303 */       this.abstractSchemaName = (entity.getAbstractSchemaName() == null ? this.entityName : entity.getAbstractSchemaName());
/*      */     }
/*      */     else
/*      */     {
/*  307 */       this.abstractSchemaName = entity.getAbstractSchemaName();
/*      */     }
/*      */ 
/*  310 */     this.primaryKeyFieldName = entity.getPrimKeyField();
/*      */ 
/*  312 */     String home = entity.getHome();
/*  313 */     if (home != null)
/*      */     {
/*      */       try
/*      */       {
/*  317 */         this.homeClass = getClassLoader().loadClass(home);
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  321 */         throw new DeploymentException("home class not found: " + home);
/*      */       }
/*      */       try
/*      */       {
/*  325 */         this.remoteClass = getClassLoader().loadClass(entity.getRemote());
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  329 */         throw new DeploymentException("remote class not found: " + entity.getRemote());
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  337 */       this.homeClass = null;
/*  338 */       this.remoteClass = null;
/*      */     }
/*      */ 
/*  341 */     String localHome = entity.getLocalHome();
/*  342 */     if (localHome != null)
/*      */     {
/*      */       try
/*      */       {
/*  346 */         this.localHomeClass = getClassLoader().loadClass(localHome);
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  350 */         throw new DeploymentException("local home class not found: " + localHome);
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  357 */         this.localClass = getClassLoader().loadClass(entity.getLocal());
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  361 */         throw new DeploymentException("local class not found: " + entity.getLocal());
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  370 */       if (home == null)
/*      */       {
/*  372 */         throw new DeploymentException("Entity must have atleast a home or local home: " + this.entityName);
/*      */       }
/*      */ 
/*  378 */       this.localHomeClass = null;
/*  379 */       this.localClass = null;
/*      */     }
/*      */ 
/*  384 */     this.tableName = this.entityName.replace('.', '_');
/*      */ 
/*  388 */     this.dataSourceName = null;
/*  389 */     this.datasourceMappingName = null;
/*  390 */     this.datasourceMapping = null;
/*  391 */     this.createTable = false;
/*  392 */     this.removeTable = false;
/*  393 */     this.alterTable = false;
/*  394 */     this.rowLocking = false;
/*  395 */     this.primaryKeyConstraint = false;
/*  396 */     this.readOnly = false;
/*  397 */     this.readTimeOut = -1;
/*  398 */     this.tablePostCreateCmd = null;
/*  399 */     this.qlCompiler = null;
/*  400 */     this.throwRuntimeExceptions = false;
/*      */ 
/*  404 */     List nonPkFieldNames = new ArrayList();
/*  405 */     for (Iterator i = entity.getCMPFields(); i.hasNext(); )
/*      */     {
/*  407 */       String cmpFieldName = (String)i.next();
/*  408 */       JDBCCMPFieldMetaData cmpField = new JDBCCMPFieldMetaData(this, cmpFieldName);
/*  409 */       this.cmpFields.add(cmpField);
/*  410 */       this.cmpFieldsByName.put(cmpFieldName, cmpField);
/*  411 */       if (!cmpField.isPrimaryKeyMember())
/*      */       {
/*  413 */         nonPkFieldNames.add(cmpFieldName);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  421 */     if (this.primaryKeyClass == Object.class)
/*      */     {
/*  423 */       JDBCCMPFieldMetaData upkField = new JDBCCMPFieldMetaData(this);
/*  424 */       this.cmpFields.add(upkField);
/*  425 */       this.cmpFieldsByName.put(upkField.getFieldName(), upkField);
/*      */     }
/*      */ 
/*  429 */     this.eagerLoadGroup = "*";
/*      */ 
/*  434 */     this.queryFactory = new JDBCQueryMetaDataFactory(this);
/*      */ 
/*  436 */     for (Iterator queriesIterator = entity.getQueries(); queriesIterator.hasNext(); )
/*      */     {
/*  438 */       QueryMetaData queryData = (QueryMetaData)queriesIterator.next();
/*  439 */       Map newQueries = this.queryFactory.createJDBCQueryMetaData(queryData);
/*      */ 
/*  441 */       this.queries.putAll(newQueries);
/*      */     }
/*      */ 
/*  447 */     this.readAhead = JDBCReadAheadMetaData.DEFAULT;
/*  448 */     this.cleanReadAheadOnLoad = false;
/*  449 */     this.entityCommand = null;
/*  450 */     this.optimisticLocking = null;
/*  451 */     this.audit = null;
/*      */   }
/*      */ 
/*      */   public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, Element element, JDBCEntityMetaData defaultValues)
/*      */     throws DeploymentException
/*      */   {
/*  473 */     this.jdbcApplication = jdbcApplication;
/*      */ 
/*  476 */     this.entityName = defaultValues.getName();
/*  477 */     this.entityClass = defaultValues.getEntityClass();
/*  478 */     this.primaryKeyClass = defaultValues.getPrimaryKeyClass();
/*  479 */     this.isCMP1x = defaultValues.isCMP1x;
/*  480 */     this.primaryKeyFieldName = defaultValues.getPrimaryKeyFieldName();
/*  481 */     this.homeClass = defaultValues.getHomeClass();
/*  482 */     this.remoteClass = defaultValues.getRemoteClass();
/*  483 */     this.localHomeClass = defaultValues.getLocalHomeClass();
/*  484 */     this.localClass = defaultValues.getLocalClass();
/*  485 */     this.queryFactory = new JDBCQueryMetaDataFactory(this);
/*      */ 
/*  487 */     if (this.isCMP1x)
/*      */     {
/*  489 */       this.abstractSchemaName = (defaultValues.getAbstractSchemaName() == null ? this.entityName : defaultValues.getAbstractSchemaName());
/*      */     }
/*      */     else
/*      */     {
/*  494 */       this.abstractSchemaName = defaultValues.getAbstractSchemaName();
/*      */     }
/*      */ 
/*  498 */     String dataSourceNameString = MetaData.getOptionalChildContent(element, "datasource");
/*  499 */     if (dataSourceNameString != null)
/*      */     {
/*  501 */       this.dataSourceName = dataSourceNameString;
/*      */     }
/*      */     else
/*      */     {
/*  505 */       this.dataSourceName = defaultValues.getDataSourceName();
/*      */     }
/*      */ 
/*  510 */     String datasourceMappingString = MetaData.getOptionalChildContent(element, "datasource-mapping");
/*  511 */     if (datasourceMappingString != null)
/*      */     {
/*  513 */       this.datasourceMappingName = datasourceMappingString;
/*  514 */       this.datasourceMapping = jdbcApplication.getTypeMappingByName(datasourceMappingString);
/*  515 */       if (this.datasourceMapping == null)
/*      */       {
/*  517 */         throw new DeploymentException("Error in jbosscmp-jdbc.xml : datasource-mapping " + datasourceMappingString + " not found");
/*      */       }
/*      */ 
/*      */     }
/*  526 */     else if ((defaultValues.datasourceMappingName != null) && (defaultValues.datasourceMapping != null))
/*      */     {
/*  528 */       this.datasourceMappingName = null;
/*  529 */       this.datasourceMapping = defaultValues.datasourceMapping;
/*      */     }
/*      */     else
/*      */     {
/*  533 */       this.datasourceMappingName = null;
/*  534 */       this.datasourceMapping = obtainTypeMappingFromLibrary(this.dataSourceName);
/*      */     }
/*      */ 
/*  538 */     String tableStr = MetaData.getOptionalChildContent(element, "table-name");
/*  539 */     if (tableStr != null)
/*      */     {
/*  541 */       this.tableName = tableStr;
/*      */     }
/*      */     else
/*      */     {
/*  545 */       this.tableName = defaultValues.getDefaultTableName();
/*      */     }
/*      */ 
/*  549 */     String createStr = MetaData.getOptionalChildContent(element, "create-table");
/*  550 */     if (createStr != null)
/*      */     {
/*  552 */       this.createTable = Boolean.valueOf(createStr).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/*  556 */       this.createTable = defaultValues.getCreateTable();
/*      */     }
/*      */ 
/*  560 */     String removeStr = MetaData.getOptionalChildContent(element, "remove-table");
/*  561 */     if (removeStr != null)
/*      */     {
/*  563 */       this.removeTable = Boolean.valueOf(removeStr).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/*  567 */       this.removeTable = defaultValues.getRemoveTable();
/*      */     }
/*      */ 
/*  571 */     String alterStr = MetaData.getOptionalChildContent(element, "alter-table");
/*  572 */     if (alterStr != null)
/*      */     {
/*  574 */       this.alterTable = Boolean.valueOf(alterStr).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/*  578 */       this.alterTable = defaultValues.getAlterTable();
/*      */     }
/*      */ 
/*  583 */     Element posttc = MetaData.getOptionalChild(element, "post-table-create");
/*  584 */     if (posttc != null)
/*      */     {
/*  586 */       Iterator it = MetaData.getChildrenByTagName(posttc, "sql-statement");
/*  587 */       this.tablePostCreateCmd = new ArrayList();
/*  588 */       while (it.hasNext())
/*      */       {
/*  590 */         Element etmp = (Element)it.next();
/*  591 */         this.tablePostCreateCmd.add(MetaData.getElementContent(etmp));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  596 */       this.tablePostCreateCmd = defaultValues.getDefaultTablePostCreateCmd();
/*      */     }
/*      */ 
/*  600 */     String readOnlyStr = MetaData.getOptionalChildContent(element, "read-only");
/*  601 */     if (readOnlyStr != null)
/*      */     {
/*  603 */       this.readOnly = Boolean.valueOf(readOnlyStr).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/*  607 */       this.readOnly = defaultValues.isReadOnly();
/*      */     }
/*      */ 
/*  611 */     String readTimeOutStr = MetaData.getOptionalChildContent(element, "read-time-out");
/*  612 */     if (readTimeOutStr != null)
/*      */     {
/*      */       try
/*      */       {
/*  616 */         this.readTimeOut = Integer.parseInt(readTimeOutStr);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/*  620 */         throw new DeploymentException("Invalid number format in read-time-out '" + readTimeOutStr + "': " + e);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  628 */       this.readTimeOut = defaultValues.getReadTimeOut();
/*      */     }
/*      */ 
/*  631 */     String sForUpStr = MetaData.getOptionalChildContent(element, "row-locking");
/*  632 */     if (sForUpStr != null)
/*      */     {
/*  634 */       this.rowLocking = ((!isReadOnly()) && (Boolean.valueOf(sForUpStr).booleanValue()));
/*      */     }
/*      */     else
/*      */     {
/*  638 */       this.rowLocking = defaultValues.hasRowLocking();
/*      */     }
/*      */ 
/*  642 */     String pkStr = MetaData.getOptionalChildContent(element, "pk-constraint");
/*  643 */     if (pkStr != null)
/*      */     {
/*  645 */       this.primaryKeyConstraint = Boolean.valueOf(pkStr).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/*  649 */       this.primaryKeyConstraint = defaultValues.hasPrimaryKeyConstraint();
/*      */     }
/*      */ 
/*  653 */     String listCacheMaxStr = MetaData.getOptionalChildContent(element, "list-cache-max");
/*  654 */     if (listCacheMaxStr != null)
/*      */     {
/*      */       try
/*      */       {
/*  658 */         this.listCacheMax = Integer.parseInt(listCacheMaxStr);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/*  662 */         throw new DeploymentException("Invalid number format in read-ahead list-cache-max '" + listCacheMaxStr + "': " + e);
/*      */       }
/*      */ 
/*  667 */       if (this.listCacheMax < 0)
/*      */       {
/*  669 */         throw new DeploymentException("Negative value for read ahead list-cache-max '" + listCacheMaxStr + "'.");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  677 */       this.listCacheMax = defaultValues.getListCacheMax();
/*      */     }
/*      */ 
/*  681 */     String fetchSizeStr = MetaData.getOptionalChildContent(element, "fetch-size");
/*  682 */     if (fetchSizeStr != null)
/*      */     {
/*      */       try
/*      */       {
/*  686 */         this.fetchSize = Integer.parseInt(fetchSizeStr);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/*  690 */         throw new DeploymentException("Invalid number format in fetch-size '" + fetchSizeStr + "': " + e);
/*      */       }
/*      */ 
/*  695 */       if (this.fetchSize < 0)
/*      */       {
/*  697 */         throw new DeploymentException("Negative value for fetch size fetch-size '" + fetchSizeStr + "'.");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  705 */       this.fetchSize = defaultValues.getFetchSize();
/*      */     }
/*      */ 
/*  708 */     String compiler = MetaData.getOptionalChildContent(element, "ql-compiler");
/*  709 */     if (compiler == null)
/*      */     {
/*  711 */       this.qlCompiler = defaultValues.qlCompiler;
/*      */     }
/*      */     else
/*      */     {
/*      */       try
/*      */       {
/*  717 */         this.qlCompiler = GetTCLAction.getContextClassLoader().loadClass(compiler);
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  721 */         throw new DeploymentException("Failed to load compiler implementation: " + compiler);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  726 */     String throwRuntimeExceptionsStr = MetaData.getOptionalChildContent(element, "throw-runtime-exceptions");
/*  727 */     if (throwRuntimeExceptionsStr != null)
/*      */     {
/*  729 */       this.throwRuntimeExceptions = Boolean.valueOf(throwRuntimeExceptionsStr).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/*  733 */       this.throwRuntimeExceptions = defaultValues.getThrowRuntimeExceptions();
/*      */     }
/*      */ 
/*  742 */     Iterator cmpFieldIterator = defaultValues.cmpFields.iterator();
/*  743 */     while (cmpFieldIterator.hasNext())
/*      */     {
/*  746 */       JDBCCMPFieldMetaData cmpField = new JDBCCMPFieldMetaData(this, (JDBCCMPFieldMetaData)cmpFieldIterator.next());
/*  747 */       this.cmpFields.add(cmpField);
/*  748 */       this.cmpFieldsByName.put(cmpField.getFieldName(), cmpField);
/*      */     }
/*      */ 
/*  752 */     for (Iterator i = MetaData.getChildrenByTagName(element, "cmp-field"); i.hasNext(); )
/*      */     {
/*  754 */       Element cmpFieldElement = (Element)i.next();
/*  755 */       String fieldName = MetaData.getUniqueChildContent(cmpFieldElement, "field-name");
/*      */ 
/*  757 */       JDBCCMPFieldMetaData oldCMPField = (JDBCCMPFieldMetaData)this.cmpFieldsByName.get(fieldName);
/*  758 */       if (oldCMPField == null)
/*      */       {
/*  760 */         throw new DeploymentException("CMP field not found : fieldName=" + fieldName);
/*      */       }
/*  762 */       JDBCCMPFieldMetaData cmpFieldMetaData = new JDBCCMPFieldMetaData(this, cmpFieldElement, oldCMPField);
/*      */ 
/*  769 */       this.cmpFieldsByName.put(fieldName, cmpFieldMetaData);
/*  770 */       int index = this.cmpFields.indexOf(oldCMPField);
/*  771 */       this.cmpFields.remove(oldCMPField);
/*  772 */       this.cmpFields.add(index, cmpFieldMetaData);
/*      */     }
/*      */ 
/*  776 */     if (this.primaryKeyClass == Object.class)
/*      */     {
/*  778 */       Element upkElement = MetaData.getOptionalChild(element, "unknown-pk");
/*  779 */       if (upkElement != null)
/*      */       {
/*  782 */         JDBCCMPFieldMetaData oldUpkField = null;
/*  783 */         for (Iterator iter = this.cmpFields.iterator(); iter.hasNext(); )
/*      */         {
/*  785 */           JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)iter.next();
/*  786 */           if (cmpField.isUnknownPkField())
/*      */           {
/*  788 */             oldUpkField = cmpField;
/*  789 */             break;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  794 */         if (oldUpkField == null)
/*      */         {
/*  796 */           oldUpkField = new JDBCCMPFieldMetaData(this);
/*      */         }
/*      */ 
/*  799 */         JDBCCMPFieldMetaData upkField = new JDBCCMPFieldMetaData(this, upkElement, oldUpkField);
/*      */ 
/*  802 */         this.cmpFieldsByName.remove(oldUpkField.getFieldName());
/*  803 */         this.cmpFieldsByName.put(upkField.getFieldName(), upkField);
/*      */ 
/*  805 */         int oldUpkFieldInd = this.cmpFields.indexOf(oldUpkField);
/*  806 */         this.cmpFields.remove(oldUpkField);
/*  807 */         this.cmpFields.add(oldUpkFieldInd, upkField);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  812 */     this.loadGroups.putAll(defaultValues.loadGroups);
/*  813 */     loadLoadGroupsXml(element);
/*      */ 
/*  816 */     Element eagerLoadGroupElement = MetaData.getOptionalChild(element, "eager-load-group");
/*  817 */     if (eagerLoadGroupElement != null)
/*      */     {
/*  819 */       String eagerLoadGroupTmp = MetaData.getElementContent(eagerLoadGroupElement);
/*  820 */       if ((eagerLoadGroupTmp != null) && (eagerLoadGroupTmp.trim().length() == 0))
/*      */       {
/*  822 */         eagerLoadGroupTmp = null;
/*      */       }
/*  824 */       if ((eagerLoadGroupTmp != null) && (!eagerLoadGroupTmp.equals("*")) && (!this.loadGroups.containsKey(eagerLoadGroupTmp)))
/*      */       {
/*  828 */         throw new DeploymentException("Eager load group not found: eager-load-group=" + eagerLoadGroupTmp);
/*      */       }
/*      */ 
/*  833 */       this.eagerLoadGroup = eagerLoadGroupTmp;
/*      */     }
/*      */     else
/*      */     {
/*  837 */       this.eagerLoadGroup = defaultValues.getEagerLoadGroup();
/*      */     }
/*      */ 
/*  841 */     this.lazyLoadGroups.addAll(defaultValues.lazyLoadGroups);
/*  842 */     loadLazyLoadGroupsXml(element);
/*      */ 
/*  845 */     Element readAheadElement = MetaData.getOptionalChild(element, "read-ahead");
/*  846 */     if (readAheadElement != null)
/*      */     {
/*  848 */       this.readAhead = new JDBCReadAheadMetaData(readAheadElement, defaultValues.getReadAhead());
/*      */     }
/*      */     else
/*      */     {
/*  852 */       this.readAhead = defaultValues.readAhead;
/*      */     }
/*      */ 
/*  855 */     String value = MetaData.getOptionalChildContent(element, "clean-read-ahead-on-load");
/*  856 */     if ("true".equalsIgnoreCase(value))
/*      */     {
/*  858 */       this.cleanReadAheadOnLoad = true;
/*      */     }
/*  860 */     else if ("false".equalsIgnoreCase(value))
/*      */     {
/*  862 */       this.cleanReadAheadOnLoad = false;
/*      */     }
/*  864 */     else if (value == null)
/*      */     {
/*  866 */       this.cleanReadAheadOnLoad = defaultValues.cleanReadAheadOnLoad;
/*      */     }
/*      */     else
/*      */     {
/*  870 */       throw new DeploymentException("Failed to deploy " + this.entityName + ": allowed values for clean-read-ahead-on-load are true and false but got " + value);
/*      */     }
/*      */ 
/*  875 */     Element optimisticLockingEl = MetaData.getOptionalChild(element, "optimistic-locking");
/*  876 */     if (optimisticLockingEl != null)
/*      */     {
/*  878 */       this.optimisticLocking = new JDBCOptimisticLockingMetaData(this, optimisticLockingEl);
/*      */     }
/*      */     else
/*      */     {
/*  882 */       this.optimisticLocking = defaultValues.getOptimisticLocking();
/*      */     }
/*      */ 
/*  886 */     Element auditElement = MetaData.getOptionalChild(element, "audit");
/*  887 */     if (auditElement != null)
/*      */     {
/*  889 */       this.audit = new JDBCAuditMetaData(this, auditElement);
/*      */     }
/*      */     else
/*      */     {
/*  893 */       this.audit = defaultValues.getAudit();
/*      */     }
/*      */ 
/*  899 */     Iterator queriesIterator = defaultValues.queries.values().iterator();
/*  900 */     while (queriesIterator.hasNext())
/*      */     {
/*  902 */       JDBCQueryMetaData query = JDBCQueryMetaDataFactory.createJDBCQueryMetaData((JDBCQueryMetaData)queriesIterator.next(), this.readAhead, this.qlCompiler);
/*      */ 
/*  906 */       this.queries.put(query.getMethod(), query);
/*      */     }
/*      */ 
/*  910 */     Iterator queriesIterator = MetaData.getChildrenByTagName(element, "query");
/*  911 */     while (queriesIterator.hasNext())
/*      */     {
/*  913 */       Element queryElement = (Element)queriesIterator.next();
/*  914 */       Map newQueries = this.queryFactory.createJDBCQueryMetaData(queryElement, defaultValues.queries, this.readAhead);
/*      */ 
/*  921 */       this.queries.putAll(newQueries);
/*      */     }
/*      */ 
/*  925 */     Element entityCommandEl = MetaData.getOptionalChild(element, "entity-command");
/*  926 */     if (entityCommandEl != null)
/*      */     {
/*  929 */       String entityCommandName = entityCommandEl.getAttribute("name");
/*      */ 
/*  940 */       JDBCEntityCommandMetaData defaultEntityCommand = defaultValues.getEntityCommand();
/*      */ 
/*  942 */       if ((defaultEntityCommand == null) || (!entityCommandName.equals(defaultEntityCommand.getCommandName())))
/*      */       {
/*  945 */         defaultEntityCommand = jdbcApplication.getEntityCommandByName(entityCommandName);
/*      */       }
/*      */ 
/*  948 */       if (defaultEntityCommand != null)
/*      */       {
/*  950 */         this.entityCommand = new JDBCEntityCommandMetaData(entityCommandEl, defaultEntityCommand);
/*      */       }
/*      */       else
/*      */       {
/*  954 */         this.entityCommand = new JDBCEntityCommandMetaData(entityCommandEl);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  959 */       this.entityCommand = defaultValues.getEntityCommand();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void loadLoadGroupsXml(Element element)
/*      */     throws DeploymentException
/*      */   {
/*  970 */     Element loadGroupsElement = MetaData.getOptionalChild(element, "load-groups");
/*  971 */     if (loadGroupsElement == null)
/*      */     {
/*  974 */       return;
/*      */     }
/*      */ 
/*  978 */     if (this.isCMP1x)
/*      */     {
/*  980 */       throw new DeploymentException("load-groups are only allowed for CMP 2.x");
/*      */     }
/*      */ 
/*  987 */     Iterator groups = MetaData.getChildrenByTagName(loadGroupsElement, "load-group");
/*  988 */     while (groups.hasNext())
/*      */     {
/*  990 */       Element groupElement = (Element)groups.next();
/*      */ 
/*  993 */       String loadGroupName = MetaData.getUniqueChildContent(groupElement, "load-group-name");
/*  994 */       if (this.loadGroups.containsKey(loadGroupName))
/*      */       {
/*  996 */         throw new DeploymentException("Load group already defined:  load-group-name=" + loadGroupName);
/*      */       }
/*      */ 
/* 1001 */       if (loadGroupName.equals("*"))
/*      */       {
/* 1003 */         throw new DeploymentException("The * load group is automatically defined and can't be overriden");
/*      */       }
/*      */ 
/* 1008 */       ArrayList group = new ArrayList();
/*      */ 
/* 1011 */       Iterator fields = MetaData.getChildrenByTagName(groupElement, "field-name");
/* 1012 */       while (fields.hasNext())
/*      */       {
/* 1014 */         String fieldName = MetaData.getElementContent((Element)fields.next());
/*      */ 
/* 1017 */         JDBCCMPFieldMetaData field = getCMPFieldByName(fieldName);
/* 1018 */         if ((field != null) && (field.isPrimaryKeyMember()))
/*      */         {
/* 1020 */           throw new DeploymentException("Primary key fields can not be a member of a load group:  load-group-name=" + loadGroupName + " field-name=" + fieldName);
/*      */         }
/*      */ 
/* 1031 */         group.add(fieldName);
/*      */       }
/*      */ 
/* 1034 */       this.loadGroups.put(loadGroupName, Collections.unmodifiableList(group));
/*      */     }
/*      */   }
/*      */ 
/*      */   private void loadLazyLoadGroupsXml(Element element)
/*      */     throws DeploymentException
/*      */   {
/* 1044 */     Element lazyLoadGroupsElement = MetaData.getOptionalChild(element, "lazy-load-groups");
/*      */ 
/* 1047 */     if (lazyLoadGroupsElement == null)
/*      */     {
/* 1049 */       return;
/*      */     }
/*      */ 
/* 1053 */     if (this.isCMP1x)
/*      */     {
/* 1055 */       throw new DeploymentException("lazy-load-groups is only allowed for CMP 2.x");
/*      */     }
/*      */ 
/* 1059 */     Iterator loadGroupNames = MetaData.getChildrenByTagName(lazyLoadGroupsElement, "load-group-name");
/* 1060 */     while (loadGroupNames.hasNext())
/*      */     {
/* 1062 */       String loadGroupName = MetaData.getElementContent((Element)loadGroupNames.next());
/* 1063 */       if ((!loadGroupName.equals("*")) && (!this.loadGroups.containsKey(loadGroupName)))
/*      */       {
/* 1065 */         throw new DeploymentException("Lazy load group not found: load-group-name=" + loadGroupName);
/*      */       }
/*      */ 
/* 1071 */       this.lazyLoadGroups.add(loadGroupName);
/*      */     }
/*      */   }
/*      */ 
/*      */   public JDBCApplicationMetaData getJDBCApplication()
/*      */   {
/* 1083 */     return this.jdbcApplication;
/*      */   }
/*      */ 
/*      */   public String getDataSourceName()
/*      */   {
/* 1093 */     return this.dataSourceName;
/*      */   }
/*      */ 
/*      */   public JDBCTypeMappingMetaData getTypeMapping()
/*      */     throws DeploymentException
/*      */   {
/* 1103 */     if (this.datasourceMapping == null)
/*      */     {
/* 1105 */       throw new DeploymentException("type-mapping is not initialized: " + this.dataSourceName + " was not deployed or type-mapping was not configured.");
/*      */     }
/*      */ 
/* 1109 */     return this.datasourceMapping;
/*      */   }
/*      */ 
/*      */   public String getName()
/*      */   {
/* 1119 */     return this.entityName;
/*      */   }
/*      */ 
/*      */   public String getAbstractSchemaName()
/*      */   {
/* 1130 */     return this.abstractSchemaName;
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoader()
/*      */   {
/* 1142 */     return this.jdbcApplication.getClassLoader();
/*      */   }
/*      */ 
/*      */   public Class getEntityClass()
/*      */   {
/* 1152 */     return this.entityClass;
/*      */   }
/*      */ 
/*      */   public Class getHomeClass()
/*      */   {
/* 1162 */     return this.homeClass;
/*      */   }
/*      */ 
/*      */   public Class getRemoteClass()
/*      */   {
/* 1172 */     return this.remoteClass;
/*      */   }
/*      */ 
/*      */   public Class getLocalHomeClass()
/*      */   {
/* 1182 */     return this.localHomeClass;
/*      */   }
/*      */ 
/*      */   public Class getLocalClass()
/*      */   {
/* 1192 */     return this.localClass;
/*      */   }
/*      */ 
/*      */   public boolean isCMP1x()
/*      */   {
/* 1202 */     return this.isCMP1x;
/*      */   }
/*      */ 
/*      */   public List getCMPFields()
/*      */   {
/* 1212 */     return Collections.unmodifiableList(this.cmpFields);
/*      */   }
/*      */ 
/*      */   public String getEagerLoadGroup()
/*      */   {
/* 1223 */     return this.eagerLoadGroup;
/*      */   }
/*      */ 
/*      */   public List getLazyLoadGroups()
/*      */   {
/* 1233 */     return Collections.unmodifiableList(this.lazyLoadGroups);
/*      */   }
/*      */ 
/*      */   public Map getLoadGroups()
/*      */   {
/* 1244 */     return Collections.unmodifiableMap(this.loadGroups);
/*      */   }
/*      */ 
/*      */   public List getLoadGroup(String name)
/*      */     throws DeploymentException
/*      */   {
/* 1255 */     List group = (List)this.loadGroups.get(name);
/* 1256 */     if (group == null)
/*      */     {
/* 1258 */       throw new DeploymentException("Unknown load group: name=" + name);
/*      */     }
/* 1260 */     return group;
/*      */   }
/*      */ 
/*      */   public JDBCOptimisticLockingMetaData getOptimisticLocking()
/*      */   {
/* 1268 */     return this.optimisticLocking;
/*      */   }
/*      */ 
/*      */   public JDBCAuditMetaData getAudit()
/*      */   {
/* 1276 */     return this.audit;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldMetaData getCMPFieldByName(String name)
/*      */   {
/* 1287 */     return (JDBCCMPFieldMetaData)this.cmpFieldsByName.get(name);
/*      */   }
/*      */ 
/*      */   public String getDefaultTableName()
/*      */   {
/* 1297 */     return this.tableName;
/*      */   }
/*      */ 
/*      */   public boolean getCreateTable()
/*      */   {
/* 1308 */     return this.createTable;
/*      */   }
/*      */ 
/*      */   public boolean getRemoveTable()
/*      */   {
/* 1319 */     return this.removeTable;
/*      */   }
/*      */ 
/*      */   public boolean getAlterTable()
/*      */   {
/* 1328 */     return this.alterTable;
/*      */   }
/*      */ 
/*      */   public ArrayList getDefaultTablePostCreateCmd()
/*      */   {
/* 1339 */     return this.tablePostCreateCmd;
/*      */   }
/*      */ 
/*      */   public boolean hasPrimaryKeyConstraint()
/*      */   {
/* 1351 */     return this.primaryKeyConstraint;
/*      */   }
/*      */ 
/*      */   public boolean hasRowLocking()
/*      */   {
/* 1363 */     return this.rowLocking;
/*      */   }
/*      */ 
/*      */   public int getListCacheMax()
/*      */   {
/* 1371 */     return this.listCacheMax;
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */   {
/* 1380 */     return this.fetchSize;
/*      */   }
/*      */ 
/*      */   public Collection getQueries()
/*      */   {
/* 1391 */     return Collections.unmodifiableCollection(this.queries.values());
/*      */   }
/*      */ 
/*      */   public JDBCQueryMetaData getQueryMetaDataForMethod(Method method)
/*      */   {
/* 1400 */     return (JDBCQueryMetaData)this.queries.get(method);
/*      */   }
/*      */ 
/*      */   public Collection getRelationshipRoles()
/*      */   {
/* 1412 */     return this.jdbcApplication.getRolesForEntity(this.entityName);
/*      */   }
/*      */ 
/*      */   public Class getPrimaryKeyClass()
/*      */   {
/* 1422 */     return this.primaryKeyClass;
/*      */   }
/*      */ 
/*      */   public JDBCEntityCommandMetaData getEntityCommand()
/*      */   {
/* 1432 */     return this.entityCommand;
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly()
/*      */   {
/* 1443 */     return this.readOnly;
/*      */   }
/*      */ 
/*      */   public int getReadTimeOut()
/*      */   {
/* 1459 */     return this.readTimeOut;
/*      */   }
/*      */ 
/*      */   public String getPrimaryKeyFieldName()
/*      */   {
/* 1471 */     return this.primaryKeyFieldName;
/*      */   }
/*      */ 
/*      */   public JDBCReadAheadMetaData getReadAhead()
/*      */   {
/* 1482 */     return this.readAhead;
/*      */   }
/*      */ 
/*      */   public Class getQLCompiler()
/*      */   {
/* 1487 */     return this.qlCompiler;
/*      */   }
/*      */ 
/*      */   public boolean isThrowRuntimeExceptions()
/*      */   {
/* 1497 */     return this.throwRuntimeExceptions;
/*      */   }
/*      */ 
/*      */   public boolean getThrowRuntimeExceptions()
/*      */   {
/* 1506 */     return this.throwRuntimeExceptions;
/*      */   }
/*      */ 
/*      */   public boolean isCleanReadAheadOnLoad()
/*      */   {
/* 1512 */     return this.cleanReadAheadOnLoad;
/*      */   }
/*      */ 
/*      */   public static JDBCTypeMappingMetaData obtainTypeMappingFromLibrary(String dataSourceName)
/*      */     throws DeploymentException
/*      */   {
/* 1518 */     JDBCTypeMappingMetaData typeMapping = null;
/*      */     String datasource;
/* 1521 */     if (dataSourceName.startsWith("java:"))
/*      */     {
/* 1523 */       String datasource = dataSourceName.substring("java:".length());
/* 1524 */       if (datasource.startsWith("/"))
/*      */       {
/* 1526 */         datasource = datasource.substring(1);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1531 */       datasource = dataSourceName;
/* 1535 */     }
/*      */ String str = "jboss.jdbc:service=metadata,datasource=" + datasource;
/*      */     ObjectName metadataService;
/*      */     try {
/* 1538 */       metadataService = new ObjectName(str);
/*      */     }
/*      */     catch (MalformedObjectNameException e)
/*      */     {
/* 1542 */       throw new DeploymentException("Failed to create ObjectName for datasource metadata MBean: " + str, e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1547 */       MBeanServer server = MBeanServerLocator.locateJBoss();
/* 1548 */       if (server.isRegistered(metadataService))
/*      */       {
/* 1550 */         typeMapping = (JDBCTypeMappingMetaData)server.getAttribute(metadataService, "TypeMappingMetaData");
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1555 */       throw new DeploymentException("Failed to obtain type-mapping metadata from the metadata library MBean: " + e.getMessage(), e);
/*      */     }
/*      */ 
/* 1569 */     return typeMapping;
/*      */   }
/*      */ 
/*      */   public boolean equals(Object o)
/*      */   {
/* 1583 */     if ((o instanceof JDBCEntityMetaData))
/*      */     {
/* 1585 */       JDBCEntityMetaData entity = (JDBCEntityMetaData)o;
/* 1586 */       return (this.entityName.equals(entity.entityName)) && (this.jdbcApplication.equals(entity.jdbcApplication));
/*      */     }
/*      */ 
/* 1589 */     return false;
/*      */   }
/*      */ 
/*      */   public int hashCode()
/*      */   {
/* 1601 */     int result = 17;
/* 1602 */     result = 37 * result + this.jdbcApplication.hashCode();
/* 1603 */     result = 37 * result + this.entityName.hashCode();
/* 1604 */     return result;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1618 */     return "[JDBCEntityMetaData : entityName=" + this.entityName + "]";
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData
 * JD-Core Version:    0.6.0
 */