/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCEntityCommandMetaData
/*     */ {
/*     */   private final String commandName;
/*     */   private final Class commandClass;
/*  48 */   private final HashMap attributes = new HashMap();
/*     */ 
/*     */   public JDBCEntityCommandMetaData(Element element)
/*     */     throws DeploymentException
/*     */   {
/*  61 */     this.commandName = element.getAttribute("name");
/*  62 */     if (this.commandName.trim().length() < 1)
/*     */     {
/*  64 */       throw new DeploymentException("entity-command element must have  not empty name attribute");
/*     */     }
/*     */ 
/*  68 */     String commandClassStr = element.getAttribute("class");
/*  69 */     if (commandClassStr != null)
/*     */     {
/*     */       try
/*     */       {
/*  73 */         this.commandClass = GetTCLAction.getContextClassLoader().loadClass(commandClassStr);
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/*  76 */         throw new DeploymentException("Could not load class: " + commandClassStr);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/*  82 */       this.commandClass = null;
/*     */     }
/*     */ 
/*  86 */     Iterator iter = MetaData.getChildrenByTagName(element, "attribute");
/*  87 */     while (iter.hasNext())
/*     */     {
/*  89 */       Element attrEl = (Element)iter.next();
/*     */ 
/*  92 */       String attrName = attrEl.getAttribute("name");
/*  93 */       if (attrName == null)
/*     */       {
/*  95 */         throw new DeploymentException("entity-command " + this.commandName + " has an attribute with no name");
/*     */       }
/*     */ 
/* 100 */       String attrValue = MetaData.getElementContent(attrEl);
/*     */ 
/* 102 */       this.attributes.put(attrName, attrValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCEntityCommandMetaData(Element element, JDBCEntityCommandMetaData defaultValues)
/*     */     throws DeploymentException
/*     */   {
/* 116 */     this.commandName = defaultValues.getCommandName();
/*     */ 
/* 118 */     String commandClassStr = element.getAttribute("class");
/* 119 */     if ((commandClassStr != null) && (commandClassStr.trim().length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 124 */         this.commandClass = GetTCLAction.getContextClassLoader().loadClass(commandClassStr);
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/* 127 */         throw new DeploymentException("Could not load class: " + commandClassStr);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 133 */       this.commandClass = defaultValues.getCommandClass();
/*     */     }
/*     */ 
/* 137 */     this.attributes.putAll(defaultValues.attributes);
/* 138 */     Iterator iter = MetaData.getChildrenByTagName(element, "attribute");
/* 139 */     while (iter.hasNext())
/*     */     {
/* 141 */       Element attrEl = (Element)iter.next();
/*     */ 
/* 144 */       String attrName = attrEl.getAttribute("name");
/* 145 */       if (attrName == null)
/*     */       {
/* 147 */         throw new DeploymentException("entity-command " + this.commandName + " has an attribute with no name");
/*     */       }
/*     */ 
/* 152 */       String attrValue = MetaData.getElementContent(attrEl);
/*     */ 
/* 154 */       this.attributes.put(attrName, attrValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getCommandName()
/*     */   {
/* 164 */     return this.commandName;
/*     */   }
/*     */ 
/*     */   public Class getCommandClass()
/*     */   {
/* 171 */     return this.commandClass;
/*     */   }
/*     */ 
/*     */   public String getAttribute(String name)
/*     */   {
/* 179 */     return (String)this.attributes.get(name);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 186 */     return "[commandName=" + this.commandName + ",commandClass=" + this.commandClass + ",attributes=" + this.attributes.toString() + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData
 * JD-Core Version:    0.6.0
 */